package ai.libs.jaicore.search.algorithms.standard.uncertainty.explorationexploitationsearch;

import java.util.List;
import java.util.Queue;

import ai.libs.jaicore.search.algorithms.standard.uncertainty.ISolutionDistanceMetric;
import ai.libs.jaicore.search.model.travesaltree.BackPointerPath;

@FunctionalInterface
public interface IExplorationCandidateSelector<T, A, V extends Comparable<V>> {

	public List<BackPointerPath<T, A, V>> selectExplorationCandidates(Queue<BackPointerPath<T, A, V>> allCandidates, BackPointerPath<T, A, V> bestCandidate, ISolutionDistanceMetric<T> solutionDistanceMetric);

}
