package ai.libs.jaicore.search.algorithms.standard.uncertainty.explorationexploitationsearch;

public interface IPhaseLengthAdjuster {
	
	/**
	 * Called before the search to set the phase lengths initially.
	 * @param interval Overall length of both phases combined.
	 * @return An array with two elements [newExplorationPhaseLength, newExploitationPhaseLength] to adjust the phase lengths.
	 */
	public int[] getInitialPhaseLengths(int interval);
	
	/**
	 * Called on every complete iteration of an exploration and an exploitation phase to determine how to change the phase lengths.
	 * @param currentExplorationLength Current length of the exploration phase.
	 * @param currentExploitationLength Current length of the exploitation phase.
	 * @param passedTime Passed time of the search.
	 * @param timout Timeout for the search.
	 * @return An array with two elements [newExplorationPhaseLength, newExploitationPhaseLength] to adjust the phase lengths.
	 */
	public int[] adjustPhaseLength (int currentExplorationLength, int currentExploitationLength, long passedTime, long timeout);
}
