/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.mdp.mcts;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.search.model.ILazyRandomizableSuccessorGenerator;
import ai.libs.jaicore.search.model.other.SearchGraphPath;
import ai.libs.jaicore.search.probleminputs.IMDP;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.api4.java.ai.graphsearch.problem.IPathSearchWithPathEvaluationsInput;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.IPathGoalTester;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.PathEvaluationException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.graph.implicit.ILazySuccessorGenerator;
import org.api4.java.datastructure.graph.implicit.INewNodeDescription;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphBasedMDP<N, A>
implements IMDP<N, A, Double>,
ILoggingCustomizable {
    private static final int MAX_SUCCESSOR_CACHE_SIZE = 100;
    private final IPathSearchWithPathEvaluationsInput<N, A, Double> graph;
    private final N root;
    private final ISuccessorGenerator<N, A> succGen;
    private final IPathGoalTester<N, A> goalTester;
    private final Map<N, Pair<N, A>> backPointers = new HashMap<N, Pair<N, A>>();
    private Logger logger = LoggerFactory.getLogger(GraphBasedMDP.class);
    private final Map<N, Map<A, N>> successorCache = new HashMap<N, Map<A, N>>();
    private final boolean lazy;
    private final ILazySuccessorGenerator<N, A> lazySuccGen;

    public GraphBasedMDP(IPathSearchWithPathEvaluationsInput<N, A, Double> graph) {
        this.graph = graph;
        this.root = ((ISingleRootGenerator)this.graph.getGraphGenerator().getRootGenerator()).getRoot();
        this.succGen = graph.getGraphGenerator().getSuccessorGenerator();
        this.goalTester = graph.getGoalTester();
        this.lazySuccGen = this.succGen instanceof ILazySuccessorGenerator ? (ILazySuccessorGenerator)this.succGen : null;
        this.lazy = this.lazySuccGen != null;
    }

    @Override
    public N getInitState() {
        return this.root;
    }

    @Override
    public boolean isMaximizing() {
        return false;
    }

    @Override
    public Collection<A> getApplicableActions(N state) throws InterruptedException {
        this.logger.debug("Computing applicable actions.");
        List successors = this.succGen.generateSuccessors(state);
        ArrayList<Object> actions = new ArrayList<Object>();
        HashMap<Object, Object> cache = new HashMap<Object, Object>();
        if (Thread.interrupted()) {
            throw new InterruptedException("The computation of applicable actions has been interrupted.");
        }
        long lastInterruptCheck = System.currentTimeMillis();
        for (INewNodeDescription succ : successors) {
            Object action = succ.getArcLabel();
            actions.add(action);
            cache.put(action, succ.getTo());
            long now = System.currentTimeMillis();
            if (lastInterruptCheck < now - 10L) {
                lastInterruptCheck = now;
                if (Thread.interrupted()) {
                    throw new InterruptedException("The computation of applicable actions has been interrupted.");
                }
            }
            if (this.backPointers.containsKey(succ.getTo())) {
                Pair<N, A> backpointer = this.backPointers.get(succ.getTo());
                boolean sameParent = backpointer.getX().equals(state);
                boolean sameAction = backpointer.getY().equals(action);
                if (!sameParent || !sameAction) {
                    Object otherNode = null;
                    for (N key : this.backPointers.keySet()) {
                        now = System.currentTimeMillis();
                        if (lastInterruptCheck < now - 10L) {
                            lastInterruptCheck = now;
                            if (Thread.interrupted()) {
                                throw new InterruptedException("The computation of applicable actions has been interrupted.");
                            }
                        }
                        if (!key.equals(succ.getTo())) continue;
                        otherNode = key;
                        break;
                    }
                    throw new IllegalStateException("Reaching state " + succ.getTo() + " on a second way, which must not be the case in trees!\n\t1st way: " + backpointer.getX() + "; " + backpointer.getY() + "\n\t2nd way: " + state + "; " + action + "\n\ttoString of existing node: " + otherNode + "\n\tSame parent: " + sameParent + "\n\tSame Action: " + sameAction);
                }
            }
            this.logger.debug("Setting backpointer from {} to {}", succ.getTo(), state);
            this.backPointers.put(succ.getTo(), new Pair(state, action));
        }
        if (this.successorCache.size() > 100) {
            this.successorCache.clear();
        }
        this.successorCache.put(state, cache);
        return actions;
    }

    @Override
    public Map<N, Double> getProb(N state, A action) throws InterruptedException {
        Object successor = null;
        if (this.successorCache.containsKey(state) && this.successorCache.get(state).containsKey(action)) {
            successor = this.successorCache.get(state).get(action);
        } else {
            Optional<INewNodeDescription> succOpt = this.succGen.generateSuccessors(state).stream().filter(nd -> nd.getArcLabel().equals(action)).findAny();
            if (!succOpt.isPresent()) {
                this.logger.error("THERE IS NO SUCCESSOR REACHABLE WITH ACTION {} IN THE MDP!", action);
                return null;
            }
            successor = succOpt.get().getTo();
        }
        HashMap<Object, Double> out = new HashMap<Object, Double>();
        out.put(successor, 1.0);
        return out;
    }

    @Override
    public double getProb(N state, A action, N successor) throws InterruptedException {
        return this.getProb(state, action).containsKey(successor) ? 1.0 : 0.0;
    }

    @Override
    public Double getScore(N state, A action, N successor) throws PathEvaluationException, InterruptedException {
        this.logger.info("Getting score for SAS-triple ({}, {}, {})", new Object[]{state, action, successor});
        Object cur = successor;
        ArrayList<N> nodes = new ArrayList<N>();
        ArrayList<Object> arcs = new ArrayList<Object>();
        nodes.add(cur);
        while (cur != this.root) {
            Pair<N, A> parentEdge = this.backPointers.get(cur);
            if (parentEdge == null) {
                throw new NullPointerException("No back pointer defined for non-root node " + cur);
            }
            cur = parentEdge.getX();
            nodes.add(0, cur);
            arcs.add(0, parentEdge.getY());
        }
        SearchGraphPath path = new SearchGraphPath(nodes, arcs);
        if (!this.goalTester.isGoal(path)) {
            boolean isTerminal = this.isTerminalState(path.getHead());
            if (isTerminal) {
                this.logger.debug("Found dead end! Returning null.");
                return null;
            }
            this.logger.info("Path {} is not a goal path, returning 0.0", path);
            return 0.0;
        }
        this.logger.info("Path is a goal path, invoking path evaluator.");
        double score = (Double)this.graph.getPathEvaluator().evaluate(path);
        this.logger.info("Obtained score {} for path", (Object)score);
        return score;
    }

    @Override
    public boolean isTerminalState(N state) throws InterruptedException {
        if (this.lazy) {
            this.logger.debug("Determining terminal state condition for lazy graph generator.");
            return !this.lazySuccGen.getIterativeGenerator(state).hasNext();
        }
        return this.succGen.generateSuccessors(state).isEmpty();
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        if (this.succGen instanceof ILoggingCustomizable) {
            this.logger.info("Setting logger of successor generator to {}.gg", (Object)name);
            ((ILoggingCustomizable)this.succGen).setLoggerName(name + ".gg");
        }
        if (this.goalTester instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.goalTester).setLoggerName(name + ".gt");
        }
        if (this.graph.getPathEvaluator() instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.graph.getPathEvaluator()).setLoggerName(name + ".pe");
        }
    }

    @Override
    public A getUniformlyRandomApplicableAction(N state, Random random) throws InterruptedException {
        if (this.succGen instanceof ILazyRandomizableSuccessorGenerator) {
            INewNodeDescription ne = ((ILazyRandomizableSuccessorGenerator)this.succGen).getIterativeGenerator(state, random).next();
            if (this.successorCache.size() > 100) {
                this.successorCache.clear();
            }
            this.successorCache.computeIfAbsent(state, n -> new HashMap()).put(ne.getArcLabel(), ne.getTo());
            this.backPointers.put(ne.getTo(), new Pair(state, ne.getArcLabel()));
            return (A)ne.getArcLabel();
        }
        this.logger.debug("The successor generator {} does not support lazy AND randomized successor generation. Now computing all successors and drawing one at random.", this.succGen.getClass());
        Collection<A> actions = this.getApplicableActions(state);
        if (actions.isEmpty()) {
            throw new IllegalArgumentException("The given node has no successors: " + state);
        }
        return (A)SetUtil.getRandomElement(actions, (Random)random);
    }

    @Override
    public boolean isActionApplicableInState(N state, A action) throws InterruptedException {
        if (this.successorCache.containsKey(state) && this.successorCache.get(state).containsKey(action)) {
            return true;
        }
        return this.getApplicableActions(state).contains(action);
    }
}

