/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.mdp.mcts;

import ai.libs.jaicore.basic.algorithm.AAlgorithmFactory;
import ai.libs.jaicore.search.algorithms.mdp.mcts.IPolicy;
import ai.libs.jaicore.search.algorithms.mdp.mcts.MCTS;
import ai.libs.jaicore.search.algorithms.mdp.mcts.UniformRandomPolicy;
import ai.libs.jaicore.search.probleminputs.IMDP;
import java.util.Random;

public abstract class MCTSFactory<N, A, B extends MCTSFactory<N, A, B>>
extends AAlgorithmFactory<IMDP<N, A, Double>, IPolicy<N, A>, MCTS<N, A>> {
    private int maxIterations = Integer.MAX_VALUE;
    private double gamma = 1.0;
    private double epsilon = 0.0;
    private Random random = new Random(0L);
    private boolean tabooExhaustedNodes = false;
    private boolean maximize = false;
    private IPolicy<N, A> defaultPolicy;

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public B withMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
        return this.getSelf();
    }

    public double getGamma() {
        return this.gamma;
    }

    public B withGamma(double gamma) {
        this.gamma = gamma;
        return this.getSelf();
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public B withEpsilon(double epsilon) {
        this.epsilon = epsilon;
        return this.getSelf();
    }

    public B maximize() {
        this.maximize = true;
        return this.getSelf();
    }

    public B minimize() {
        this.maximize = false;
        return this.getSelf();
    }

    public boolean isMaximize() {
        return this.maximize;
    }

    public Random getRandom() {
        return this.random;
    }

    public B withRandom(Random random) {
        this.random = random;
        return this.getSelf();
    }

    public boolean isTabooExhaustedNodes() {
        return this.tabooExhaustedNodes;
    }

    public B withTabooExhaustedNodes(boolean tabooExhaustedNodes) {
        this.tabooExhaustedNodes = tabooExhaustedNodes;
        return this.getSelf();
    }

    public B withDefaultPolicy(IPolicy<N, A> defaultPolicy) {
        this.defaultPolicy = defaultPolicy;
        return this.getSelf();
    }

    public IPolicy<N, A> getDefaultPolicy() {
        return this.getDefaultPolicy(false);
    }

    public IPolicy<N, A> getDefaultPolicy(boolean instantiateUniformIfNotSet) {
        if (this.defaultPolicy != null || !instantiateUniformIfNotSet) {
            return this.defaultPolicy;
        }
        return new UniformRandomPolicy(this.random);
    }

    public MCTS<N, A> getAlgorithm() {
        throw new UnsupportedOperationException();
    }

    public B getSelf() {
        return (B)((Object)this);
    }
}

