/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.mdp.mcts;

import java.util.HashMap;
import java.util.Map;

public class NodeLabel<A> {
    private int visits = 0;
    private Map<A, Integer> numberOfChoicesPerAction = new HashMap<A, Integer>();
    private Map<A, Double> accumulatedRewardsOfAction = new HashMap<A, Double>();

    public int getVisits() {
        return this.visits;
    }

    public void setVisits(int visits) {
        this.visits = visits;
    }

    public Map<A, Integer> getNumberOfChoicesPerAction() {
        return this.numberOfChoicesPerAction;
    }

    public void setNumberOfChoicesPerAction(Map<A, Integer> numberOfChoicesPerAction) {
        this.numberOfChoicesPerAction = numberOfChoicesPerAction;
    }

    public double getAccumulatedRewardsOfAction(A action) {
        return this.accumulatedRewardsOfAction.computeIfAbsent(action, a -> 0.0);
    }

    public void setAccumulatedRewardsOfAction(Map<A, Double> accumulatedRewardsOfAction) {
        this.accumulatedRewardsOfAction = accumulatedRewardsOfAction;
    }

    public int getNumPulls(A action) {
        return this.numberOfChoicesPerAction.computeIfAbsent(action, a -> 0);
    }

    public boolean isVirgin(A action) {
        return !this.numberOfChoicesPerAction.containsKey(action);
    }

    public double getAverageRewardOfAction(A action) {
        return this.getAccumulatedRewardsOfAction(action) / (double)this.getNumPulls(action);
    }

    public void addRewardForAction(A action, double reward) {
        this.accumulatedRewardsOfAction.put(action, this.getAccumulatedRewardsOfAction(action) + reward);
    }

    public void addVisit() {
        ++this.visits;
    }

    public void addPull(A a) {
        this.numberOfChoicesPerAction.put(a, this.numberOfChoicesPerAction.computeIfAbsent(a, ac -> 0) + 1);
    }
}

