/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.mdp.mcts;

import ai.libs.jaicore.basic.IRandomizable;
import ai.libs.jaicore.search.algorithms.mdp.mcts.IPolicy;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.api4.java.common.control.ILoggingCustomizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniformRandomPolicy<N, A, V extends Comparable<V>>
implements IPolicy<N, A>,
IRandomizable,
ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(UniformRandomPolicy.class);
    private final Random r;

    public UniformRandomPolicy() {
        this(new Random());
    }

    public UniformRandomPolicy(Random r) {
        this.r = r;
    }

    @Override
    public A getAction(N node, Collection<A> actions) {
        Object choice;
        this.logger.debug("Deriving action for node {}. Options are: {}", node, actions);
        if (actions.isEmpty()) {
            throw new IllegalArgumentException("Cannot determine action if no actions are given!");
        }
        if (actions.size() == 1) {
            return actions.iterator().next();
        }
        int chosenIndex = this.r.nextInt(actions.size());
        if (actions instanceof List) {
            choice = ((List)actions).get(chosenIndex);
        } else {
            Iterator<A> it = actions.iterator();
            for (int i = 0; i < chosenIndex; ++i) {
                it.next();
            }
            choice = it.next();
        }
        this.logger.info("Recommending action {}", choice);
        return (A)choice;
    }

    public void updatePath(List<N> path, V score) {
        this.logger.debug("Updating path {} with score {}", path, score);
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }

    public Random getRandom() {
        return this.r;
    }

    public void setRandom(Random random) {
        throw new UnsupportedOperationException("Random source cannot be overwritten.");
    }
}

