/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.mdp.mcts.comparison;

import ai.libs.jaicore.search.algorithms.mdp.mcts.MCTS;
import ai.libs.jaicore.search.algorithms.mdp.mcts.MCTSFactory;
import ai.libs.jaicore.search.algorithms.mdp.mcts.comparison.IPreferenceKernel;
import ai.libs.jaicore.search.algorithms.mdp.mcts.comparison.PlackettLuceMCTS;
import ai.libs.jaicore.search.probleminputs.IMDP;
import java.util.Random;

public class PlackettLuceMCTSFactory<N, A>
extends MCTSFactory<N, A, PlackettLuceMCTSFactory<N, A>> {
    private IPreferenceKernel<N, A> preferenceKernel;

    public PlackettLuceMCTSFactory() {
        this.withTabooExhaustedNodes(true);
    }

    public IPreferenceKernel<N, A> getPreferenceKernel() {
        return this.preferenceKernel;
    }

    public PlackettLuceMCTSFactory<N, A> withPreferenceKernel(IPreferenceKernel<N, A> preferenceKernel) {
        this.preferenceKernel = preferenceKernel;
        return this;
    }

    public MCTS<N, A> getAlgorithm(IMDP<N, A, Double> input) {
        if (this.preferenceKernel == null) {
            throw new IllegalStateException("Cannot build PL-MCTS since no preference kernel has been set.");
        }
        return new PlackettLuceMCTS<N, A>(input, this.getDefaultPolicy(true), this.preferenceKernel, this.getMaxIterations(), this.getGamma(), this.getEpsilon(), new Random(this.getRandom().nextLong()), this.isTabooExhaustedNodes());
    }
}

