/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.mdp.mcts.comparison;

import ai.libs.jaicore.basic.IOwnerBasedAlgorithmConfig;
import ai.libs.jaicore.basic.MathExt;
import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.graph.LabeledGraph;
import ai.libs.jaicore.graphvisualizer.events.graph.GraphEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodePropertyChangedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeRemovedEvent;
import ai.libs.jaicore.math.probability.pl.PLInferenceProblem;
import ai.libs.jaicore.math.probability.pl.PLInferenceProblemEncoder;
import ai.libs.jaicore.math.probability.pl.PLMMAlgorithm;
import ai.libs.jaicore.search.algorithms.mdp.mcts.ActionPredictionFailedException;
import ai.libs.jaicore.search.algorithms.mdp.mcts.IPathUpdatablePolicy;
import ai.libs.jaicore.search.algorithms.mdp.mcts.IRolloutLimitDependentPolicy;
import ai.libs.jaicore.search.algorithms.mdp.mcts.comparison.CombinedGammaFunction;
import ai.libs.jaicore.search.algorithms.mdp.mcts.comparison.CosLinGammaFunction;
import ai.libs.jaicore.search.algorithms.mdp.mcts.comparison.IGammaFunction;
import ai.libs.jaicore.search.algorithms.mdp.mcts.comparison.IPreferenceKernel;
import ai.libs.jaicore.search.algorithms.mdp.mcts.comparison.preferencekernel.bootstrapping.BootstrappingPreferenceKernel;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aeonbits.owner.ConfigFactory;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.common.event.IRelaxedEventEmitter;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlackettLucePolicy<N, A>
implements IPathUpdatablePolicy<N, A, Double>,
ILoggingCustomizable,
IRelaxedEventEmitter,
IRolloutLimitDependentPolicy {
    private boolean hasListeners = false;
    private final EventBus eventBus = new EventBus();
    public static final String VAR_COMMITMENT = "commitment";
    private Logger logger = LoggerFactory.getLogger(PlackettLucePolicy.class);
    private final IPreferenceKernel<N, A> preferenceKernel;
    private final Set<N> nodesForWhichAnActionHasBeenRequested = new HashSet<N>();
    private final LabeledGraph<N, A> activeTree = new LabeledGraph();
    private final Map<N, Map<A, Double>> skillsForActions = new HashMap<N, Map<A, Double>>();
    private final Map<N, Map<A, Integer>> numPulls = new HashMap<N, Map<A, Integer>>();
    private final Map<N, A> fixedDecisions = new HashMap<N, A>();
    private final Map<N, Pair<A, Integer>> sequentialCertaintyCounts = new HashMap<N, Pair<A, Integer>>();
    private final Map<N, Double> deepestRelativeNodeDepthsOfNodes = new HashMap<N, Double>();
    private final Map<N, Map<A, Double>> lastLocalProbabilityOfNode = new HashMap<N, Map<A, Double>>();
    private final Map<N, Integer> depths = new HashMap<N, Integer>();
    private final Random random;
    private IOwnerBasedAlgorithmConfig config = (IOwnerBasedAlgorithmConfig)ConfigFactory.create(IOwnerBasedAlgorithmConfig.class, (Map[])new Map[0]);
    private final Map<N, Integer> maxChildren = new HashMap<N, Integer>();
    private double avgDepth;
    private double avgTargetDepth;
    private double avgBranchingFactor = -1.0;
    private int numUpdates;
    private Function<Integer, Integer> rolloutsForGammaEquals1AsFunctionOfHeight = d -> 1000;
    private static final int GAMMA_LONG_MAX = 2;
    private static final int GAMMA_LONG_MIN_OBSERVATIONS_PER_CHILD_FOR_SUPPORT_INIT = 1;
    private static final int GAMMA_LONG_MIN_OBSERVATIONS_PER_CHILD_FOR_SUPPORT_ABS = 10;
    private static final int GAMMA_LONG_OBSERVATIONS_PER_CHILD_TO_REACH_ONE = 10;
    private static final double GAMMA_LONG_DERIVATIVE_EXP = 1.0;
    private static final double GOAL_COMMIT_DEPTH = 1.2;
    private static final int GOAL_TARGET_SIZE = (int)Math.pow(2.0, 5.0);
    private static final int MINIMUMNUMBERTOCOMMIT = 20;

    public PlackettLucePolicy(IPreferenceKernel<N, A> preferenceKernel, Random random) {
        this.preferenceKernel = preferenceKernel;
        this.random = random;
        if (preferenceKernel instanceof IRelaxedEventEmitter) {
            ((IRelaxedEventEmitter)preferenceKernel).registerListener(new Object(){

                @Subscribe
                public void receiveEvent(GraphEvent event) {
                    PlackettLucePolicy.this.eventBus.post((Object)event);
                }
            });
        }
    }

    public IGammaFunction getGammaFunction(N node, Collection<A> actions) {
        int obsRequiredForOne;
        int k = actions.size();
        int depth = this.depths.get(node);
        int numberOfOpenDecisions = depth - this.fixedDecisions.size();
        boolean isInDecisionMode = (double)numberOfOpenDecisions < this.avgTargetDepth;
        int n = obsRequiredForOne = isInDecisionMode ? this.rolloutsForGammaEquals1AsFunctionOfHeight.apply(depth) : 1;
        if (isInDecisionMode && obsRequiredForOne < 1) {
            this.logger.warn("Cannot work on this problem with {} open decisions, because even the minimum required observations ({}) are higher than the number of observations required to reach one ({}). Setting value to minimum + 1 = {}", new Object[]{numberOfOpenDecisions, 1, obsRequiredForOne, 2});
        }
        if (obsRequiredForOne < 0) {
            obsRequiredForOne = 100000;
        }
        obsRequiredForOne = Math.max(10 * k, obsRequiredForOne);
        int minObservationsToSupportGamma = 1 * k;
        minObservationsToSupportGamma = Math.max(minObservationsToSupportGamma, Math.max(minObservationsToSupportGamma * 2 / 3, obsRequiredForOne - 100));
        return new CosLinGammaFunction(2.0, obsRequiredForOne, minObservationsToSupportGamma, k * 10);
    }

    public double getGammaValue(N node, Collection<A> actions) {
        Map<A, Integer> numPullsPerAction = this.numPulls.get(node);
        int visits = 0;
        for (int pulls : numPullsPerAction.values()) {
            visits += pulls;
        }
        IGammaFunction gammaFunction = this.getGammaFunction(node, actions);
        double relativeDepth = this.deepestRelativeNodeDepthsOfNodes.get(node);
        double nodeProbability = this.getProbabilityOfNode(node);
        return gammaFunction.getNodeGamma(visits, nodeProbability, relativeDepth);
    }

    @Override
    public A getAction(N node, Collection<A> actions) throws ActionPredictionFailedException {
        long start = System.currentTimeMillis();
        HashMap<String, Number> nodeInfoMap = new HashMap<String, Number>();
        if (!this.depths.containsKey(node)) {
            throw new IllegalArgumentException("No depth information for node " + node + ". The node has apparently not occured in any back-propagation!");
        }
        int depth = this.depths.get(node);
        this.logger.info("Determining action for node in depth {}. {} actions available. Node info: {}", new Object[]{depth, actions.size(), node});
        if (!this.nodesForWhichAnActionHasBeenRequested.contains(node)) {
            this.logger.debug("Mark node {} as one for which an action has been requested!", node);
            this.nodesForWhichAnActionHasBeenRequested.add(node);
            this.preferenceKernel.signalNodeActiveness(node);
            if (!this.maxChildren.containsKey(node)) {
                this.maxChildren.put(node, actions.size());
            }
        }
        if (this.fixedDecisions.containsKey(node)) {
            this.logger.info("Choosing fixed action {}", this.fixedDecisions.get(node));
            return this.fixedDecisions.get(node);
        }
        if (!this.preferenceKernel.canProduceReliableRankings(node, actions)) {
            this.logger.info("The preference kernel tells us that it cannot produce reliable information yet. Choosing one that seems most useful to the preference kernel.");
            return this.preferenceKernel.getMostImportantActionToObtainApplicability(node, actions);
        }
        Map lastProbabilities = this.lastLocalProbabilityOfNode.computeIfAbsent(node, dummy -> new HashMap());
        int k = actions.size();
        double maxProb = lastProbabilities.isEmpty() ? 1.0 / (double)k : (Double)lastProbabilities.values().stream().max(Double::compare).get();
        double probabilityToDerivePLModel = (double)k * (1.0 - maxProb) / (double)(k - 1);
        this.logger.info("Probability to derive a new model is {}*(1-{}) / ({} - 1) = {}. Last probs were: {}", new Object[]{k, maxProb, k, probabilityToDerivePLModel, lastProbabilities});
        List<Object> orderedActions = actions instanceof List ? (List<Object>)actions : new ArrayList<A>(actions);
        try {
            Map<A, Double> skills;
            int numChildren = actions.size();
            IGammaFunction gammaFunction = this.getGammaFunction(node, actions);
            double relativeDepth = this.deepestRelativeNodeDepthsOfNodes.get(node);
            double nodeProbability = this.getProbabilityOfNode(node);
            double gammaValue = this.getGammaValue(node, actions);
            if (this.hasListeners) {
                if (gammaFunction instanceof CombinedGammaFunction) {
                    double lgw = ((CombinedGammaFunction)gammaFunction).getLongTermWeightBasedOnProbability(nodeProbability);
                    nodeInfoMap.put("longgammaweight", lgw);
                }
                nodeInfoMap.put("gamma", gammaValue);
                nodeInfoMap.put("prob", nodeProbability);
            }
            if (gammaValue == 0.0) {
                this.logger.info("Gamma is 0, so all options have equal probability of being chosen. Just return a random element.");
                nodeInfoMap.put(VAR_COMMITMENT, 0);
                this.eventBus.post((Object)new NodePropertyChangedEvent(null, node, nodeInfoMap));
                return (A)SetUtil.getRandomElement((Collection)orderedActions, (Random)this.random);
            }
            if (numChildren <= 1) {
                if (numChildren < 1) {
                    throw new UnsupportedOperationException("Cannot compute action for nodes without successors.");
                }
                if (orderedActions.size() != 1) {
                    throw new IllegalStateException();
                }
                nodeInfoMap.put(VAR_COMMITMENT, 1);
                this.eventBus.post((Object)new NodePropertyChangedEvent(null, node, nodeInfoMap));
                return (A)orderedActions.iterator().next();
            }
            long skillEstimateStart = System.currentTimeMillis();
            long mmRuntime = 0L;
            if (this.random.nextDouble() <= probabilityToDerivePLModel) {
                this.logger.debug("Computing PL-Problem instance");
                PLInferenceProblemEncoder encoder = new PLInferenceProblemEncoder();
                PLInferenceProblem problem = encoder.encode(this.preferenceKernel.getRankingsForActions(node, orderedActions));
                this.logger.debug("Start computation of skills for {}. Using {} rankings. Gamma value is {} based on node probability {} and depth {}", new Object[]{node, problem.getRankings().size(), gammaValue, nodeProbability, relativeDepth});
                skills = this.skillsForActions.get(node);
                long mmStart = System.currentTimeMillis();
                PLMMAlgorithm plAlgorithm = new PLMMAlgorithm(problem, (DoubleList)(skills != null ? new DoubleArrayList((Collection)orderedActions.stream().map(skills::get).collect(Collectors.toList())) : null), this.config);
                plAlgorithm.setLoggerName(this.getLoggerName() + ".pl");
                DoubleList skillVector = plAlgorithm.call();
                mmRuntime = System.currentTimeMillis() - mmStart;
                if (skillVector.size() != problem.getNumObjects()) {
                    throw new IllegalStateException("Have " + skills.size() + " skills (" + skills + ") for " + problem.getNumObjects() + " objects.");
                }
                if (skills == null) {
                    skills = new HashMap<A, Double>();
                    this.skillsForActions.put(node, skills);
                }
                for (Object e : orderedActions) {
                    skills.put(e, skillVector.getDouble((int)encoder.getIndexOfObject(e)));
                }
            } else {
                skills = this.skillsForActions.get(node);
                this.logger.info("Reusing skill vetor of last iteration. Probability for reuse was {}. Skill map is: {}", (Object)(1.0 - probabilityToDerivePLModel), skills);
            }
            long skillEstimateRuntime = System.currentTimeMillis() - skillEstimateStart;
            Objects.requireNonNull(skills, "The skill map must not be null at this point.");
            long choiceStart = System.currentTimeMillis();
            int n = skills.size();
            double sum = 0.0;
            HashMap<A, Double> hashMap = new HashMap<A, Double>();
            for (Map.Entry<A, Double> skillValue : skills.entrySet()) {
                double newVal = Math.pow(skillValue.getValue(), gammaValue);
                hashMap.put(skillValue.getKey(), newVal);
                sum += newVal;
            }
            if (sum == 0.0) {
                throw new IllegalStateException();
            }
            DoubleArrayList pVector = new DoubleArrayList();
            double curMaxProb = 0.0;
            for (Object e : orderedActions) {
                double newProbOfAction = (Double)hashMap.get(e) / sum;
                curMaxProb = Math.max(curMaxProb, newProbOfAction);
                if (Double.isNaN(newProbOfAction)) {
                    this.logger.error("Probability of successor is NaN! Skill vector: {}", skills);
                }
                lastProbabilities.put(e, newProbOfAction);
                pVector.add(newProbOfAction);
            }
            double commitment = 1.0 - (double)k * (1.0 - curMaxProb) / (double)(k - 1);
            if (depth == 1) {
                for (Map.Entry entry : ((BootstrappingPreferenceKernel)this.preferenceKernel).getObservations(node).entrySet()) {
                    DescriptiveStatistics stats = new DescriptiveStatistics();
                    DoubleListIterator doubleListIterator = entry.getValue().iterator();
                    while (doubleListIterator.hasNext()) {
                        double v = (Double)doubleListIterator.next();
                        stats.addValue(v);
                    }
                }
            }
            nodeInfoMap.put(VAR_COMMITMENT, commitment);
            this.eventBus.post((Object)new NodePropertyChangedEvent(null, node, nodeInfoMap));
            Object randomChoice = SetUtil.getRandomElement((List)orderedActions, (Random)this.random, (List)pVector);
            int chosenIndex = orderedActions.indexOf(randomChoice);
            double probOfChosenAction = pVector.getDouble(chosenIndex);
            long choiceRuntime = System.currentTimeMillis() - choiceStart;
            long runtime = System.currentTimeMillis() - start;
            long metaStart = System.currentTimeMillis();
            if (gammaValue >= 1.0) {
                Pair<A, Integer> lastChosenAction = this.sequentialCertaintyCounts.get(node);
                if (lastChosenAction != null) {
                    if (lastChosenAction.getX().equals(randomChoice) && probOfChosenAction >= 0.99 && (!this.activeTree.hasItem(node) || this.activeTree.getRoot() == node || this.fixedDecisions.containsKey(this.activeTree.getPredecessors(node).iterator().next()))) {
                        this.logger.info("Incrementing number of sure choices for this action by 1.");
                        int numberOfSuccessfulChoices = (Integer)lastChosenAction.getY();
                        if (numberOfSuccessfulChoices >= 20) {
                            this.sequentialCertaintyCounts.remove(node);
                            this.logger.warn("Definitely committing to action {} in node {} in depth {}. Freeing resources.", new Object[]{randomChoice, node, this.fixedDecisions.size()});
                            this.fixedDecisions.put(node, randomChoice);
                            this.preferenceKernel.clearKnowledge(node);
                            ArrayList irrelevantNodes = new ArrayList();
                            irrelevantNodes.addAll(this.activeTree.getSiblings(node));
                            ArrayList descendants = new ArrayList();
                            irrelevantNodes.forEach(ni -> descendants.addAll(this.activeTree.getDescendants(ni)));
                            irrelevantNodes.addAll(descendants);
                            irrelevantNodes.forEach(in -> {
                                this.preferenceKernel.clearKnowledge(in);
                                this.activeTree.removeItem(in);
                                this.eventBus.post((Object)new NodeRemovedEvent(null, in));
                            });
                        } else {
                            this.sequentialCertaintyCounts.put(node, new Pair(randomChoice, (Object)(numberOfSuccessfulChoices + 1)));
                        }
                    } else {
                        this.logger.info("Resetting certainty count for this node.");
                        this.sequentialCertaintyCounts.put(node, null);
                    }
                } else if (probOfChosenAction >= 0.99) {
                    this.logger.info("Initializing number of sure choices for this action by 1.");
                    this.sequentialCertaintyCounts.put(node, new Pair(randomChoice, (Object)1));
                }
            }
            if (this.logger.isDebugEnabled()) {
                for (int i = 0; i < n; ++i) {
                    Object action = orderedActions.get(i);
                    this.logger.debug("Derived probability of {}-th action {} by {} -> {} -> {}", new Object[]{i, action, skills.get(action), hashMap.get(action), pVector.getDouble(i)});
                }
            }
            long metaRuntime = System.currentTimeMillis() - metaStart;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Eventual choice after {}ms: {} (index {} with probability of {}%). Runtimes are as follows. PL: {}ms ({}ms for MM algorithm), Choice: {}ms, Meta: {}ms", new Object[]{runtime, randomChoice, chosenIndex, MathExt.round((double)(100.0 * probOfChosenAction), (int)2), skillEstimateRuntime, mmRuntime, choiceRuntime, metaRuntime});
            }
            if (runtime > 10L) {
                this.logger.warn("PL inference took {}ms for {} options, which is more than the allowed!", (Object)runtime, (Object)actions.size());
            }
            return (A)randomChoice;
        }
        catch (AlgorithmException | AlgorithmExecutionCanceledException | AlgorithmTimeoutedException e) {
            throw new ActionPredictionFailedException((Exception)e);
        }
        catch (InterruptedException e) {
            this.logger.info("Policy thread has been interrupted. Re-interrupting thread, because no InterruptedException can be thrown here.");
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public double getProbabilityOfNode(N node) {
        Object curNode = node;
        double prob = 1.0;
        Object root = this.activeTree.getRoot();
        while (root != null && curNode != root) {
            Object parent = this.activeTree.getPredecessors(curNode).iterator().next();
            Object edge = this.activeTree.getEdgeLabel(parent, curNode);
            if (this.lastLocalProbabilityOfNode.containsKey(parent) && this.lastLocalProbabilityOfNode.get(parent).containsKey(edge)) {
                prob *= this.lastLocalProbabilityOfNode.get(parent).get(edge).doubleValue();
            } else {
                double uniform = 1.0 / (double)this.activeTree.getSuccessors(parent).size();
                this.logger.debug("No probability known for node {}. Assuming uniform probability {}.", curNode, (Object)uniform);
                prob *= uniform;
            }
            curNode = parent;
        }
        return prob;
    }

    public void registerListener(Object listener) {
        this.eventBus.register(listener);
        this.hasListeners = true;
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        if (this.preferenceKernel instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.preferenceKernel).setLoggerName(name + ".kernel");
        }
    }

    @Override
    public void updatePath(ILabeledPath<N, A> path, List<Double> scores) {
        double playoutScore = SetUtil.sum(scores);
        this.logger.info("Received a playout score of {}. Communicating this to the preference kernel.", (Object)playoutScore);
        this.preferenceKernel.signalNewScore(path, playoutScore);
        List nodes = path.getNodes();
        List arcs = path.getArcs();
        int totalDepth = path.getNumberOfNodes();
        int pathLength = path.getNumberOfNodes();
        Object lastNode = null;
        Object lastAction = null;
        boolean isNextNodeRelevantForDecisions = true;
        for (int depth = 0; isNextNodeRelevantForDecisions && depth < pathLength - 1; ++depth) {
            Object node = nodes.get(depth);
            Object arc = arcs.get(depth);
            double relativeDepth = (double)depth * 1.0 / (double)totalDepth;
            if (lastNode != null) {
                this.activeTree.addEdge(lastNode, node, lastAction);
            }
            this.numPulls.computeIfAbsent(node, dummy -> new HashMap()).put(arc, this.numPulls.get(node).computeIfAbsent(arc, a -> 0) + 1);
            this.logger.debug("Updating action {} for node {} with score {} and incrementing its number of pulls.", new Object[]{arc, node, playoutScore});
            if (!this.deepestRelativeNodeDepthsOfNodes.containsKey(node) || this.deepestRelativeNodeDepthsOfNodes.get(node) < relativeDepth) {
                this.deepestRelativeNodeDepthsOfNodes.put(node, relativeDepth);
            }
            this.logger.debug("Setting depth of node {} to {}", node, (Object)depth);
            this.depths.put(node, depth);
            isNextNodeRelevantForDecisions = this.nodesForWhichAnActionHasBeenRequested.contains(node);
            if (!isNextNodeRelevantForDecisions) {
                this.logger.debug("Node {} has never been requested for an action, so disregarding upcoming observations.", node);
            }
            lastNode = node;
            lastAction = arc;
        }
        if (!this.maxChildren.isEmpty()) {
            this.avgBranchingFactor = Math.max(2.0, (double)this.maxChildren.values().stream().reduce((a, b) -> a + b).get().intValue() / (1.0 * (double)this.maxChildren.size()));
        }
        this.avgDepth = ((double)this.numUpdates * this.avgDepth + (double)pathLength) / ((double)this.numUpdates + 1.0);
        this.avgTargetDepth = this.avgBranchingFactor > 0.0 ? this.avgDepth * 1.2 + Math.log(GOAL_TARGET_SIZE) / Math.log(this.avgBranchingFactor) : this.avgDepth;
        ++this.numUpdates;
        this.logger.info("Setting avg target depth to {}", (Object)this.avgTargetDepth);
    }

    @Override
    public void setEstimatedNumberOfRemainingRollouts(int pNumRollouts) {
        if (pNumRollouts < 0) {
            this.logger.warn("Estimated number of remaining rollouts must not be negative but was {}! Setting it to 1.", (Object)pNumRollouts);
        }
        if (this.avgBranchingFactor > 0.0) {
            double sumTmp = 0.0;
            double hmax = this.avgTargetDepth - (double)this.fixedDecisions.size();
            int h = 0;
            while ((double)h < hmax) {
                double f = 1.0 - (double)h / hmax;
                double innerSum = 0.0;
                for (int t = 0; t < h; ++t) {
                    innerSum += Math.pow(-1.0 / this.avgBranchingFactor, t);
                }
                sumTmp += innerSum * f;
                ++h;
            }
            double x0 = sumTmp == 0.0 ? 0.0 : (double)pNumRollouts / sumTmp;
            double a = x0 / hmax;
            this.rolloutsForGammaEquals1AsFunctionOfHeight = d -> Math.max((int)(x0 - a * (double)(d - this.fixedDecisions.size())), 2);
        }
    }

    public IPreferenceKernel<N, A> getPreferenceKernel() {
        return this.preferenceKernel;
    }

    public Set<N> getNodesForWhichAnActionHasBeenRequested() {
        return this.nodesForWhichAnActionHasBeenRequested;
    }

    public LabeledGraph<N, A> getActiveTree() {
        return this.activeTree;
    }

    public int getDepthOfActiveNode(N node) {
        return this.depths.get(node);
    }
}

