/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.mdp.mcts.uuct.utility;

import ai.libs.jaicore.search.algorithms.mdp.mcts.uuct.IUCBUtilityFunction;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CVaR
implements IUCBUtilityFunction {
    private final double alpha;
    private static final boolean MAXIMIZE = true;

    public CVaR(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public double getUtility(DoubleList observations) {
        List inverseList = observations.stream().map(o -> o * -1.0).collect(Collectors.toList());
        Collections.sort(inverseList);
        int threshold = (int)Math.ceil(this.alpha * (double)inverseList.size());
        double sum = 0.0;
        for (int i = 0; i < threshold; ++i) {
            sum += ((Double)inverseList.get(i)).doubleValue();
        }
        return sum / (double)threshold;
    }

    @Override
    public double getQ() {
        return 2.0;
    }

    @Override
    public double getA() {
        return 1.0;
    }

    @Override
    public double getB() {
        return 1.0 / this.alpha * (1.0 + 3.0 / Math.min(this.alpha, 1.0 - this.alpha));
    }
}

