/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.mdp.mcts.uuct.utility;

import ai.libs.jaicore.search.algorithms.mdp.mcts.uuct.IUCBUtilityFunction;
import it.unimi.dsi.fastutil.doubles.DoubleList;

public class VaR
implements IUCBUtilityFunction {
    private final double alpha;
    private final double b;

    public VaR(double alpha, double b) {
        this.alpha = alpha;
        this.b = b;
    }

    @Override
    public double getUtility(DoubleList observations) {
        if (observations.isEmpty()) {
            return Double.MAX_VALUE;
        }
        int threshold = Math.min(observations.size(), (int)Math.floor((1.0 - this.alpha) * (double)observations.size()));
        return observations.getDouble(threshold) * -1.0;
    }

    @Override
    public double getQ() {
        return 1.0;
    }

    @Override
    public double getA() {
        return 1.0;
    }

    @Override
    public double getB() {
        return this.b;
    }
}

