/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.auxilliary.iteratingoptimizer;

import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.EvaluatedSearchSolutionCandidateFoundEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.GraphSearchSolutionCandidateFoundEvent;
import ai.libs.jaicore.search.core.interfaces.AOptimalPathInORGraphSearch;
import ai.libs.jaicore.search.model.other.EvaluatedSearchGraphPath;
import ai.libs.jaicore.search.model.other.SearchGraphPath;
import com.google.common.eventbus.Subscribe;
import org.api4.java.ai.graphsearch.problem.IPathSearch;
import org.api4.java.ai.graphsearch.problem.IPathSearchInput;
import org.api4.java.ai.graphsearch.problem.IPathSearchWithPathEvaluationsInput;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.Timeout;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.attributedobjects.ObjectEvaluationFailedException;
import org.api4.java.common.attributedobjects.ScoredItem;
import org.api4.java.datastructure.graph.ILabeledPath;

public class IteratingGraphSearchOptimizer<I extends IPathSearchWithPathEvaluationsInput<N, A, V>, N, A, V extends Comparable<V>>
extends AOptimalPathInORGraphSearch<I, N, A, V> {
    private final IPathSearch<IPathSearchInput<N, A>, SearchGraphPath<N, A>, N, A> baseAlgorithm;

    public IteratingGraphSearchOptimizer(I problem, IPathSearch<IPathSearchInput<N, A>, SearchGraphPath<N, A>, N, A> baseAlgorithm) {
        super(problem);
        this.baseAlgorithm = baseAlgorithm;
        baseAlgorithm.registerListener(new Object(){

            @Subscribe
            public void receiveEvent(IAlgorithmEvent e) {
                IteratingGraphSearchOptimizer.this.post(e);
            }
        });
    }

    public boolean hasNext() {
        return this.baseAlgorithm.hasNext();
    }

    public IAlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        IAlgorithmEvent parentEvent = this.baseAlgorithm.nextWithException();
        if (parentEvent instanceof GraphSearchSolutionCandidateFoundEvent) {
            try {
                SearchGraphPath path = (SearchGraphPath)((GraphSearchSolutionCandidateFoundEvent)parentEvent).getSolutionCandidate();
                Comparable score = ((IPathSearchWithPathEvaluationsInput)this.getInput()).getPathEvaluator().evaluate((ILabeledPath)path);
                EvaluatedSearchGraphPath evaluatedPath = new EvaluatedSearchGraphPath(path.getNodes(), path.getArcs(), score);
                this.updateBestSeenSolution((ScoredItem)evaluatedPath);
                EvaluatedSearchSolutionCandidateFoundEvent event = new EvaluatedSearchSolutionCandidateFoundEvent((IAlgorithm<?, ?>)this, evaluatedPath);
                this.post((Object)event);
                return event;
            }
            catch (ObjectEvaluationFailedException e) {
                throw new AlgorithmException("Object evaluation failed", (Throwable)e);
            }
        }
        return parentEvent;
    }

    public IPathSearch<IPathSearchInput<N, A>, SearchGraphPath<N, A>, N, A> getBaseAlgorithm() {
        return this.baseAlgorithm;
    }

    public void setTimeout(Timeout to) {
        this.baseAlgorithm.setTimeout(to);
    }
}

