/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.awastar;

import ai.libs.jaicore.basic.algorithm.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.AlgorithmInitializedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.GraphInitializedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeAddedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeTypeSwitchEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.EvaluatedSearchSolutionCandidateFoundEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.GraphSearchSolutionCandidateFoundEvent;
import ai.libs.jaicore.search.core.interfaces.AOptimalPathInORGraphSearch;
import ai.libs.jaicore.search.model.other.EvaluatedSearchGraphPath;
import ai.libs.jaicore.search.model.travesaltree.BackPointerPath;
import ai.libs.jaicore.search.model.travesaltree.DefaultNodeComparator;
import ai.libs.jaicore.search.probleminputs.GraphSearchInput;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithPathEvaluationsInput;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithSubpathEvaluationsInput;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.IPathGoalTester;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.ICancelablePathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPotentiallySolutionReportingPathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.PathEvaluationException;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.api4.java.datastructure.graph.implicit.INewNodeDescription;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwaStarSearch<I extends GraphSearchWithSubpathEvaluationsInput<N, A, V>, N, A, V extends Comparable<V>>
extends AOptimalPathInORGraphSearch<I, N, A, V> {
    private Logger logger = LoggerFactory.getLogger(AwaStarSearch.class);
    private String loggerName;
    private final ISingleRootGenerator<N> rootNodeGenerator;
    private final ISuccessorGenerator<N, A> successorGenerator;
    private final IPathGoalTester<N, A> goalTester;
    private final IPathEvaluator<N, A, V> nodeEvaluator;
    private final Queue<BackPointerPath<N, A, V>> closedList;
    private final Queue<BackPointerPath<N, A, V>> suspendList;
    private final Queue<BackPointerPath<N, A, V>> openList;
    private int currentLevel = -1;
    private int windowSize;
    private final List<EvaluatedSearchGraphPath<N, A, V>> unconfirmedSolutions = new ArrayList<EvaluatedSearchGraphPath<N, A, V>>();
    private final List<EvaluatedSearchSolutionCandidateFoundEvent<N, A, V>> unreturnedSolutionEvents = new ArrayList<EvaluatedSearchSolutionCandidateFoundEvent<N, A, V>>();

    public AwaStarSearch(I problem) {
        super(problem);
        this.rootNodeGenerator = (ISingleRootGenerator)((GraphSearchInput)problem).getGraphGenerator().getRootGenerator();
        this.successorGenerator = ((GraphSearchInput)problem).getGraphGenerator().getSuccessorGenerator();
        this.goalTester = ((GraphSearchInput)problem).getGoalTester();
        this.nodeEvaluator = ((GraphSearchWithPathEvaluationsInput)problem).getPathEvaluator();
        this.closedList = new PriorityQueue<BackPointerPath<N, A, V>>(new DefaultNodeComparator());
        this.suspendList = new PriorityQueue<BackPointerPath<N, A, V>>(new DefaultNodeComparator());
        this.openList = new PriorityQueue<BackPointerPath<N, A, V>>(new DefaultNodeComparator());
        this.windowSize = 0;
        if (this.nodeEvaluator instanceof IPotentiallySolutionReportingPathEvaluator) {
            ((IPotentiallySolutionReportingPathEvaluator)this.nodeEvaluator).registerSolutionListener((Object)this);
        }
    }

    private void windowAStar() throws AlgorithmTimeoutedException, AlgorithmExecutionCanceledException, InterruptedException, AlgorithmException, PathEvaluationException {
        while (!this.openList.isEmpty()) {
            int nLevel;
            this.checkAndConductTermination();
            if (!this.unreturnedSolutionEvents.isEmpty()) {
                this.logger.info("Not doing anything because there are still unreturned solutions.");
                return;
            }
            BackPointerPath<N, A, V> n = this.openList.peek();
            this.openList.remove(n);
            this.closedList.add(n);
            if (!n.isGoal()) {
                this.post(new NodeTypeSwitchEvent((IAlgorithm)this, n, "or_closed"));
            }
            if ((nLevel = n.getNodes().size() - 1) <= this.currentLevel - this.windowSize) {
                this.closedList.remove(n);
                this.suspendList.add(n);
                this.logger.info("Suspending node {} with level {}, which is lower than {}", new Object[]{n, nLevel, this.currentLevel - this.windowSize});
                this.post(new NodeTypeSwitchEvent((IAlgorithm)this, n, "or_suspended"));
                continue;
            }
            if (nLevel > this.currentLevel) {
                this.logger.info("Switching level from {} to {}", (Object)this.currentLevel, (Object)nLevel);
                this.currentLevel = nLevel;
            }
            this.checkAndConductTermination();
            this.logger.debug("Expanding {}. Starting successor generation.", n.getHead());
            Collection successors = (Collection)this.computeTimeoutAware(() -> this.successorGenerator.generateSuccessors(n.getHead()), "Successor generation timeouted", true);
            this.logger.debug("Successor generation finished. Identified {} successors.", (Object)successors.size());
            for (INewNodeDescription expansionDescription : successors) {
                V oldScore;
                this.checkAndConductTermination();
                BackPointerPath<Object, Object, V> nPrime = new BackPointerPath<Object, Object, V>(n, expansionDescription.getTo(), expansionDescription.getArcLabel());
                nPrime.setGoal(this.goalTester.isGoal(nPrime));
                Comparable nPrimeScore = this.nodeEvaluator.evaluate(nPrime);
                if (nPrimeScore == null) {
                    this.logger.debug("Discarding node {} for which no f-value could be computed.", nPrime);
                    continue;
                }
                if (nPrime.isGoal()) {
                    EvaluatedSearchGraphPath solution = new EvaluatedSearchGraphPath(nPrime, nPrimeScore);
                    this.registerNewSolutionCandidate(solution);
                }
                if (!(this.openList.contains(nPrime) || this.closedList.contains(nPrime) || this.suspendList.contains(nPrime))) {
                    nPrime.setParent(n);
                    nPrime.setScore(nPrimeScore);
                    if (!nPrime.isGoal()) {
                        this.openList.add(nPrime);
                    }
                    this.post(new NodeAddedEvent((IAlgorithm)this, n, nPrime, nPrime.isGoal() ? "or_solution" : "or_open"));
                    continue;
                }
                if (this.openList.contains(nPrime) || this.suspendList.contains(nPrime)) {
                    oldScore = nPrime.getScore();
                    if (oldScore == null || oldScore.compareTo((Comparable)nPrimeScore) <= 0) continue;
                    nPrime.setParent(n);
                    nPrime.setScore(nPrimeScore);
                    continue;
                }
                if (!this.closedList.contains(nPrime)) continue;
                oldScore = nPrime.getScore();
                if (oldScore != null && oldScore.compareTo((Comparable)nPrimeScore) > 0) {
                    nPrime.setParent(n);
                    nPrime.setScore(nPrimeScore);
                }
                if (nPrime.isGoal()) continue;
                this.openList.add(nPrime);
            }
        }
    }

    @Subscribe
    public void receiveSolutionEvent(EvaluatedSearchSolutionCandidateFoundEvent<N, A, V> solutionEvent) {
        this.registerNewSolutionCandidate((EvaluatedSearchGraphPath)solutionEvent.getSolutionCandidate());
        this.unconfirmedSolutions.add((EvaluatedSearchGraphPath)solutionEvent.getSolutionCandidate());
    }

    public EvaluatedSearchSolutionCandidateFoundEvent<N, A, V> registerNewSolutionCandidate(EvaluatedSearchGraphPath<N, A, V> solution) {
        EvaluatedSearchSolutionCandidateFoundEvent<N, A, V> event = this.registerSolution(solution);
        this.unreturnedSolutionEvents.add(event);
        return event;
    }

    public IAlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        try {
            this.registerActiveThread();
            this.logger.debug("Next step in {}. State is {}", (Object)this.getId(), (Object)this.getState());
            this.checkAndConductTermination();
            switch (this.getState()) {
                case CREATED: {
                    Object externalRootNode = this.rootNodeGenerator.getRoot();
                    BackPointerPath<Object, Object, Comparable> rootNode = new BackPointerPath<Object, Object, Comparable>(null, externalRootNode, null);
                    this.logger.info("Initializing graph and OPEN with {}.", rootNode);
                    this.openList.add(rootNode);
                    this.post(new GraphInitializedEvent((IAlgorithm)this, rootNode));
                    rootNode.setScore(this.nodeEvaluator.evaluate(rootNode));
                    AlgorithmInitializedEvent algorithmInitializedEvent = this.activate();
                    return algorithmInitializedEvent;
                }
                case ACTIVE: {
                    this.logger.info("Searching for next solution.");
                    while (this.unreturnedSolutionEvents.isEmpty()) {
                        this.checkAndConductTermination();
                        if (this.openList.isEmpty()) {
                            if (this.suspendList.isEmpty()) {
                                this.logger.info("The whole graph has been exhausted. No more solutions can be found!");
                                AlgorithmFinishedEvent algorithmFinishedEvent = this.terminate();
                                return algorithmFinishedEvent;
                            }
                            this.logger.info("Search with window size {} is exhausted. Reactivating {} suspended nodes and incrementing window size.", (Object)this.windowSize, (Object)this.suspendList.size());
                            this.openList.addAll(this.suspendList);
                            this.suspendList.clear();
                            ++this.windowSize;
                            this.currentLevel = -1;
                        }
                        this.logger.info("Running core algorithm with window size {} and current level {}. {} items are in OPEN", new Object[]{this.windowSize, this.currentLevel, this.openList.size()});
                        this.windowAStar();
                    }
                    IAlgorithmEvent event = (IAlgorithmEvent)this.unreturnedSolutionEvents.get(0);
                    this.unreturnedSolutionEvents.remove(0);
                    if (!(event instanceof GraphSearchSolutionCandidateFoundEvent)) {
                        this.post(event);
                    }
                    IAlgorithmEvent iAlgorithmEvent = event;
                    return iAlgorithmEvent;
                }
            }
            try {
                throw new IllegalStateException("Cannot do anything in state " + this.getState());
            }
            catch (PathEvaluationException e) {
                throw new AlgorithmException("Algorithm failed due to path evaluation exception.", (Throwable)e);
            }
        }
        finally {
            this.unregisterActiveThread();
        }
    }

    protected void shutdown() {
        if (this.isShutdownInitialized()) {
            return;
        }
        this.logger.info("Invoking shutdown routine ...");
        super.shutdown();
        if (this.nodeEvaluator instanceof ICancelablePathEvaluator) {
            this.logger.info("Canceling node evaluator.");
            ((ICancelablePathEvaluator)this.nodeEvaluator).cancelActiveTasks();
        }
    }

    public void setNumCPUs(int numberOfCPUs) {
        this.logger.warn("Currently no support for parallelization");
    }

    public int getNumCPUs() {
        return 1;
    }

    @Override
    public IGraphGenerator<N, A> getGraphGenerator() {
        return ((GraphSearchWithSubpathEvaluationsInput)this.getInput()).getGraphGenerator();
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switching logger to {}", (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Switched to logger {}", (Object)name);
        super.setLoggerName(this.loggerName + "._orgraphsearch");
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }
}

