/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.bestfirst;

import ai.libs.jaicore.basic.algorithm.AAlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.AlgorithmInitializedEvent;
import ai.libs.jaicore.concurrent.GlobalTimer;
import ai.libs.jaicore.concurrent.TrackableTimerTask;
import ai.libs.jaicore.graphvisualizer.events.graph.GraphInitializedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeAddedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeInfoAlteredEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeParentSwitchEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeRemovedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeTypeSwitchEvent;
import ai.libs.jaicore.interrupt.InterruptionTimerTask;
import ai.libs.jaicore.logging.LoggerUtil;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.ENodeAnnotation;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.IBestFirstConfig;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.EvaluatedSearchSolutionCandidateFoundEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.FValueEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.NodeAnnotationEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.NodeExpansionCompletedEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.NodeExpansionJobSubmittedEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.RemovedGoalNodeFromOpenEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.RolloutEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.SolutionAnnotationEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.SuccessorComputationCompletedEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.nodeevaluation.DecoratingNodeEvaluator;
import ai.libs.jaicore.search.core.interfaces.AOptimalPathInORGraphSearch;
import ai.libs.jaicore.search.model.other.EvaluatedSearchGraphPath;
import ai.libs.jaicore.search.model.travesaltree.BackPointerPath;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.aeonbits.owner.ConfigFactory;
import org.api4.java.ai.graphsearch.problem.IPathSearchWithPathEvaluationsInput;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.IPathGoalTester;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.ICancelablePathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPotentiallyGraphDependentPathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPotentiallySolutionReportingPathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPotentiallyUncertaintyAnnotatingPathEvaluator;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.events.result.ISolutionCandidateFoundEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.api4.java.datastructure.graph.implicit.INewNodeDescription;
import org.api4.java.datastructure.graph.implicit.IRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestFirst<I extends IPathSearchWithPathEvaluationsInput<N, A, V>, N, A, V extends Comparable<V>>
extends AOptimalPathInORGraphSearch<I, N, A, V> {
    private Logger bfLogger = LoggerFactory.getLogger(BestFirst.class);
    private String loggerName;
    private static final String SPACER = "\n\t\t";
    protected final IGraphGenerator<N, A> graphGenerator;
    protected final IRootGenerator<N> rootGenerator;
    protected final ISuccessorGenerator<N, A> successorGenerator;
    protected final IPathGoalTester<N, A> pathGoalTester;
    protected final IPathEvaluator<N, A, V> nodeEvaluator;
    private int timeoutForComputationOfF;
    private IPathEvaluator<N, A, V> timeoutNodeEvaluator;
    private final boolean considerNodeEvaluationOptimistic;
    private final IPathEvaluator<N, A, V> lowerBoundEvaluator;
    private final boolean solutionReportingNodeEvaluator;
    private final boolean cancelableNodeEvaluator;
    private int createdCounter;
    private int expandedCounter;
    private boolean initialized = false;
    private final List<INewNodeDescription<N, A>> lastExpansion = new ArrayList<INewNodeDescription<N, A>>();
    protected final Queue<EvaluatedSearchGraphPath<N, A, V>> solutions = new LinkedBlockingQueue<EvaluatedSearchGraphPath<N, A, V>>();
    protected final Queue<EvaluatedSearchSolutionCandidateFoundEvent<N, A, V>> pendingSolutionFoundEvents = new LinkedBlockingQueue<EvaluatedSearchSolutionCandidateFoundEvent<N, A, V>>();
    private boolean shutdownComplete = false;
    protected final Map<N, BackPointerPath<N, A, V>> ext2int = new ConcurrentHashMap<N, BackPointerPath<N, A, V>>();
    protected Queue<BackPointerPath<N, A, V>> open = new PriorityQueue<BackPointerPath<N, A, V>>((n1, n2) -> n1.getScore().compareTo(n2.getScore()));
    private BackPointerPath<N, A, V> nodeSelectedForExpansion;
    private final Map<N, Thread> expanding = new HashMap<N, Thread>();
    private final Set<N> closed = new HashSet<N>();
    protected int additionalThreadsForNodeAttachment = 0;
    private ExecutorService pool;
    private Collection<Thread> threadsOfPool = new ArrayList<Thread>();
    protected final AtomicInteger activeJobs = new AtomicInteger(0);
    private final Lock activeJobsCounterLock = new ReentrantLock();
    private final Lock openLock = new ReentrantLock();
    private final Lock nodeSelectionLock = new ReentrantLock(true);
    private final Condition numberOfActiveJobsHasChanged = this.activeJobsCounterLock.newCondition();

    public BestFirst(I problem) {
        this(problem, null);
    }

    public BestFirst(I problem, IPathEvaluator<N, A, V> lowerBoundEvaluator) {
        this((IBestFirstConfig)ConfigFactory.create(IBestFirstConfig.class, (Map[])new Map[0]), problem, lowerBoundEvaluator);
    }

    public BestFirst(IBestFirstConfig config, I problem) {
        this(config, problem, null);
    }

    public BestFirst(IBestFirstConfig config, I problem, IPathEvaluator<N, A, V> lowerBoundEvaluator) {
        super(config, problem);
        this.graphGenerator = problem.getGraphGenerator();
        this.rootGenerator = this.graphGenerator.getRootGenerator();
        this.successorGenerator = this.graphGenerator.getSuccessorGenerator();
        this.pathGoalTester = problem.getGoalTester();
        this.considerNodeEvaluationOptimistic = config.optimisticHeuristic();
        this.lowerBoundEvaluator = lowerBoundEvaluator;
        this.nodeEvaluator = problem.getPathEvaluator();
        if (this.nodeEvaluator == null) {
            throw new IllegalArgumentException("Cannot work with node evaulator that is null");
        }
        if (this.nodeEvaluator instanceof DecoratingNodeEvaluator) {
            DecoratingNodeEvaluator castedEvaluator = (DecoratingNodeEvaluator)this.nodeEvaluator;
            if (castedEvaluator.requiresGraphGenerator()) {
                this.bfLogger.info("{} is a graph dependent node evaluator. Setting its graph generator now ...", (Object)castedEvaluator);
                castedEvaluator.setGenerator(this.graphGenerator, this.pathGoalTester);
            }
            if (castedEvaluator.reportsSolutions()) {
                this.bfLogger.info("{} is a solution reporter. Register the search algo in its event bus", (Object)castedEvaluator);
                castedEvaluator.registerSolutionListener((Object)this);
                this.solutionReportingNodeEvaluator = true;
            } else {
                this.solutionReportingNodeEvaluator = false;
            }
        } else {
            if (this.nodeEvaluator instanceof IPotentiallyGraphDependentPathEvaluator) {
                this.bfLogger.info("{} is a graph dependent node evaluator. Setting its graph generator now ...", this.nodeEvaluator);
                ((IPotentiallyGraphDependentPathEvaluator)this.nodeEvaluator).setGenerator(this.graphGenerator, this.pathGoalTester);
            }
            if (this.nodeEvaluator instanceof IPotentiallySolutionReportingPathEvaluator) {
                this.bfLogger.info("{} is a solution reporter. Register the search algo in its event bus", this.nodeEvaluator);
                ((IPotentiallySolutionReportingPathEvaluator)this.nodeEvaluator).registerSolutionListener((Object)this);
                this.solutionReportingNodeEvaluator = true;
            } else {
                this.solutionReportingNodeEvaluator = false;
            }
        }
        this.cancelableNodeEvaluator = this.nodeEvaluator instanceof ICancelablePathEvaluator;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.cancel(), "Shutdown hook thread for " + (Object)((Object)this)));
    }

    protected BackPointerPath<N, A, V> newNode(BackPointerPath<N, A, V> parent, N t2, A arc) throws InterruptedException {
        return this.newNode(parent, t2, arc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BackPointerPath<N, A, V> newNode(BackPointerPath<N, A, V> parent, N t2, A arc, V evaluation) throws InterruptedException {
        this.openLock.lockInterruptibly();
        try {
            assert (!this.open.contains(parent)) : "Parent node " + parent + " is still on OPEN, which must not be the case! OPEN class: " + this.open.getClass().getName() + ". OPEN size: " + this.open.size();
        }
        finally {
            this.openLock.unlock();
        }
        BackPointerPath<N, A, V> newNode = new BackPointerPath<N, A, V>(parent, t2, arc);
        if (evaluation != null) {
            newNode.setScore(evaluation);
        }
        assert (parent == null || !parent.getNodes().contains(t2)) : "There is a loop in the underlying graph. The following path contains the last node twice: " + newNode.getNodes().stream().map(Object::toString).reduce("", (s, t) -> s + SPACER + t);
        assert (!this.ext2int.containsKey(t2)) : "Reached node " + t2 + " for the second time.\nt\tFirst path:" + this.ext2int.get(t2).getNodes().stream().map(n -> n + "").reduce("", (s, t) -> s + SPACER + t) + "\n\tSecond Path:" + newNode.getNodes().stream().map(Object::toString).reduce("", (s, t) -> s + SPACER + t);
        this.ext2int.put(t2, newNode);
        if (this.pathGoalTester.isGoal(newNode)) {
            newNode.setGoal(true);
        }
        if (parent == null) {
            this.post(new GraphInitializedEvent((IAlgorithm)this, newNode));
        } else {
            this.post(new NodeAddedEvent((IAlgorithm)this, parent, newNode, newNode.isGoal() ? ENodeType.OR_SOLUTION.toString() : ENodeType.OR_CREATED.toString()));
            this.bfLogger.debug("Sent message for creation of node {} as a successor of {}", (Object)newNode.hashCode(), (Object)parent.hashCode());
        }
        return newNode;
    }

    protected void labelNode(BackPointerPath<N, A, V> node) throws AlgorithmTimeoutedException, AlgorithmExecutionCanceledException, InterruptedException, AlgorithmException {
        long fTime;
        this.bfLogger.debug("Computing node label for node with hash code {}", (Object)node.hashCode());
        if (this.isStopCriterionSatisfied()) {
            this.bfLogger.debug("Found stop criterion to be true. Returning control.");
            return;
        }
        InterruptionTimerTask interruptionTask = null;
        AtomicBoolean timedout = new AtomicBoolean(false);
        if (this.timeoutForComputationOfF > 0) {
            interruptionTask = new InterruptionTimerTask("Timeout for Node-Labeling in " + (Object)((Object)this), Thread.currentThread(), () -> timedout.set(true));
            this.bfLogger.debug("Scheduling timeout for f-value computation. Allowed time: {}ms", (Object)this.timeoutForComputationOfF);
            GlobalTimer.getInstance().schedule((TrackableTimerTask)interruptionTask, (long)this.timeoutForComputationOfF);
        }
        Comparable label = null;
        boolean computationTimedout = false;
        long startComputation = System.currentTimeMillis();
        try {
            this.bfLogger.trace("Calling f-function of node evaluator for {}", (Object)node.hashCode());
            label = (Comparable)this.computeTimeoutAware(() -> this.nodeEvaluator.evaluate((ILabeledPath)node), "Node Labeling with " + this.nodeEvaluator, !this.threadsOfPool.contains(Thread.currentThread()));
            this.bfLogger.trace("Determined f-value of {}", (Object)label);
            if (this.isStopCriterionSatisfied()) {
                return;
            }
            fTime = System.currentTimeMillis() - startComputation;
            if (this.timeoutForComputationOfF > 0 && fTime > (long)(this.timeoutForComputationOfF + 1000)) {
                this.bfLogger.warn("Computation of f for node {} took {}ms, which is more than the allowed {}ms", new Object[]{node, fTime, this.timeoutForComputationOfF});
            }
        }
        catch (InterruptedException e) {
            this.bfLogger.info("Thread {} received interrupt in node evaluation. Timeout flag is {}", (Object)Thread.currentThread(), (Object)timedout.get());
            if (timedout.get()) {
                this.bfLogger.debug("Received interrupt during computation of f.");
                this.post(new NodeTypeSwitchEvent((IAlgorithm)this, node, ENodeType.OR_TIMEDOUT.toString()));
                node.setAnnotation(ENodeAnnotation.F_ERROR.toString(), "Timeout");
                computationTimedout = true;
                Thread.interrupted();
                try {
                    label = this.timeoutNodeEvaluator != null ? this.timeoutNodeEvaluator.evaluate(node) : null;
                }
                catch (Exception e2) {
                    this.bfLogger.error("An unexpected exception occurred while labeling node {}", node, (Object)e2);
                }
            }
            this.checkAndConductTermination();
            this.bfLogger.info("Received external interrupt. Forwarding this interrupt.");
            throw e;
        }
        if (interruptionTask != null) {
            interruptionTask.cancel();
        }
        fTime = System.currentTimeMillis() - startComputation;
        node.setAnnotation(ENodeAnnotation.F_TIME.toString(), fTime);
        this.bfLogger.debug("Computed label {} for {} in {}ms", new Object[]{label, node.hashCode(), fTime});
        if (label == null) {
            if (!computationTimedout) {
                this.bfLogger.debug("Not inserting node {} since its label is missing!", (Object)node.hashCode());
            } else {
                this.bfLogger.debug("Not inserting node {} because computation of f-value timed out.", (Object)node.hashCode());
            }
            if (!node.getAnnotations().containsKey(ENodeAnnotation.F_ERROR.toString())) {
                node.setAnnotation(ENodeAnnotation.F_ERROR.toString(), "f-computer returned NULL");
            }
            return;
        }
        assert (!(this.nodeEvaluator instanceof IPotentiallyUncertaintyAnnotatingPathEvaluator) || !((IPotentiallyUncertaintyAnnotatingPathEvaluator)this.nodeEvaluator).annotatesUncertainty() || node.getAnnotation(ENodeAnnotation.F_UNCERTAINTY.name()) != null) : "Uncertainty-based node evaluator (" + this.nodeEvaluator.getClass().getName() + ") claims to annotate uncertainty but has not assigned any uncertainty to " + node.getHead() + " with label " + label;
        node.setScore(label);
        assert (node.getScore() != null) : "Node label must not be NULL";
        this.post(new NodeInfoAlteredEvent((IAlgorithm)this, node));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initGraph() throws AlgorithmTimeoutedException, AlgorithmExecutionCanceledException, InterruptedException, AlgorithmException {
        if (!this.initialized) {
            this.bfLogger.info("Start graph initialization.");
            this.initialized = true;
            this.bfLogger.debug("Compute labels of root node(s)");
            for (Object n0 : this.rootGenerator.getRoots()) {
                BackPointerPath root = this.newNode(null, n0, null);
                if (root == null) {
                    throw new IllegalArgumentException("Root cannot be null. Cannot add NULL as a node to OPEN");
                }
                try {
                    this.labelNode(root);
                }
                catch (AlgorithmException e) {
                    throw new AlgorithmException("Graph initialization failed: Could not compute the label for the root node due to an exception.", (Throwable)e);
                }
                this.bfLogger.debug("Labeled root with {}", root.getScore());
                this.checkAndConductTermination();
                if (root.getScore() == null) {
                    throw new IllegalArgumentException("The node evaluator has assigned NULL to the root node, which impedes an initialization of the search graph. Node evaluator: " + this.nodeEvaluator);
                }
                this.openLock.lockInterruptibly();
                try {
                    this.open.add(root);
                }
                finally {
                    this.openLock.unlock();
                }
            }
            this.bfLogger.info("Finished graph initialization.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectNodeForNextExpansion(BackPointerPath<N, A, V> node) throws InterruptedException {
        assert (node != null) : "Cannot select node NULL for expansion!";
        this.nodeSelectionLock.lockInterruptibly();
        try {
            this.openLock.lockInterruptibly();
            try {
                assert (!this.open.contains(null)) : "OPEN contains NULL";
                assert (this.open.stream().noneMatch(n -> n.getScore() == null)) : "OPEN contains an element with value NULL";
                int openSizeBefore = this.open.size();
                assert (this.nodeSelectedForExpansion == null) : "Node selected for expansion must be NULL when setting it!";
                this.nodeSelectedForExpansion = node;
                assert (this.open.contains(node)) : "OPEN must contain the node to be expanded.\n\tOPEN size: " + this.open.size() + "\n\tNode to be expanded: " + node + ".\n\tOPEN: " + this.open.stream().map(n -> SPACER + n).collect(Collectors.joining());
                this.open.remove(this.nodeSelectedForExpansion);
                int openSizeAfter = this.open.size();
                assert (this.ext2int.containsKey(this.nodeSelectedForExpansion.getHead())) : "A node chosen for expansion has no entry in the ext2int map!";
                assert (openSizeAfter == openSizeBefore - 1) : "OPEN size must descrease by one when selecting node for expansion";
            }
            finally {
                this.openLock.unlock();
            }
        }
        finally {
            this.nodeSelectionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IAlgorithmEvent expandNextNode() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        AAlgorithmEvent expansionEvent;
        assert (this.additionalThreadsForNodeAttachment == 0 || this.activeJobs.get() < this.additionalThreadsForNodeAttachment) : "Cannot expand nodes if number of active jobs (" + this.activeJobs.get() + " is at least as high as the threads available for node attachment (" + this.additionalThreadsForNodeAttachment + ")";
        long startTimeOfExpansion = System.currentTimeMillis();
        BackPointerPath<N, A, V> tmpNodeSelectedForExpansion = null;
        this.nodeSelectionLock.lockInterruptibly();
        try {
            block45: {
                if (this.nodeSelectedForExpansion == null) {
                    this.activeJobsCounterLock.lockInterruptibly();
                    this.bfLogger.trace("Acquired activeJobsCounterLock for read.");
                    boolean stopCriterionSatisfied = this.isStopCriterionSatisfied();
                    try {
                        this.bfLogger.debug("No next node has been selected. Choosing the first from OPEN.");
                        while (this.open.isEmpty() && this.activeJobs.get() > 0 && !stopCriterionSatisfied) {
                            this.bfLogger.trace("Await condition as open queue is empty and active jobs is {} ...", (Object)this.activeJobs.get());
                            this.numberOfActiveJobsHasChanged.await();
                            this.bfLogger.trace("Got signaled");
                            stopCriterionSatisfied = this.isStopCriterionSatisfied();
                        }
                        if (stopCriterionSatisfied) break block45;
                        this.openLock.lock();
                        try {
                            if (this.open.isEmpty()) {
                                IAlgorithmEvent iAlgorithmEvent = null;
                                return iAlgorithmEvent;
                            }
                            this.selectNodeForNextExpansion((N)this.open.peek());
                        }
                        finally {
                            this.openLock.unlock();
                        }
                    }
                    finally {
                        this.activeJobsCounterLock.unlock();
                        this.bfLogger.trace("Released activeJobsCounterLock after read. Now checking termination.");
                        this.checkAndConductTermination();
                    }
                }
            }
            assert (this.nodeSelectedForExpansion != null) : "We have not selected any node for expansion, but this must be the case at this point.";
            tmpNodeSelectedForExpansion = this.nodeSelectedForExpansion;
            this.nodeSelectedForExpansion = null;
        }
        finally {
            this.nodeSelectionLock.unlock();
        }
        assert (this.nodeSelectedForExpansion == null) : "The object variable for the next selected node must be NULL at the end of the select step.";
        BackPointerPath<N, A, V> actualNodeSelectedForExpansion = tmpNodeSelectedForExpansion;
        Map<N, Thread> stopCriterionSatisfied = this.expanding;
        synchronized (stopCriterionSatisfied) {
            this.expanding.put(actualNodeSelectedForExpansion.getHead(), Thread.currentThread());
            assert (this.expanding.keySet().contains(tmpNodeSelectedForExpansion.getHead())) : "The node selected for expansion should be in the EXPANDING map by now.";
        }
        assert (!this.open.contains(actualNodeSelectedForExpansion)) : "Node selected for expansion is still on OPEN";
        assert (actualNodeSelectedForExpansion != null) : "We have not selected any node for expansion, but this must be the case at this point.";
        this.checkTerminationAndUnregisterFromExpand(actualNodeSelectedForExpansion);
        if (!actualNodeSelectedForExpansion.isGoal()) {
            this.beforeExpansion(actualNodeSelectedForExpansion);
            this.post(new NodeTypeSwitchEvent((IAlgorithm)this, actualNodeSelectedForExpansion, "or_expanding"));
            this.bfLogger.debug("Expanding node {} with f-value {}", (Object)actualNodeSelectedForExpansion.hashCode(), actualNodeSelectedForExpansion.getScore());
            this.bfLogger.debug("Start computation of successors");
            List tmpSuccessorDescriptions = null;
            assert (!actualNodeSelectedForExpansion.isGoal()) : "Goal nodes must not be expanded!";
            tmpSuccessorDescriptions = (List)this.computeTimeoutAware(() -> {
                this.bfLogger.trace("Invoking getSuccessors");
                return this.successorGenerator.generateSuccessors(actualNodeSelectedForExpansion.getHead());
            }, "Successor generation", !this.threadsOfPool.contains(Thread.currentThread()));
            assert (tmpSuccessorDescriptions != null) : "Successor descriptions must never be null!";
            if (this.bfLogger.isTraceEnabled()) {
                this.bfLogger.trace("Received {} successor descriptions for node with hash code {}. The first 1000 of these are \n\t{}", new Object[]{tmpSuccessorDescriptions.size(), actualNodeSelectedForExpansion.getHead(), tmpSuccessorDescriptions.stream().limit(1000L).map(s -> s.getTo().toString()).collect(Collectors.joining("\n\t"))});
            }
            List successorDescriptions = tmpSuccessorDescriptions;
            this.checkTerminationAndUnregisterFromExpand(actualNodeSelectedForExpansion);
            this.bfLogger.debug("Finished computation of successors. Sending SuccessorComputationCompletedEvent with {} successors for {}", (Object)successorDescriptions.size(), (Object)actualNodeSelectedForExpansion.hashCode());
            this.post(new SuccessorComputationCompletedEvent<N, A, V>((IAlgorithm<?, ?>)this, actualNodeSelectedForExpansion, successorDescriptions));
            List todoList = successorDescriptions.stream().map(INewNodeDescription::getTo).collect(Collectors.toList());
            long lastTerminationCheck = System.currentTimeMillis();
            for (INewNodeDescription successorDescription : successorDescriptions) {
                NodeBuilder nb = new NodeBuilder(todoList, actualNodeSelectedForExpansion, successorDescription);
                this.bfLogger.trace("Number of additional threads for node attachment is {}", (Object)this.additionalThreadsForNodeAttachment);
                if (this.additionalThreadsForNodeAttachment < 1) {
                    nb.run();
                } else {
                    this.lockConditionSafeleyWhileExpandingNode(this.activeJobsCounterLock, actualNodeSelectedForExpansion);
                    this.bfLogger.trace("Acquired activeJobsCounterLock for increment");
                    try {
                        this.activeJobs.incrementAndGet();
                    }
                    finally {
                        this.numberOfActiveJobsHasChanged.signalAll();
                        this.activeJobsCounterLock.unlock();
                        this.bfLogger.trace("Released activeJobsCounterLock after increment");
                    }
                    if (this.isShutdownInitialized()) break;
                    this.pool.submit(nb);
                }
                if (System.currentTimeMillis() - lastTerminationCheck <= 50L) continue;
                if (this.expanding.containsKey(actualNodeSelectedForExpansion)) {
                    this.checkTerminationAndUnregisterFromExpand(actualNodeSelectedForExpansion);
                } else {
                    this.checkAndConductTermination();
                }
                lastTerminationCheck = System.currentTimeMillis();
            }
            this.bfLogger.debug("Finished expansion of node {} after {}ms. Size of OPEN is now {}. Number of active jobs is {}", new Object[]{actualNodeSelectedForExpansion.hashCode(), System.currentTimeMillis() - startTimeOfExpansion, this.open.size(), this.activeJobs.get()});
            this.checkTerminationAndUnregisterFromExpand(actualNodeSelectedForExpansion);
            expansionEvent = new NodeExpansionJobSubmittedEvent<N, A, V>((IAlgorithm<?, ?>)this, actualNodeSelectedForExpansion, successorDescriptions);
        } else {
            expansionEvent = new RemovedGoalNodeFromOpenEvent<N, A, V>((IAlgorithm<?, ?>)this, actualNodeSelectedForExpansion);
        }
        ++this.expandedCounter;
        Map<N, Thread> map = this.expanding;
        synchronized (map) {
            this.expanding.remove(actualNodeSelectedForExpansion.getHead());
            assert (!this.expanding.containsKey(actualNodeSelectedForExpansion.getHead())) : actualNodeSelectedForExpansion + " was expanded and it was not removed from EXPANDING!";
        }
        this.closed.add(actualNodeSelectedForExpansion.getHead());
        assert (this.closed.contains(actualNodeSelectedForExpansion.getHead())) : "Expanded node " + actualNodeSelectedForExpansion + " was not inserted into CLOSED!";
        this.post(new NodeTypeSwitchEvent((IAlgorithm)this, actualNodeSelectedForExpansion, ENodeType.OR_CLOSED.toString()));
        this.afterExpansion(actualNodeSelectedForExpansion);
        this.checkAndConductTermination();
        this.openLock.lockInterruptibly();
        try {
            this.bfLogger.debug("Step ends. Size of OPEN now {}", (Object)this.open.size());
        }
        finally {
            this.openLock.unlock();
        }
        return expansionEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected EvaluatedSearchSolutionCandidateFoundEvent<N, A, V> registerSolution(EvaluatedSearchGraphPath<N, A, V> solutionPath) {
        EvaluatedSearchSolutionCandidateFoundEvent<N, A, V> solutionEvent = super.registerSolution(solutionPath);
        this.bfLogger.debug("Successfully registered solution on parent level, now adding the solution to the local queue.");
        assert (!this.solutions.contains(solutionEvent.getSolutionCandidate())) : "Registering solution " + solutionEvent.getSolutionCandidate() + " for the second time!";
        this.solutions.add((EvaluatedSearchGraphPath)solutionEvent.getSolutionCandidate());
        Queue<EvaluatedSearchSolutionCandidateFoundEvent<N, A, V>> queue = this.pendingSolutionFoundEvents;
        synchronized (queue) {
            this.pendingSolutionFoundEvents.add(solutionEvent);
        }
        return solutionEvent;
    }

    private void lockConditionSafeleyWhileExpandingNode(Lock l, BackPointerPath<N, A, V> node) throws AlgorithmTimeoutedException, AlgorithmExecutionCanceledException, InterruptedException {
        try {
            l.lockInterruptibly();
        }
        catch (InterruptedException e) {
            this.bfLogger.debug("Received an interrupt while waiting for {} to become available.", (Object)l);
            Thread.currentThread().interrupt();
            this.checkTerminationAndUnregisterFromExpand(node);
        }
    }

    private void unregisterFromExpand(BackPointerPath<N, A, V> node) {
        assert (this.expanding.containsKey(node.getHead())) : "Cannot unregister a node that is not being expanded currently";
        assert (this.expanding.get(node.getHead()) == Thread.currentThread()) : "Thread " + Thread.currentThread() + " cannot unregister other thread " + this.expanding.get(node.getHead()) + " from expansion map!";
        this.bfLogger.debug("Removing {} from EXPANDING.", (Object)node.hashCode());
        this.expanding.remove(node.getHead());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTerminationAndUnregisterFromExpand(BackPointerPath<N, A, V> node) throws AlgorithmTimeoutedException, AlgorithmExecutionCanceledException, InterruptedException {
        if (this.isStopCriterionSatisfied()) {
            assert (this.shutdownComplete || this.expanding.containsKey(node.getHead())) : "Expanded node " + this.nodeSelectedForExpansion + " is not contained EXPANDING currently! That cannot be the case. The " + this.expanding.size() + " nodes currently in EXPANDING are: " + this.expanding.keySet().stream().map(n -> "\n\t" + n).collect(Collectors.joining());
            Map<N, Thread> map = this.expanding;
            synchronized (map) {
                if (this.expanding.containsKey(node.getHead())) {
                    this.unregisterFromExpand(node);
                    assert (!this.expanding.containsKey(node.getHead())) : "Expanded node " + this.nodeSelectedForExpansion + " was not removed from EXPANDING!";
                } else {
                    this.bfLogger.debug("Node {} is already unregistered from expansion.", (Object)node.getHead().hashCode());
                }
            }
        }
        super.checkAndConductTermination();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        if (this.threadsOfPool.contains(Thread.currentThread())) {
            this.bfLogger.error("Worker thread {} must not shutdown the algorithm!", (Object)Thread.currentThread());
        }
        assert (!Thread.currentThread().isInterrupted()) : "The thread should not be interrupted when shutdown is called.";
        if (this.isShutdownInitialized()) {
            return;
        }
        this.bfLogger.info("Invoking shutdown routine ...");
        this.bfLogger.debug("First conducting general algorithm shutdown routine ...");
        super.shutdown();
        this.bfLogger.debug("General algorithm shutdown routine completed. Now conducting BestFirst-specific shutdown activities.");
        Map<N, Thread> map = this.expanding;
        synchronized (map) {
            int interruptedThreads = 0;
            for (Map.Entry<N, Thread> entry : this.expanding.entrySet()) {
                Thread t = entry.getValue();
                if (!t.equals(Thread.currentThread())) {
                    this.expanding.remove(entry.getKey());
                    this.bfLogger.debug("Removing node {} with thread {} from expansion map, since this thread is realizing the shutdown.", entry.getKey(), (Object)t);
                    continue;
                }
                if (!this.hasThreadBeenInterruptedDuringShutdown(t)) {
                    this.interruptThreadAsPartOfShutdown(t);
                    ++interruptedThreads;
                    continue;
                }
                this.bfLogger.debug("Not interrupting thread {} again, since it already has been interrupted during shutdown.", (Object)t);
            }
            this.bfLogger.debug("Interrupted {} active expansion threads.", (Object)interruptedThreads);
        }
        if (this.additionalThreadsForNodeAttachment > 0) {
            this.bfLogger.debug("Shutting down worker pool.");
            if (this.pool != null) {
                this.bfLogger.info("Triggering shutdown of builder thread pool with interrupt");
                this.pool.shutdownNow();
            }
            try {
                this.bfLogger.debug("Waiting 3 days for pool shutdown.");
                if (this.pool != null) {
                    this.pool.awaitTermination(3L, TimeUnit.DAYS);
                } else {
                    this.bfLogger.error("Apparently, the pool was unexpectedly not set and thus null.");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.bfLogger.warn("Got interrupted during shutdown!", (Throwable)e);
            }
            if (this.pool != null) {
                assert (this.pool.isTerminated()) : "The worker pool has not been shutdown correctly!";
                if (!this.pool.isTerminated()) {
                    this.bfLogger.error("Worker pool has not been shutdown correctly!");
                } else {
                    this.bfLogger.info("Worker pool has been shut down.");
                }
            }
            this.bfLogger.info("Setting number of active jobs to 0.");
            this.bfLogger.trace("Waiting for activeJobsCounterLock.");
            this.activeJobsCounterLock.lock();
            try {
                this.bfLogger.trace("Acquired activeJobsCounterLock for setting it to 0");
                this.activeJobs.set(0);
                this.numberOfActiveJobsHasChanged.signalAll();
            }
            finally {
                this.activeJobsCounterLock.unlock();
                this.bfLogger.trace("Released activeJobsCounterLock after reset");
            }
            this.bfLogger.debug("Pool shutdown completed.");
        } else {
            this.bfLogger.debug("No additional threads for node attachment have been admitted, so there is no pool to close down.");
        }
        if (this.cancelableNodeEvaluator) {
            this.bfLogger.info("Canceling node evaluator.");
            ((ICancelablePathEvaluator)this.nodeEvaluator).cancelActiveTasks();
        }
        assert (this.pool == null || this.pool.isShutdown()) : "The pool has not been shutdown correctly at the end of the routine.";
        this.shutdownComplete = true;
        this.bfLogger.info("Shutdown completed");
    }

    @Subscribe
    public void receiveSolutionCandidateEvent(EvaluatedSearchSolutionCandidateFoundEvent<N, A, V> solutionEvent) {
        try {
            this.bfLogger.info("Received solution with f-value {} and annotations {}", ((EvaluatedSearchGraphPath)solutionEvent.getSolutionCandidate()).getScore(), ((EvaluatedSearchGraphPath)solutionEvent.getSolutionCandidate()).getAnnotations());
            this.registerSolution((EvaluatedSearchGraphPath)solutionEvent.getSolutionCandidate());
        }
        catch (Exception e) {
            this.bfLogger.error("An unexpected exception occurred while receiving EvaluatedSearchSolutionCandidateFoundEvent.", (Throwable)e);
        }
    }

    @Subscribe
    public void receiveRolloutEvent(RolloutEvent<N, V> event) {
        try {
            this.bfLogger.debug("Received rollout event: {}", event);
            this.post(event);
        }
        catch (Exception e) {
            this.bfLogger.error("An unexpected exception occurred while receiving RolloutEvent", (Throwable)e);
        }
    }

    @Subscribe
    public void receiveSolutionCandidateAnnotationEvent(SolutionAnnotationEvent<N, A, V> event) {
        try {
            this.bfLogger.debug("Received solution annotation: {}", event);
            this.post(event);
        }
        catch (Exception e) {
            this.bfLogger.error("An unexpected exception occurred receiveSolutionCandidateAnnotationEvent.", (Throwable)e);
        }
    }

    @Subscribe
    public void receiveNodeAnnotationEvent(NodeAnnotationEvent<N> event) {
        try {
            N nodeExt = event.getNode();
            this.bfLogger.debug("Received annotation {} with value {} for node {}", new Object[]{event.getAnnotationName(), event.getAnnotationValue(), event.getNode()});
            if (!this.ext2int.containsKey(nodeExt)) {
                throw new IllegalArgumentException("Received annotation for a node I don't know!");
            }
            BackPointerPath<N, A, V> nodeInt = this.ext2int.get(nodeExt);
            nodeInt.setAnnotation(event.getAnnotationName(), event.getAnnotationValue());
        }
        catch (Exception e) {
            this.bfLogger.error("An unexpected exception occurred while receiving node annotation event ", (Throwable)e);
        }
    }

    protected void insertNodeIntoLocalGraph(BackPointerPath<N, A, V> node) throws InterruptedException {
        BackPointerPath<N, A, V> localVersionOfParent = null;
        List<BackPointerPath<N, A, V>> path = node.path();
        BackPointerPath<N, A, V> leaf = path.get(path.size() - 1);
        for (BackPointerPath<N, A, V> nodeOnPath : path) {
            if (!this.ext2int.containsKey(nodeOnPath.getHead())) {
                assert (nodeOnPath.getParent() != null) : "Want to insert a new node that has no parent. That must not be the case! Affected node is: " + nodeOnPath.getHead();
                assert (this.ext2int.containsKey(nodeOnPath.getParent().getHead())) : "Want to insert a node whose parent is unknown locally";
                BackPointerPath<N, A, V> newNode = this.newNode(localVersionOfParent, nodeOnPath.getHead(), nodeOnPath.getEdgeLabelToParent(), nodeOnPath.getScore());
                if (!newNode.isGoal() && !newNode.getHead().equals(leaf.getHead())) {
                    this.post(new NodeTypeSwitchEvent((IAlgorithm)this, newNode, "or_closed"));
                }
                localVersionOfParent = newNode;
                continue;
            }
            localVersionOfParent = this.getLocalVersionOfNode(nodeOnPath);
        }
    }

    protected BackPointerPath<N, A, V> getLocalVersionOfNode(BackPointerPath<N, A, V> node) {
        return this.ext2int.get(node.getHead());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap(Collection<BackPointerPath<N, A, V>> initialNodes) throws InterruptedException {
        if (this.initialized) {
            throw new UnsupportedOperationException("Bootstrapping is only supported if the search has already been initialized.");
        }
        try {
            this.initGraph();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            this.bfLogger.error("An unexpected exception occurred while the graph should be initialized.", (Throwable)e);
            return;
        }
        this.openLock.lockInterruptibly();
        try {
            this.open.clear();
            for (BackPointerPath<N, A, V> node : initialNodes) {
                this.insertNodeIntoLocalGraph(node);
                if (node == null) {
                    throw new IllegalArgumentException("Cannot add NULL as a node to OPEN");
                }
                if (node.getScore() == null) {
                    throw new IllegalArgumentException("Cannot insert node with label NULL");
                }
                this.open.add(this.getLocalVersionOfNode(node));
            }
        }
        finally {
            this.openLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public IAlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        try {
            this.registerActiveThread();
            switch (this.getState()) {
                case CREATED: {
                    AlgorithmInitializedEvent initEvent = this.activate();
                    this.bfLogger.info("Initializing BestFirst search {} with the following configuration:\n\tCPUs: {}\n\tTimeout: {}ms\n\tGraph Generator: {}\n\tNode Evaluator: {}\n\tConsidering node evaluator optimistic: {}\n\tListening to solutions delivered by node evaluator: {}\n\tInitial score upper bound: {}", new Object[]{this, this.getConfig().cpus(), this.getConfig().timeout(), this.graphGenerator.getClass(), this.nodeEvaluator, this.considerNodeEvaluationOptimistic, this.solutionReportingNodeEvaluator, this.getBestScoreKnownToExist()});
                    int additionalCPUs = this.getConfig().cpus() - 1;
                    if (additionalCPUs > 0) {
                        this.parallelizeNodeExpansion(additionalCPUs);
                    }
                    this.initGraph();
                    this.bfLogger.info("Search initialized, returning activation event.");
                    AlgorithmInitializedEvent algorithmInitializedEvent = initEvent;
                    return algorithmInitializedEvent;
                }
                case ACTIVE: {
                    Queue<EvaluatedSearchSolutionCandidateFoundEvent<N, A, V>> queue = this.pendingSolutionFoundEvents;
                    // MONITORENTER : queue
                    if (!this.pendingSolutionFoundEvents.isEmpty()) {
                        IAlgorithmEvent iAlgorithmEvent = (IAlgorithmEvent)this.pendingSolutionFoundEvents.poll();
                        // MONITOREXIT : queue
                        return iAlgorithmEvent;
                    }
                    // MONITOREXIT : queue
                    if (this.additionalThreadsForNodeAttachment > 0) {
                        boolean poolSlotFree = false;
                        boolean haveLock = false;
                        do {
                            this.checkAndConductTermination();
                            try {
                                this.activeJobsCounterLock.lockInterruptibly();
                                haveLock = true;
                                this.bfLogger.trace("Acquired activeJobsCounterLock for read");
                                this.bfLogger.debug("The pool is currently busy with {}/{} jobs.", (Object)this.activeJobs.get(), (Object)this.additionalThreadsForNodeAttachment);
                                if (this.additionalThreadsForNodeAttachment > this.activeJobs.get()) {
                                    poolSlotFree = true;
                                }
                                this.bfLogger.trace("Number of active jobs is now {}", (Object)this.activeJobs.get());
                                if (poolSlotFree) continue;
                                this.bfLogger.trace("Releasing activeJobsCounterLock for a wait.");
                                try {
                                    haveLock = false;
                                    this.numberOfActiveJobsHasChanged.await();
                                    haveLock = true;
                                }
                                catch (InterruptedException e) {
                                    this.bfLogger.debug("Received an interrupt while waiting for number of active jobs to change.");
                                    this.activeJobsCounterLock.unlock();
                                    Thread.currentThread().interrupt();
                                    this.checkAndConductTermination();
                                }
                                this.bfLogger.trace("Re-acquired activeJobsCounterLock after a wait.");
                                this.bfLogger.debug("Number of active jobs has changed. Let's see whether we can enter now ...");
                            }
                            finally {
                                if (haveLock) {
                                    this.bfLogger.trace("Trying to unlock activeJobsCounterLock");
                                    this.activeJobsCounterLock.unlock();
                                    haveLock = false;
                                    this.bfLogger.trace("Released activeJobsCounterLock after read.");
                                } else {
                                    this.bfLogger.trace("Don't need to give lock free, because we came to the finally-block via an exception.");
                                }
                            }
                        } while (!poolSlotFree);
                    }
                    this.checkAndConductTermination();
                    IAlgorithmEvent event = this.expandNextNode();
                    if (event == null) {
                        Queue<EvaluatedSearchSolutionCandidateFoundEvent<N, A, V>> queue2 = this.pendingSolutionFoundEvents;
                        // MONITORENTER : queue2
                        if (this.pendingSolutionFoundEvents.isEmpty()) {
                            this.bfLogger.info("No event was returned and there are no pending solutions. Number of active jobs: {}. Setting state to inactive.", (Object)this.activeJobs.get());
                            AlgorithmFinishedEvent algorithmFinishedEvent = this.terminate();
                            // MONITOREXIT : queue2
                            return algorithmFinishedEvent;
                        }
                        event = (IAlgorithmEvent)this.pendingSolutionFoundEvents.poll();
                        // MONITOREXIT : queue2
                    }
                    if (!(event instanceof ISolutionCandidateFoundEvent)) {
                        this.post(event);
                    }
                    IAlgorithmEvent iAlgorithmEvent = event;
                    return iAlgorithmEvent;
                }
            }
            throw new IllegalStateException("BestFirst search is in state " + this.getState() + " in which next must not be called!");
        }
        finally {
            this.unregisterActiveThread();
        }
    }

    public void selectNodeForNextExpansion(N node) throws InterruptedException {
        this.selectNodeForNextExpansion((N)this.ext2int.get(node));
    }

    public NodeExpansionJobSubmittedEvent<N, A, V> nextNodeExpansion() {
        while (this.hasNext()) {
            IAlgorithmEvent e = this.next();
            if (!(e instanceof NodeExpansionJobSubmittedEvent)) continue;
            return (NodeExpansionJobSubmittedEvent)e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvaluatedSearchGraphPath<N, A, V> nextSolutionThatDominatesOpen() throws InterruptedException, AlgorithmExecutionCanceledException, TimeoutException, AlgorithmException {
        EvaluatedSearchGraphPath currentlyBestSolution = null;
        Object currentlyBestScore = null;
        boolean loopCondition = true;
        while (loopCondition) {
            EvaluatedSearchGraphPath solution = (EvaluatedSearchGraphPath)this.nextSolutionCandidate();
            Object scoreOfSolution = solution.getScore();
            if (currentlyBestScore == null || scoreOfSolution.compareTo(currentlyBestScore) < 0) {
                currentlyBestScore = scoreOfSolution;
                currentlyBestSolution = solution;
            }
            this.openLock.lockInterruptibly();
            try {
                loopCondition = this.open.peek().getScore().compareTo(currentlyBestScore) < 0;
            }
            finally {
                this.openLock.unlock();
            }
        }
        return currentlyBestSolution;
    }

    protected void afterInitialization() {
    }

    protected boolean beforeSelection() {
        return true;
    }

    protected void afterSelection(BackPointerPath<N, A, V> node) {
    }

    protected void beforeExpansion(BackPointerPath<N, A, V> node) {
    }

    protected void afterExpansion(BackPointerPath<N, A, V> node) {
    }

    public List<N> getCurrentPathToNode(N node) {
        return this.ext2int.get(node).getNodes();
    }

    public IPathEvaluator<N, A, V> getNodeEvaluator() {
        return this.nodeEvaluator;
    }

    public int getAdditionalThreadsForExpansion() {
        return this.additionalThreadsForNodeAttachment;
    }

    private void parallelizeNodeExpansion(int threadsForExpansion) {
        if (this.pool != null) {
            throw new UnsupportedOperationException("The number of additional threads can be only set once per search!");
        }
        if (threadsForExpansion < 1) {
            throw new IllegalArgumentException("Number of threads should be at least 1 for " + ((Object)((Object)this)).getClass().getName());
        }
        int threadsForAlgorithm = this.getConfig().threads() >= 0 ? this.getConfig().threads() : this.getConfig().cpus();
        this.additionalThreadsForNodeAttachment = threadsForExpansion;
        if (this.additionalThreadsForNodeAttachment > threadsForAlgorithm - 2) {
            this.additionalThreadsForNodeAttachment = Math.min(this.additionalThreadsForNodeAttachment, threadsForAlgorithm - 2);
        }
        if (this.additionalThreadsForNodeAttachment < 1) {
            this.bfLogger.info("Effectively not parallelizing, since only {} threads are allowed by configuration, and 2 are needed for control and maintenance.", (Object)threadsForAlgorithm);
            this.additionalThreadsForNodeAttachment = 0;
            return;
        }
        AtomicInteger counter = new AtomicInteger(0);
        this.pool = Executors.newFixedThreadPool(this.additionalThreadsForNodeAttachment, r -> {
            Thread t = new Thread(r);
            t.setName("ORGraphSearch-worker-" + counter.incrementAndGet());
            this.threadsOfPool.add(t);
            return t;
        });
    }

    public int getTimeoutForComputationOfF() {
        return this.timeoutForComputationOfF;
    }

    public void setTimeoutForComputationOfF(int timeoutInMS, IPathEvaluator<N, A, V> timeoutEvaluator) {
        this.timeoutForComputationOfF = timeoutInMS;
        this.timeoutNodeEvaluator = timeoutEvaluator;
    }

    public List<BackPointerPath<N, A, V>> getOpen() {
        return Collections.unmodifiableList(new ArrayList<BackPointerPath<N, A, V>>(this.open));
    }

    public BackPointerPath<N, A, V> getInternalRepresentationOf(N node) {
        return this.ext2int.get(node);
    }

    public void setOpen(Queue<BackPointerPath<N, A, V>> collection) {
        this.openLock.lock();
        try {
            collection.clear();
            collection.addAll(this.open);
            this.open = collection;
        }
        finally {
            this.openLock.unlock();
        }
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public void setLoggerName(String name) {
        this.bfLogger.info("Switching logger from {} to {}", (Object)this.bfLogger.getName(), (Object)name);
        this.loggerName = name;
        this.bfLogger = LoggerFactory.getLogger((String)name);
        this.bfLogger.info("Activated logger {} with name {}", (Object)name, (Object)this.bfLogger.getName());
        if (this.graphGenerator instanceof ILoggingCustomizable) {
            this.bfLogger.info("Setting logger of graph generator to {}.gg", (Object)name);
            ((ILoggingCustomizable)this.graphGenerator).setLoggerName(this.loggerName + ".gg");
        }
        if (this.nodeEvaluator instanceof ILoggingCustomizable) {
            this.bfLogger.info("Setting logger of node evaluator {} to {}.nodeevaluator", this.nodeEvaluator, (Object)name);
            ((ILoggingCustomizable)this.nodeEvaluator).setLoggerName(name + ".nodeevaluator");
        } else {
            this.bfLogger.info("Node evaluator {} does not implement ILoggingCustomizable, so its logger won't be customized.", this.nodeEvaluator);
        }
        super.setLoggerName(this.loggerName + "._orgraphsearch");
    }

    public Queue<EvaluatedSearchGraphPath<N, A, V>> getSolutionQueue() {
        return this.solutions;
    }

    public boolean isShutdownComplete() {
        return this.shutdownComplete;
    }

    public int getExpandedCounter() {
        return this.expandedCounter;
    }

    public int getCreatedCounter() {
        return this.createdCounter;
    }

    public V getFValue(N node) {
        return this.getFValue(this.ext2int.get(node));
    }

    public V getFValue(BackPointerPath<N, A, V> node) {
        return node.getScore();
    }

    public Map<String, Object> getNodeAnnotations(N node) {
        BackPointerPath<N, A, V> intNode = this.ext2int.get(node);
        return intNode.getAnnotations();
    }

    public Object getNodeAnnotation(N node, String annotation) {
        BackPointerPath<N, A, V> intNode = this.ext2int.get(node);
        return intNode.getAnnotation(annotation);
    }

    @Subscribe
    public void onFValueReceivedEvent(FValueEvent<V> event) {
        this.post(event);
    }

    public IBestFirstConfig getConfig() {
        return (IBestFirstConfig)super.getConfig();
    }

    public String toDetailedString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("graphGenerator", this.graphGenerator);
        fields.put("nodeEvaluator", this.nodeEvaluator);
        return ToJSONStringUtil.toJSONString((String)((Object)((Object)this)).getClass().getSimpleName(), fields);
    }

    public String toString() {
        return this.getId();
    }

    private class NodeBuilder
    implements Runnable {
        private final Collection<N> todoList;
        private final BackPointerPath<N, A, V> expandedNodeInternal;
        private final INewNodeDescription<N, A> successorDescription;

        public NodeBuilder(Collection<N> todoList, BackPointerPath<N, A, V> expandedNodeInternal, INewNodeDescription<N, A> successorDescription) {
            this.todoList = todoList;
            this.expandedNodeInternal = expandedNodeInternal;
            this.successorDescription = successorDescription;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void communicateJobFinished() {
            Collection collection = this.todoList;
            synchronized (collection) {
                this.todoList.remove(this.successorDescription.getTo());
                if (this.todoList.isEmpty()) {
                    BestFirst.this.post(new NodeExpansionCompletedEvent((IAlgorithm<?, ?>)BestFirst.this, this.expandedNodeInternal));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BestFirst.this.bfLogger.debug("Start node creation.");
            long start = System.currentTimeMillis();
            try {
                Object existingIdenticalNodeOnOpen;
                BackPointerPath newNode;
                block74: {
                    Comparable currentUpperBound;
                    Comparable lowerBound;
                    if (BestFirst.this.isStopCriterionSatisfied()) {
                        this.communicateJobFinished();
                        return;
                    }
                    BestFirst.this.lastExpansion.add(this.successorDescription);
                    newNode = BestFirst.this.newNode(this.expandedNodeInternal, this.successorDescription.getTo(), this.successorDescription.getArcLabel());
                    Comparable comparable = lowerBound = BestFirst.this.lowerBoundEvaluator != null ? BestFirst.this.lowerBoundEvaluator.evaluate(newNode) : null;
                    if (lowerBound != null && (currentUpperBound = BestFirst.this.getBestScoreKnownToExist()) != null && lowerBound.compareTo(currentUpperBound) >= 0) {
                        BestFirst.this.bfLogger.debug("Pruning node due to lower bound {} >= {}", (Object)lowerBound, (Object)currentUpperBound);
                        BestFirst.this.post(new NodeTypeSwitchEvent((IAlgorithm)BestFirst.this, newNode, ENodeType.OR_PRUNED.toString()));
                        return;
                    }
                    BestFirst.this.createdCounter++;
                    try {
                        BestFirst.this.labelNode(newNode);
                        if (newNode.getScore() != null) break block74;
                        BestFirst.this.post(new NodeTypeSwitchEvent((IAlgorithm)BestFirst.this, newNode, ENodeType.OR_PRUNED.toString()));
                        return;
                    }
                    catch (InterruptedException e) {
                        if (!BestFirst.this.isShutdownInitialized()) {
                            BestFirst.this.bfLogger.warn("Leaving node building routine due to interrupt. This leaves the search inconsistent; the node should be attached again!");
                        }
                        BestFirst.this.bfLogger.debug("Worker has been interrupted, exiting.");
                        BestFirst.this.post(new NodeAnnotationEvent((IAlgorithm<?, ?>)BestFirst.this, newNode, ENodeAnnotation.F_ERROR.toString(), e));
                        BestFirst.this.post(new NodeTypeSwitchEvent((IAlgorithm)BestFirst.this, newNode, ENodeType.OR_PRUNED.toString()));
                        BestFirst.this.post(new NodeInfoAlteredEvent((IAlgorithm)BestFirst.this, newNode));
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (TimeoutException e) {
                        BestFirst.this.bfLogger.debug("Node evaluation of {} has timed out.", (Object)newNode.hashCode());
                        newNode.setAnnotation(ENodeAnnotation.F_ERROR.toString(), e);
                        BestFirst.this.post(new NodeAnnotationEvent((IAlgorithm<?, ?>)BestFirst.this, newNode, ENodeAnnotation.F_ERROR.toString(), e));
                        BestFirst.this.post(new NodeTypeSwitchEvent((IAlgorithm)BestFirst.this, newNode, ENodeType.OR_TIMEDOUT.toString()));
                        BestFirst.this.post(new NodeInfoAlteredEvent((IAlgorithm)BestFirst.this, newNode));
                        return;
                    }
                    catch (Exception e) {
                        BestFirst.this.bfLogger.debug("Observed an exception during computation of f:\n{}", (Object)LoggerUtil.getExceptionInfo((Throwable)e));
                        newNode.setAnnotation(ENodeAnnotation.F_ERROR.toString(), e);
                        BestFirst.this.post(new NodeAnnotationEvent((IAlgorithm<?, ?>)BestFirst.this, newNode, ENodeAnnotation.F_ERROR.toString(), e));
                        BestFirst.this.post(new NodeTypeSwitchEvent((IAlgorithm)BestFirst.this, newNode, ENodeType.OR_PRUNED.toString()));
                        BestFirst.this.post(new NodeInfoAlteredEvent((IAlgorithm)BestFirst.this, newNode));
                        return;
                    }
                }
                BestFirst.this.post(new NodeInfoAlteredEvent((IAlgorithm)BestFirst.this, newNode));
                if (BestFirst.this.isStopCriterionSatisfied()) {
                    this.communicateJobFinished();
                    return;
                }
                Comparable bestKnownAchievableScore = BestFirst.this.getBestScoreKnownToExist();
                if (BestFirst.this.considerNodeEvaluationOptimistic && bestKnownAchievableScore != null && bestKnownAchievableScore.compareTo(newNode.getScore()) <= 0) {
                    BestFirst.this.bfLogger.info("Pruning newly generated node, since its optimistic estimate is {} and hence not better than the best already known solution score {}.", newNode.getScore(), (Object)bestKnownAchievableScore);
                    BestFirst.this.post(new NodeTypeSwitchEvent((IAlgorithm)BestFirst.this, newNode, ENodeType.OR_PRUNED.toString()));
                    return;
                }
                boolean nodeProcessed = false;
                if (BestFirst.this.getConfig().parentDiscarding() != ParentDiscarding.NONE) {
                    BestFirst.this.openLock.lockInterruptibly();
                    try {
                        Optional<Object> existingIdenticalNodeOnClosed;
                        existingIdenticalNodeOnOpen = BestFirst.this.open.stream().filter(n -> n.getHead().equals(newNode.getHead())).findFirst();
                        if (((Optional)existingIdenticalNodeOnOpen).isPresent()) {
                            BackPointerPath existingNode = (BackPointerPath)((Optional)existingIdenticalNodeOnOpen).get();
                            if (newNode.getScore().compareTo(existingNode.getScore()) < 0) {
                                BestFirst.this.post(new NodeTypeSwitchEvent((IAlgorithm)BestFirst.this, newNode, newNode.isGoal() ? ENodeType.OR_SOLUTION.toString() : ENodeType.OR_OPEN.toString()));
                                BestFirst.this.post(new NodeRemovedEvent((IAlgorithm)BestFirst.this, (Object)existingNode));
                                BestFirst.this.open.remove(existingNode);
                                if (newNode.getScore() == null) {
                                    throw new IllegalArgumentException("Cannot insert nodes with value NULL into OPEN!");
                                }
                                BestFirst.this.open.add(newNode);
                            } else {
                                BestFirst.this.post(new NodeRemovedEvent((IAlgorithm)BestFirst.this, newNode));
                            }
                            nodeProcessed = true;
                        } else if (BestFirst.this.getConfig().parentDiscarding() == ParentDiscarding.ALL && (existingIdenticalNodeOnClosed = BestFirst.this.closed.stream().filter(n -> n.equals(newNode.getHead())).findFirst()).isPresent()) {
                            BackPointerPath node2 = BestFirst.this.ext2int.get(existingIdenticalNodeOnClosed.get());
                            if (newNode.getScore().compareTo(node2.getScore()) < 0) {
                                node2.setParent(newNode.getParent());
                                node2.setScore(newNode.getScore());
                                BestFirst.this.closed.remove(node2.getHead());
                                BestFirst.this.open.add(node2);
                                BestFirst.this.post(new NodeParentSwitchEvent((IAlgorithm)BestFirst.this, node2, node2.getParent(), newNode.getParent()));
                            }
                            BestFirst.this.post(new NodeRemovedEvent((IAlgorithm)BestFirst.this, newNode));
                            nodeProcessed = true;
                        }
                    }
                    finally {
                        BestFirst.this.openLock.unlock();
                    }
                }
                if (!nodeProcessed) {
                    if (!newNode.isGoal()) {
                        BestFirst.this.openLock.lockInterruptibly();
                        existingIdenticalNodeOnOpen = BestFirst.this.expanding;
                        synchronized (existingIdenticalNodeOnOpen) {
                            try {
                                assert (!BestFirst.this.closed.contains(newNode.getHead())) : "Currently only tree search is supported. But now we add a node to OPEN whose point has already been expanded before.";
                                BestFirst.this.expanding.keySet().forEach(node -> {
                                    assert (!node.equals(newNode.getHead())) : Thread.currentThread() + " cannot add node to OPEN that is currently being expanded by " + BestFirst.access$2600(BestFirst.this).get(node) + ".\n\tFrom: " + newNode.getParent().getHead() + "\n\tTo: " + node;
                                });
                                if (newNode.getScore() == null) {
                                    throw new IllegalArgumentException("Cannot insert nodes with value NULL into OPEN!");
                                }
                                BestFirst.this.bfLogger.debug("Inserting successor {} of {} to OPEN. F-Value is {}", new Object[]{newNode.hashCode(), this.expandedNodeInternal.hashCode(), newNode.getScore()});
                                BestFirst.this.open.add(newNode);
                            }
                            finally {
                                BestFirst.this.openLock.unlock();
                            }
                        }
                    }
                    BestFirst.this.post(new NodeTypeSwitchEvent((IAlgorithm)BestFirst.this, newNode, newNode.isGoal() ? ENodeType.OR_SOLUTION.toString() : ENodeType.OR_OPEN.toString()));
                    BestFirst.this.createdCounter++;
                }
                if (newNode.isGoal()) {
                    EvaluatedSearchGraphPath solution = new EvaluatedSearchGraphPath(newNode, newNode.getScore());
                    if (!BestFirst.this.solutionReportingNodeEvaluator) {
                        BestFirst.this.registerSolution(solution);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                BestFirst.this.bfLogger.info("Node builder has been interrupted, finishing execution.");
            }
            catch (Exception e) {
                BestFirst.this.bfLogger.error("An unexpected exception occurred while building nodes", (Throwable)e);
            }
            finally {
                assert (!Thread.holdsLock(BestFirst.this.openLock)) : "Node Builder must not hold a lock on OPEN when locking the active jobs counter";
                BestFirst.this.bfLogger.debug("Trying to decrement active jobs by one.");
                BestFirst.this.bfLogger.trace("Waiting for activeJobsCounterlock to become free.");
                BestFirst.this.activeJobsCounterLock.lock();
                BestFirst.this.bfLogger.trace("Acquired activeJobsCounterLock for decrement.");
                try {
                    if (BestFirst.this.pool != null) {
                        BestFirst.this.activeJobs.decrementAndGet();
                        BestFirst.this.bfLogger.trace("Decremented job counter.");
                    }
                }
                finally {
                    BestFirst.this.numberOfActiveJobsHasChanged.signalAll();
                    BestFirst.this.activeJobsCounterLock.unlock();
                    BestFirst.this.bfLogger.trace("Released activeJobsCounterLock after decrement.");
                }
                this.communicateJobFinished();
                BestFirst.this.bfLogger.debug("Builder exits. Build process took {}ms. Interrupt-flag is {}", (Object)(System.currentTimeMillis() - start), (Object)Thread.currentThread().isInterrupted());
            }
        }
    }

    private static enum ENodeType {
        OR_PRUNED("or_pruned"),
        OR_TIMEDOUT("or_timedout"),
        OR_OPEN("or_open"),
        OR_SOLUTION("or_solution"),
        OR_CREATED("or_created"),
        OR_CLOSED("or_closed");

        private String name;

        private ENodeType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum ParentDiscarding {
        NONE,
        OPEN,
        ALL;

    }
}

