/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.bestfirst;

import ai.libs.jaicore.search.algorithms.standard.bestfirst.StandardBestFirst;
import ai.libs.jaicore.search.model.travesaltree.BackPointerPath;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithSubpathEvaluationsInput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestFirstEpsilon<T, A, W extends Comparable<W>>
extends StandardBestFirst<T, A, Double> {
    private Logger logger = LoggerFactory.getLogger(BestFirstEpsilon.class);
    private String loggerName;
    private final IPathEvaluator<T, A, W> secondaryNodeEvaluator;
    private final Map<BackPointerPath<T, A, Double>, W> secondaryCache = new HashMap<BackPointerPath<T, A, Double>, W>();
    private final OpenList focalBasedOpenList = new OpenList();
    private final boolean absolute;
    private final double epsilon;

    public BestFirstEpsilon(GraphSearchWithSubpathEvaluationsInput<T, A, Double> problem, IPathEvaluator<T, A, W> pSecondaryNodeEvaluator, int epsilon) {
        this(problem, pSecondaryNodeEvaluator, epsilon, true);
    }

    public BestFirstEpsilon(GraphSearchWithSubpathEvaluationsInput<T, A, Double> problem, IPathEvaluator<T, A, W> pSecondaryNodeEvaluator, double epsilon, boolean absolute) {
        super(problem);
        this.secondaryNodeEvaluator = pSecondaryNodeEvaluator;
        this.epsilon = epsilon;
        this.absolute = absolute;
        this.setOpen(this.focalBasedOpenList);
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        if (this.secondaryNodeEvaluator instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.secondaryNodeEvaluator).setLoggerName(name + ".secnodeeval");
        }
        super.setLoggerName(this.loggerName + "._bestfirst");
    }

    private class OpenList
    extends PriorityQueue<BackPointerPath<T, A, Double>> {
        private OpenList() {
        }

        @Override
        public BackPointerPath<T, A, Double> peek() {
            if (BestFirstEpsilon.this.epsilon <= 0.0 || BestFirstEpsilon.this.open.isEmpty()) {
                return (BackPointerPath)super.peek();
            }
            double best = (Double)((BackPointerPath)super.peek()).getScore();
            double threshold = BestFirstEpsilon.this.absolute ? (best >= 0.0 ? best + BestFirstEpsilon.this.epsilon : best - BestFirstEpsilon.this.epsilon) : best * (best >= 0.0 ? 1.0 + BestFirstEpsilon.this.epsilon : 1.0 - BestFirstEpsilon.this.epsilon);
            Collection focal = super.stream().filter(n -> (Double)n.getScore() <= threshold).collect(Collectors.toList());
            focal.stream().filter(n -> !BestFirstEpsilon.this.secondaryCache.containsKey(n)).forEach((? super T n) -> {
                try {
                    BestFirstEpsilon.this.secondaryCache.put(n, BestFirstEpsilon.this.secondaryNodeEvaluator.evaluate((ILabeledPath)n));
                }
                catch (Exception e) {
                    BestFirstEpsilon.this.logger.error("Observed exception during computation of f: {}", (Throwable)e);
                }
            });
            Optional choice = focal.stream().min((p1, p2) -> ((Comparable)BestFirstEpsilon.this.secondaryCache.get(p1)).compareTo((Comparable)BestFirstEpsilon.this.secondaryCache.get(p2)));
            if (!choice.isPresent()) {
                throw new IllegalStateException("No choice found!");
            }
            BestFirstEpsilon.this.logger.info("Best score is {}. Threshold for focal is {}. Choose node with f1 {} and best f2 {}. Size of focal was {}.", new Object[]{best, threshold, ((BackPointerPath)choice.get()).getScore(), BestFirstEpsilon.this.secondaryCache.get(choice.get()), focal.size()});
            return (BackPointerPath)choice.get();
        }
    }
}

