/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.bestfirst;

import ai.libs.jaicore.search.algorithms.standard.bestfirst.BestFirst;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.BestFirstFactory;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithSubpathEvaluationsInput;
import java.util.Objects;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.IPathGoalTester;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardBestFirstFactory<N, A, V extends Comparable<V>>
extends BestFirstFactory<GraphSearchWithSubpathEvaluationsInput<N, A, V>, N, A, V>
implements ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(StandardBestFirstFactory.class);

    public void setNodeEvaluator(IPathEvaluator<N, A, V> nodeEvaluator) {
        GraphSearchWithSubpathEvaluationsInput problem = (GraphSearchWithSubpathEvaluationsInput)this.getInput();
        IGraphGenerator gg = problem != null ? problem.getGraphGenerator() : null;
        IPathGoalTester gt = problem != null ? problem.getGoalTester() : null;
        this.setProblemInput(new GraphSearchWithSubpathEvaluationsInput(gg, gt, nodeEvaluator));
    }

    public void setGraphGenerator(IGraphGenerator<N, A> graphGenerator) {
        GraphSearchWithSubpathEvaluationsInput problem = (GraphSearchWithSubpathEvaluationsInput)this.getInput();
        Objects.requireNonNull(problem);
        IPathGoalTester gt = problem.getGoalTester();
        IPathEvaluator evaluator = problem.getPathEvaluator();
        this.setProblemInput(new GraphSearchWithSubpathEvaluationsInput(graphGenerator, gt, evaluator));
    }

    @Override
    public BestFirst<GraphSearchWithSubpathEvaluationsInput<N, A, V>, N, A, V> getAlgorithm() {
        if (((GraphSearchWithSubpathEvaluationsInput)this.getInput()).getGraphGenerator() == null) {
            throw new IllegalStateException("Cannot produce BestFirst searches before the graph generator is set in the problem.");
        }
        if (((GraphSearchWithSubpathEvaluationsInput)this.getInput()).getPathEvaluator() == null) {
            throw new IllegalStateException("Cannot produce BestFirst searches before the node evaluator is set.");
        }
        GraphSearchWithSubpathEvaluationsInput problem = (GraphSearchWithSubpathEvaluationsInput)this.getInput();
        this.logger.debug("Created algorithm input with\n\tgraph generator: {}\n\tnode evaluator: {}", problem.getGraphGenerator(), problem.getPathEvaluator());
        BestFirst search = new BestFirst(problem);
        search.setTimeoutForComputationOfF(this.getTimeoutForFInMS(), this.getTimeoutEvaluator());
        if (this.getLoggerName() != null && this.getLoggerName().length() > 0) {
            search.setLoggerName(this.getLoggerName());
        }
        return search;
    }

    @Override
    public String getLoggerName() {
        return this.logger.getName();
    }

    @Override
    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }
}

