/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.bestfirst.nodeevaluation;

import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.IPathGoalTester;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.ICancelablePathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPotentiallyGraphDependentPathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPotentiallySolutionReportingPathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.PathEvaluationException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DecoratingNodeEvaluator<N, A, V extends Comparable<V>>
implements IPathEvaluator<N, A, V>,
ICancelablePathEvaluator,
ILoggingCustomizable,
IPotentiallyGraphDependentPathEvaluator<N, A, V>,
IPotentiallySolutionReportingPathEvaluator<N, A, V> {
    private boolean canceled = false;
    private Logger logger = LoggerFactory.getLogger(DecoratingNodeEvaluator.class);
    private final IPathEvaluator<N, A, V> decoratedEvaluator;

    public DecoratingNodeEvaluator(IPathEvaluator<N, A, V> evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException("The decorated evaluator must not be null!");
        }
        this.decoratedEvaluator = evaluator;
    }

    public IPathEvaluator<N, A, V> getEvaluator() {
        return this.decoratedEvaluator;
    }

    public V evaluate(ILabeledPath<N, A> node) throws PathEvaluationException, InterruptedException {
        return (V)this.decoratedEvaluator.evaluate(node);
    }

    public boolean isDecoratedEvaluatorCancelable() {
        return this.decoratedEvaluator instanceof ICancelablePathEvaluator;
    }

    public boolean isDecoratedEvaluatorGraphDependent() {
        return this.decoratedEvaluator instanceof IPotentiallyGraphDependentPathEvaluator && ((IPotentiallyGraphDependentPathEvaluator)this.decoratedEvaluator).requiresGraphGenerator();
    }

    public boolean doesDecoratedEvaluatorReportSolutions() {
        return this.decoratedEvaluator instanceof IPotentiallySolutionReportingPathEvaluator && ((IPotentiallySolutionReportingPathEvaluator)this.decoratedEvaluator).reportsSolutions();
    }

    public boolean requiresGraphGenerator() {
        return this.isDecoratedEvaluatorGraphDependent();
    }

    public boolean reportsSolutions() {
        return this.doesDecoratedEvaluatorReportSolutions();
    }

    public void setGenerator(IGraphGenerator<N, A> generator, IPathGoalTester<N, A> goalTester) {
        this.logger.info("Setting graph generator of {} to {}", (Object)this, generator);
        if (!this.requiresGraphGenerator()) {
            throw new UnsupportedOperationException("This node evaluator is not graph dependent");
        }
        if (!this.isDecoratedEvaluatorGraphDependent()) {
            return;
        }
        ((IPotentiallyGraphDependentPathEvaluator)this.decoratedEvaluator).setGenerator(generator, goalTester);
    }

    public void registerSolutionListener(Object listener) {
        if (!this.doesDecoratedEvaluatorReportSolutions()) {
            throw new UnsupportedOperationException(this.getClass().getName() + " is not a solution reporting node evaluator");
        }
        ((IPotentiallySolutionReportingPathEvaluator)this.decoratedEvaluator).registerSolutionListener(listener);
    }

    public void cancelActiveTasks() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        if (this.isDecoratedEvaluatorCancelable()) {
            ((ICancelablePathEvaluator)this.decoratedEvaluator).cancelActiveTasks();
        }
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }
}

