/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.bestfirst.nodeevaluation;

import ai.libs.jaicore.basic.algorithm.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.logging.LoggerUtil;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.ENodeAnnotation;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.EvaluatedSearchSolutionCandidateFoundEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.NodeAnnotationEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.NodeExpansionCompletedEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.RolloutEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.exceptions.RCNEPathCompletionFailedException;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.nodeevaluation.RandomizedDepthFirstNodeEvaluator;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.nodeevaluation.TimeAwareNodeEvaluator;
import ai.libs.jaicore.search.algorithms.standard.gbf.SolutionEventBus;
import ai.libs.jaicore.search.algorithms.standard.random.RandomSearch;
import ai.libs.jaicore.search.algorithms.standard.random.RandomSearchUtil;
import ai.libs.jaicore.search.model.other.EvaluatedSearchGraphPath;
import ai.libs.jaicore.search.model.other.SearchGraphPath;
import ai.libs.jaicore.search.model.travesaltree.BackPointerPath;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithSubpathEvaluationsInput;
import ai.libs.jaicore.timing.TimedComputation;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.IPathGoalTester;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.ICancelablePathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IEvaluatedPath;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPotentiallyGraphDependentPathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPotentiallySolutionReportingPathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPotentiallyUncertaintyAnnotatingPathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IUncertaintySource;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.PathEvaluationException;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.Timeout;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.attributedobjects.IObjectEvaluator;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomCompletionBasedNodeEvaluator<T, A, V extends Comparable<V>>
extends TimeAwareNodeEvaluator<T, A, V>
implements IPotentiallyGraphDependentPathEvaluator<T, A, V>,
IPotentiallySolutionReportingPathEvaluator<T, A, V>,
ICancelablePathEvaluator,
IPotentiallyUncertaintyAnnotatingPathEvaluator<T, A, V>,
ILoggingCustomizable {
    private static final IAlgorithm<?, ?> ALGORITHM = null;
    private static final boolean LOG_FAILURES_AS_ERRORS = false;
    private String loggerName;
    private Logger logger = LoggerFactory.getLogger(RandomCompletionBasedNodeEvaluator.class);
    private final int timeoutForSingleCompletionEvaluationInMS;
    protected Set<List<T>> unsuccessfulPaths = Collections.synchronizedSet(new HashSet());
    protected Set<ILabeledPath<T, A>> postedSolutions = new HashSet<ILabeledPath<T, A>>();
    protected Map<List<T>, Integer> timesToComputeEvaluations = new HashMap<List<T>, Integer>();
    protected Map<List<T>, V> scoresOfSolutionPaths = new ConcurrentHashMap<List<T>, V>();
    protected Map<ILabeledPath<T, A>, V> fValues = new ConcurrentHashMap<ILabeledPath<T, A>, V>();
    protected Map<String, Integer> ppFails = new ConcurrentHashMap<String, Integer>();
    protected Map<String, Integer> plFails = new ConcurrentHashMap<String, Integer>();
    protected Map<String, Integer> plSuccesses = new ConcurrentHashMap<String, Integer>();
    protected T root;
    protected IGraphGenerator<T, A> generator;
    protected IPathGoalTester<T, A> goalTester;
    protected long timestampOfFirstEvaluation;
    protected final Random random;
    protected final int desiredNumberOfSuccesfulSamples;
    protected final int maxSamples;
    private final Predicate<T> priorityPredicateForRDFS;
    private RandomSearch<T, A> completer;
    private final Semaphore completerInsertionSemaphore = new Semaphore(0);
    protected final IObjectEvaluator<ILabeledPath<T, A>, V> solutionEvaluator;
    protected IUncertaintySource<T, A, V> uncertaintySource;
    protected SolutionEventBus<T> eventBus = new SolutionEventBus();
    private final List<Object> solutionListeners = new ArrayList<Object>();
    private final Map<List<T>, V> bestKnownScoreUnderNodeInCompleterGraph = new HashMap<List<T>, V>();
    private boolean visualizeSubSearch;

    public RandomCompletionBasedNodeEvaluator(Random random, int samples, IObjectEvaluator<ILabeledPath<T, A>, V> solutionEvaluator) {
        this(random, samples, samples, solutionEvaluator, -1, -1);
    }

    public RandomCompletionBasedNodeEvaluator(Random random, int desiredNumberOfSuccessfulSamples, int maxSamples, IObjectEvaluator<ILabeledPath<T, A>, V> solutionEvaluator) {
        this(random, desiredNumberOfSuccessfulSamples, maxSamples, solutionEvaluator, -1, -1);
    }

    public RandomCompletionBasedNodeEvaluator(Random random, int desiredNumberOfSuccessfulSamples, int maxSamples, IObjectEvaluator<ILabeledPath<T, A>, V> solutionEvaluator, int timeoutForSingleCompletionEvaluationInMS, int timeoutForNodeEvaluationInMS) {
        this(random, desiredNumberOfSuccessfulSamples, maxSamples, solutionEvaluator, timeoutForSingleCompletionEvaluationInMS, timeoutForNodeEvaluationInMS, null);
    }

    public RandomCompletionBasedNodeEvaluator(Random random, int desiredNumberOfSuccessfulSamples, int maxSamples, IObjectEvaluator<ILabeledPath<T, A>, V> solutionEvaluator, int timeoutForSingleCompletionEvaluationInMS, int timeoutForNodeEvaluationInMS, Predicate<T> priorityPredicateForRDFS) {
        super(timeoutForNodeEvaluationInMS);
        if (random == null) {
            throw new IllegalArgumentException("Random source must not be null!");
        }
        if (desiredNumberOfSuccessfulSamples <= 0) {
            throw new IllegalArgumentException("Sample size must be greater than 0!");
        }
        if (solutionEvaluator == null) {
            throw new IllegalArgumentException("Solution evaluator must not be null!");
        }
        this.random = random;
        this.desiredNumberOfSuccesfulSamples = desiredNumberOfSuccessfulSamples;
        this.maxSamples = maxSamples;
        this.solutionEvaluator = solutionEvaluator;
        this.timeoutForSingleCompletionEvaluationInMS = timeoutForSingleCompletionEvaluationInMS;
        this.priorityPredicateForRDFS = priorityPredicateForRDFS;
        this.logger.info("Initialized RandomCompletionEvaluator with timeout {}ms for single evaluations and {}ms in total per node. Prioriziting predicate: {}", new Object[]{timeoutForSingleCompletionEvaluationInMS, timeoutForNodeEvaluationInMS, priorityPredicateForRDFS});
        assert (this.logAssertionActivation());
    }

    private boolean logAssertionActivation() {
        StringBuilder sb = new StringBuilder();
        sb.append("Assertion remark:\n--------------------------------------------------------\n");
        sb.append("Assertions are activated.\n");
        sb.append("This may cause significant performance loss using ");
        sb.append(RandomCompletionBasedNodeEvaluator.class.getName());
        sb.append(".\nIf you are not in debugging mode, we strongly suggest to disable assertions.\n");
        sb.append("--------------------------------------------------------");
        this.logger.info("{}", (Object)sb);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected V evaluateTimeouted(ILabeledPath<T, A> path, int timeout) throws InterruptedException, PathEvaluationException {
        long deadline;
        assert (this.generator != null) : "Cannot compute f as no generator has been set!";
        if (!(path instanceof BackPointerPath)) {
            throw new IllegalArgumentException("Random Completer currently can only work with backpointer-based paths.");
        }
        BackPointerPath n = (BackPointerPath)path;
        this.eventBus.post((Object)new NodeAnnotationEvent(ALGORITHM, n.getHead(), "f-computing thread", Thread.currentThread().getName()));
        this.logger.info("Received request for f-value of node with hashCode {}. Number of subsamples will be {}, timeout for node evaluation is {}ms and for a single candidate is {}ms. Enable DEBUG for node details.", new Object[]{n.hashCode(), this.desiredNumberOfSuccesfulSamples, this.getTimeoutForNodeEvaluationInMS(), this.timeoutForSingleCompletionEvaluationInMS});
        this.logger.debug("Node details: {}", (Object)n);
        long startOfComputation = System.currentTimeMillis();
        long l = deadline = timeout > 0 ? startOfComputation + (long)timeout : -1L;
        if (this.timestampOfFirstEvaluation == 0L) {
            this.timestampOfFirstEvaluation = startOfComputation;
        }
        if (!this.fValues.containsKey(n)) {
            if (this.generator == null) {
                throw new IllegalStateException("Cannot compute f-values before the generator is set!");
            }
            List nodeList = n.getNodes();
            if (this.eventBus == null) {
                this.eventBus = new SolutionEventBus();
            }
            double uncertainty = 0.0;
            if (!n.isGoal()) {
                if (n.getParent() != null && this.completer.getExploredGraph().hasItem(n.getParent().getHead())) {
                    boolean nodeHasSibling;
                    boolean parentHasFValue = this.fValues.containsKey(n.getParent());
                    assert (parentHasFValue || n.getParent().getParent() == null) : "No f-value has been stored for the parent of node with hash code " + n.hashCode() + " (hash code of parent is " + n.getParent().hashCode() + ") whose f-value we may want to reuse.\nThis is only allowed for top-level nodes, but the actual path is: " + n.path().stream().map(k -> "\n\t" + k.hashCode() + "\t(f-value: " + k.getScore() + ")").collect(Collectors.joining());
                    boolean bl = nodeHasSibling = this.completer.getExploredGraph().getSuccessors(n.getParent().getHead()).size() > 1;
                    if (!n.isPoint() && !nodeHasSibling && parentHasFValue) {
                        Comparable score = (Comparable)this.fValues.get(n.getParent());
                        this.fValues.put((ILabeledPath<T, A>)n, score);
                        this.logger.debug("Score {} of parent can be used since the last action did not affect the performance.", (Object)score);
                        if (score == null) {
                            this.logger.warn("Returning score NULL inherited from parent, this should not happen.");
                        }
                        if (this.uncertaintySource != null) {
                            n.setAnnotation(ENodeAnnotation.F_UNCERTAINTY.name(), n.getParent().getAnnotation(ENodeAnnotation.F_UNCERTAINTY.name()));
                        }
                        assert (!this.annotatesUncertainty() || n.getAnnotation(ENodeAnnotation.F_UNCERTAINTY.name()) != null) : "No uncertainty has been annotated to node " + n + " even though we claim to annotate!";
                        return (V)score;
                    }
                }
                AtomicInteger drawnSamples = new AtomicInteger();
                AtomicInteger successfulSamples = new AtomicInteger();
                int countedExceptions = 0;
                ArrayList evaluations = new ArrayList();
                ArrayList<ILabeledPath<T, A>> completedPaths = new ArrayList<ILabeledPath<T, A>>();
                this.logger.debug("Now drawing {} successful examples but no more than {}", (Object)this.desiredNumberOfSuccesfulSamples, (Object)this.maxSamples);
                while (successfulSamples.get() < this.desiredNumberOfSuccesfulSamples) {
                    long remainingTimeForNodeEvaluation;
                    this.logger.debug("Drawing next sample. {} samples have been drawn already, {} have been successful. Thread interruption state is: {}", new Object[]{drawnSamples, successfulSamples, Thread.currentThread().isInterrupted()});
                    this.checkInterruption();
                    if (deadline > 0L && deadline < System.currentTimeMillis()) {
                        this.logger.info("Deadline for random completions hit! Finishing node evaluation.");
                        break;
                    }
                    long l2 = remainingTimeForNodeEvaluation = deadline > 0L ? deadline - System.currentTimeMillis() : -1L;
                    long timeoutForJob = remainingTimeForNodeEvaluation >= 0L && this.timeoutForSingleCompletionEvaluationInMS >= 0 ? Math.min(remainingTimeForNodeEvaluation, (long)this.timeoutForSingleCompletionEvaluationInMS) : (remainingTimeForNodeEvaluation >= 0L ? remainingTimeForNodeEvaluation : (this.timeoutForSingleCompletionEvaluationInMS >= 0 ? (long)this.timeoutForSingleCompletionEvaluationInMS : -1L));
                    ILabeledPath<T, A> tmpCompletedPath = null;
                    try {
                        this.logger.debug("Computed remaining time for evaluation: {}ms. Timeout for the job is hence {}ms. Now drawing new solution.", (Object)remainingTimeForNodeEvaluation, (Object)timeoutForJob);
                        tmpCompletedPath = this.getNextRandomPathCompletionForNode(n);
                    }
                    catch (RCNEPathCompletionFailedException e1) {
                        if (e1.getCause() instanceof InterruptedException) {
                            throw (InterruptedException)e1.getCause();
                        }
                        this.logger.info("Stopping sampling.");
                        break;
                    }
                    ILabeledPath<T, A> completedPath = tmpCompletedPath;
                    completedPaths.add(completedPath);
                    int evaluationId = this.random.nextInt(1000000);
                    this.logger.debug("Identified complete path with {} nodes. Now evaluating the path; assigning evaluation id {}", (Object)completedPath.getNumberOfNodes(), (Object)evaluationId);
                    try {
                        this.logger.debug("Enqueuing timed computation with timeout {} and evaluation id {}", (Object)timeoutForJob, (Object)evaluationId);
                        TimedComputation.compute(() -> {
                            this.logger.debug("Starting timed computation with timeout {} and evaluation id {}", (Object)timeoutForJob, (Object)evaluationId);
                            drawnSamples.incrementAndGet();
                            V val = this.getFValueOfSolutionPath(completedPath);
                            this.logger.debug("Completed path evaluation with id {}. Score is {}", (Object)evaluationId, val);
                            successfulSamples.incrementAndGet();
                            this.eventBus.post((Object)new RolloutEvent(ALGORITHM, n.path(), val));
                            if (val != null) {
                                evaluations.add(val);
                                this.updateMapOfBestScoreFoundSoFar(completedPath, val);
                            } else {
                                this.logger.warn("Got NULL result as score for evaluation with id {}", (Object)evaluationId);
                            }
                            return true;
                        }, (Timeout)new Timeout(timeoutForJob, TimeUnit.MILLISECONDS), (String)("RCNE-timeout for evaluation with id " + evaluationId));
                    }
                    catch (InterruptedException e) {
                        this.logger.debug("Path evaluation has been interrupted.");
                        throw e;
                    }
                    catch (Exception ex) {
                        if (countedExceptions == this.maxSamples) {
                            this.logger.warn("Too many retry attempts, giving up. {} samples were drawn, {} were successful. Head of path is: {}.", new Object[]{drawnSamples, successfulSamples, path.getHead()});
                            throw new PathEvaluationException("Error in the evaluation of a node!", (Throwable)ex);
                        }
                        ++countedExceptions;
                        if (ex instanceof AlgorithmTimeoutedException) {
                            this.logger.debug("Candidate evaluation failed due to timeout (either for this candidate or for the whole node).");
                            continue;
                        }
                        this.logger.warn("Could not evaluate solution candidate ... retry another completion. {}", (Object)LoggerUtil.getExceptionInfo((Throwable)ex));
                    }
                    finally {
                        this.logger.debug("Finished process for sample {}.", (Object)drawnSamples);
                    }
                }
                Comparable best = (Comparable)this.bestKnownScoreUnderNodeInCompleterGraph.get(n.getNodes());
                this.logger.debug("Finished sampling. {} samples were drawn, {} were successful. Best seen score is {}", new Object[]{drawnSamples, successfulSamples, best});
                if (best == null) {
                    if (n.getHead().equals(this.root)) {
                        this.logger.error("No completion could be drawn for the root. Apparently there is no solution in this graph!");
                    }
                    this.checkInterruption();
                    if (countedExceptions > 0) {
                        throw new NoSuchElementException("Among " + drawnSamples + " evaluated candidates, we could not identify any candidate that did not throw an exception.");
                    }
                    return null;
                }
                this.logger.debug("Checking interruption.");
                this.checkInterruption();
                this.logger.debug("Not interrupted.");
                n.setAnnotation("fRPSamples", successfulSamples);
                if (this.uncertaintySource != null) {
                    uncertainty = this.uncertaintySource.calculateUncertainty((IEvaluatedPath)n, completedPaths, evaluations);
                    this.logger.debug("Setting uncertainty to {}", (Object)uncertainty);
                } else {
                    this.logger.debug("Not setting uncertainty, because no uncertainty source has been defined.");
                }
                this.fValues.put((ILabeledPath<T, A>)n, best);
            } else {
                V score = this.getFValueOfSolutionPath(path);
                if (score == null) {
                    this.logger.warn("No score was computed");
                    return null;
                }
                this.fValues.put((ILabeledPath<T, A>)n, score);
                if (!this.postedSolutions.contains(n)) {
                    this.logger.error("Found a goal node whose solution has not been posted before!");
                }
                uncertainty = 0.0;
            }
            if (this.uncertaintySource != null) {
                n.setAnnotation(ENodeAnnotation.F_UNCERTAINTY.name(), uncertainty);
            }
        }
        assert (this.fValues.containsKey(n));
        Comparable f = (Comparable)this.fValues.get(n);
        this.logger.info("Returning f-value: {}. Annotated uncertainty is {}", (Object)f, n.getAnnotation(ENodeAnnotation.F_UNCERTAINTY.name()));
        return (V)f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILabeledPath<T, A> getNextRandomPathCompletionForNode(BackPointerPath<T, A, ?> n) throws InterruptedException, RCNEPathCompletionFailedException {
        this.logger.debug("Starting completion for path of size {}. Enable TRACE for exact path.", (Object)n.getNumberOfNodes());
        this.logger.trace("Path for which completion is drawn: {}", n.getNodes());
        if (!this.completer.knowsNode(n.getHead())) {
            RandomSearch<T, A> randomSearch = this.completer;
            synchronized (randomSearch) {
                this.completer.appendPathToNode((ILabeledPath<T, A>)n);
            }
            for (BackPointerPath<T, A, ?> current = n.getParent(); current != null && !this.fValues.containsKey(current); current = current.getParent()) {
                this.fValues.put((ILabeledPath<T, A>)current, current.getScore());
                this.logger.debug("Filling up the f-value of {} with {}", (Object)current.hashCode(), current.getScore());
            }
        }
        SearchGraphPath<T, A> completedPath = null;
        RandomSearch<T, A> randomSearch = this.completer;
        synchronized (randomSearch) {
            long startCompletion = System.currentTimeMillis();
            if (this.completer.isCanceled()) {
                this.logger.info("Completer has been canceled (perhaps due a cancel on the evaluator). Canceling sampling.");
                throw new RCNEPathCompletionFailedException("Completer has been canceled.");
            }
            this.logger.debug("Starting search for next solution ...");
            try {
                if (!this.completer.getExploredGraph().hasItem(n.getHead())) {
                    throw new IllegalStateException("The completer does not know hte head.");
                }
                completedPath = this.completer.nextSolutionUnderSubPath((ILabeledPath<T, A>)n);
            }
            catch (TimeoutException | AlgorithmExecutionCanceledException e) {
                this.logger.info("Completer has been canceled or timeouted. Returning control.");
                throw new RCNEPathCompletionFailedException((Exception)e);
            }
            if (completedPath == null) {
                this.logger.info("No completion was found for path {}.", n.getNodes());
                throw new RCNEPathCompletionFailedException("No completion found for path " + n.getNodes());
            }
            assert (completedPath.getArcs() != null) : "The RandomSearch has returned a solution path with a null pointer for the edges.";
            assert (completedPath.getNumberOfNodes() == completedPath.getArcs().size() + 1);
            assert (RandomSearchUtil.checkValidityOfPathCompletion(n, completedPath));
            long finishedCompletion = System.currentTimeMillis();
            this.logger.debug("Found completion of length {} in {}ms. Enable TRACE for details.", (Object)completedPath.getNumberOfNodes(), (Object)(finishedCompletion - startCompletion));
            this.logger.trace("Completion is {}", completedPath);
        }
        return completedPath;
    }

    private void updateMapOfBestScoreFoundSoFar(ILabeledPath<T, A> nodeInCompleterGraph, V scoreOnOriginalBenchmark) {
        Comparable bestKnownScore = (Comparable)this.bestKnownScoreUnderNodeInCompleterGraph.get(nodeInCompleterGraph.getNodes());
        if (bestKnownScore == null || scoreOnOriginalBenchmark.compareTo((Comparable)bestKnownScore) < 0) {
            this.logger.debug("Updating best score of path, because score {} is better than previously observed best score {}", scoreOnOriginalBenchmark, (Object)bestKnownScore);
            this.bestKnownScoreUnderNodeInCompleterGraph.put(nodeInCompleterGraph.getNodes(), scoreOnOriginalBenchmark);
            if (!nodeInCompleterGraph.isPoint()) {
                this.updateMapOfBestScoreFoundSoFar(nodeInCompleterGraph.getPathToParentOfHead(), scoreOnOriginalBenchmark);
            }
        }
    }

    protected V getFValueOfSolutionPath(ILabeledPath<T, A> path) throws InterruptedException, PathEvaluationException {
        boolean knownPath = this.scoresOfSolutionPaths.containsKey(path.getNodes());
        if (!knownPath) {
            if (this.unsuccessfulPaths.contains(path.getNodes())) {
                this.logger.warn("Asking again for the reevaluation of a path that was evaluated unsuccessfully in a previous run; returning NULL: {}", path);
                return null;
            }
            this.logger.debug("Associated plan is new. Calling solution evaluator {} to compute f-value for path of length {}. Enable TRACE for exact plan.", (Object)this.solutionEvaluator.getClass().getName(), (Object)path.getNumberOfNodes());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("The hash code of the path is {}", (Object)path.hashCode());
            }
            long start = System.currentTimeMillis();
            Comparable val = null;
            try {
                val = this.solutionEvaluator.evaluate(new SearchGraphPath(path));
            }
            catch (InterruptedException e) {
                this.logger.info("Received interrupt during computation of f-value.");
                throw e;
            }
            catch (Exception e) {
                this.unsuccessfulPaths.add(path.getNodes());
                throw new PathEvaluationException("Error in evaluating node!", (Throwable)e);
            }
            long duration = System.currentTimeMillis() - start;
            if (this.timeoutForSingleCompletionEvaluationInMS > 0 && duration >= (long)this.timeoutForSingleCompletionEvaluationInMS) {
                this.logger.warn("Evaluation took {}ms, but timeout is {}", (Object)duration, (Object)this.timeoutForSingleCompletionEvaluationInMS);
                assert (duration < (long)(this.timeoutForSingleCompletionEvaluationInMS + 10000)) : "Evaluation took " + duration + "ms, but timeout is " + this.timeoutForSingleCompletionEvaluationInMS;
            }
            this.logger.info("Result: {}, Size: {}", (Object)val, (Object)this.scoresOfSolutionPaths.size());
            if (val == null) {
                this.logger.warn("The solution evaluator has returned NULL, which should not happen.");
                this.unsuccessfulPaths.add(path.getNodes());
                return null;
            }
            this.scoresOfSolutionPaths.put(path.getNodes(), val);
            this.timesToComputeEvaluations.put(path.getNodes(), (int)duration);
            this.postSolution(path);
        } else {
            this.logger.info("Associated plan is known. Reading score from cache.");
            if (this.logger.isTraceEnabled()) {
                for (List<T> existingPath : this.scoresOfSolutionPaths.keySet()) {
                    if (!existingPath.equals(path)) continue;
                    this.logger.trace("The following plans appear equal:\n\t{}\n\t{}", existingPath, path);
                }
            }
            if (!this.postedSolutions.contains(path)) {
                throw new IllegalStateException("Reading cached score of a plan whose path has not been posted as a solution! Are there several paths to a plan?");
            }
        }
        Comparable score = (Comparable)this.scoresOfSolutionPaths.get(path.getNodes());
        this.logger.debug("Determined value {} for path of length {}.", (Object)score, (Object)path.getNumberOfNodes());
        assert (score != null) : "Stored scores must never be null";
        this.logger.trace("Full path is {}", path);
        return (V)score;
    }

    protected void postSolution(ILabeledPath<T, A> solution) {
        assert (!this.postedSolutions.contains(solution)) : "Solution " + solution.toString() + " already posted!";
        assert (this.goalTester.isGoal(solution)) : "Last node is not a goal node!";
        this.postedSolutions.add(solution);
        try {
            int numberOfComputedFValues = this.scoresOfSolutionPaths.size();
            if (this.eventBus == null) {
                this.eventBus = new SolutionEventBus();
            }
            EvaluatedSearchGraphPath<T, A, Comparable> solutionObject = new EvaluatedSearchGraphPath<T, A, Comparable>(solution, (Comparable)this.scoresOfSolutionPaths.get(solution.getNodes()));
            solutionObject.setAnnotation("fTime", this.timesToComputeEvaluations.get(solution.getNodes()));
            solutionObject.setAnnotation("timeToSolution", (int)(System.currentTimeMillis() - this.timestampOfFirstEvaluation));
            solutionObject.setAnnotation("nodesEvaluatedToSolution", numberOfComputedFValues);
            this.logger.debug("Posting solution {} to {} listeners: {}", new Object[]{solutionObject, this.solutionListeners.size(), this.solutionListeners});
            this.eventBus.post(new EvaluatedSearchSolutionCandidateFoundEvent<T, A, Comparable>(ALGORITHM, solutionObject));
            this.logger.debug("Posted solution {} to event bus.", solutionObject);
        }
        catch (Exception e) {
            ArrayList<Pair> explanations = new ArrayList<Pair>();
            if (this.logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                solution.getNodes().forEach(n -> sb.append(n.toString() + "\n"));
                explanations.add(new Pair((Object)"The path that has been tried to convert is as follows:", (Object)sb.toString()));
            }
            this.logger.error("Cannot post solution, because no valid MLPipeline object could be derived from it:\n{}", (Object)LoggerUtil.getExceptionInfo((Throwable)e, explanations));
        }
    }

    public void setGenerator(IGraphGenerator<T, A> generator, IPathGoalTester<T, A> goalTester) {
        this.generator = generator;
        this.root = generator.getRootGenerator().getRoots().iterator().next();
        this.goalTester = goalTester;
        RandomizedDepthFirstNodeEvaluator nodeEvaluator = new RandomizedDepthFirstNodeEvaluator(this.random);
        GraphSearchWithSubpathEvaluationsInput completionProblem = new GraphSearchWithSubpathEvaluationsInput(this.generator, this.goalTester, nodeEvaluator);
        this.completer = new RandomSearch(completionProblem, this.priorityPredicateForRDFS, this.random);
        if (this.getTotalDeadline() >= 0L) {
            this.completer.setTimeout(new Timeout(this.getTotalDeadline() - System.currentTimeMillis(), TimeUnit.MILLISECONDS));
        }
        if (this.loggerName != null) {
            this.completer.setLoggerName(this.loggerName + ".completer");
        }
        IAlgorithmEvent e = this.completer.next();
        assert (e instanceof AlgorithmInitializedEvent) : "First event of completer is not the initialization event!";
        this.logger.info("Generator has been set, and completer has been initialized");
    }

    @Subscribe
    public void receiveCompleterEvent(NodeExpansionCompletedEvent<BackPointerPath<T, A, Double>> event) {
        this.completerInsertionSemaphore.release();
    }

    public void registerSolutionListener(Object listener) {
        this.eventBus.register(listener);
        this.solutionListeners.add(listener);
    }

    public void cancelActiveTasks() {
        this.logger.info("Receive cancel signal. Canceling the completer.");
        this.completer.cancel();
    }

    public void setUncertaintySource(IUncertaintySource<T, A, V> uncertaintySource) {
        this.uncertaintySource = uncertaintySource;
    }

    public IObjectEvaluator<ILabeledPath<T, A>, V> getSolutionEvaluator() {
        return this.solutionEvaluator;
    }

    public boolean isVisualizeSubSearch() {
        return this.visualizeSubSearch;
    }

    public void setVisualizeSubSearch(boolean visualizeSubSearch) {
        this.visualizeSubSearch = visualizeSubSearch;
    }

    @Override
    public void setLoggerName(String name) {
        this.loggerName = name;
        this.logger.info("Switching logger (name) of object of class {} to {}", (Object)this.getClass().getName(), (Object)name);
        this.logger = LoggerFactory.getLogger((String)name);
        super.setLoggerName(name + "._parent");
        if (this.completer != null) {
            this.completer.setLoggerName(name + ".randomsearch");
        }
        if (this.solutionEvaluator instanceof ILoggingCustomizable) {
            this.logger.info("Setting logger of evaluator {} to {}.evaluator", (Object)this.solutionEvaluator.getClass().getName(), (Object)name);
            ((ILoggingCustomizable)this.solutionEvaluator).setLoggerName(name + ".evaluator");
        } else {
            this.logger.info("Evaluator {} is not customizable for logger, so not configuring it.", (Object)this.solutionEvaluator.getClass().getName());
        }
        this.logger.info("Switched logger (name) of {} to {}", (Object)this, (Object)name);
        this.logger.info("Reprinting RandomCompletionEvaluator configuration after logger switch: timeout {}ms for single evaluations and {}ms in total per node", (Object)this.timeoutForSingleCompletionEvaluationInMS, (Object)this.getTimeoutForNodeEvaluationInMS());
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("solutionEvaluator", this.solutionEvaluator);
        fields.put("priorizing predicate", this.priorityPredicateForRDFS);
        return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
    }

    public boolean requiresGraphGenerator() {
        return true;
    }

    public boolean reportsSolutions() {
        return true;
    }

    public boolean annotatesUncertainty() {
        return this.uncertaintySource != null;
    }
}

