/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.bestfirst.nodeevaluation;

import ai.libs.jaicore.timing.TimedComputation;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.PathEvaluationException;
import org.api4.java.algorithm.Timeout;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeAwareNodeEvaluator<T, A, V extends Comparable<V>>
implements IPathEvaluator<T, A, V>,
ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(TimeAwareNodeEvaluator.class);
    private final int timeoutForNodeEvaluationInMS;
    private long totalDeadline = -1L;
    private final IPathEvaluator<T, A, V> fallbackNodeEvaluator;

    public TimeAwareNodeEvaluator(int pTimeoutInMS) {
        this(pTimeoutInMS, n -> null);
    }

    public TimeAwareNodeEvaluator(int pTimeoutInMS, IPathEvaluator<T, A, V> pFallbackNodeEvaluator) {
        this.timeoutForNodeEvaluationInMS = pTimeoutInMS;
        this.fallbackNodeEvaluator = pFallbackNodeEvaluator;
    }

    protected abstract V evaluateTimeouted(ILabeledPath<T, A> var1, int var2) throws PathEvaluationException, InterruptedException;

    public final V evaluate(ILabeledPath<T, A> path) throws PathEvaluationException, InterruptedException {
        int remainingTime = this.totalDeadline >= 0L && this.timeoutForNodeEvaluationInMS >= 0 ? Math.min(this.timeoutForNodeEvaluationInMS, (int)(this.totalDeadline - System.currentTimeMillis())) : (this.totalDeadline >= 0L ? (int)(this.totalDeadline - System.currentTimeMillis()) : (this.timeoutForNodeEvaluationInMS >= 0 ? this.timeoutForNodeEvaluationInMS : 2147482647));
        int grantedTime = remainingTime - 50;
        int interruptionTime = remainingTime + 150;
        try {
            return (V)((Comparable)TimedComputation.compute(() -> this.evaluateTimeouted(path, grantedTime), (Timeout)new Timeout((long)interruptionTime, TimeUnit.MILLISECONDS), (String)("Node evaluation has timed out (" + TimeAwareNodeEvaluator.class.getName() + "::" + Thread.currentThread() + "-" + System.currentTimeMillis() + ")")));
        }
        catch (AlgorithmTimeoutedException e) {
            this.logger.warn("Computation of f-value for {} failed due to exception {} with message {}", new Object[]{path, ((Object)((Object)e)).getClass().getName(), e.getMessage()});
            return (V)this.fallbackNodeEvaluator.evaluate(path);
        }
        catch (InterruptedException e) {
            this.logger.info("Got interrupted during node evaluation. Throwing an InterruptedException");
            throw e;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof PathEvaluationException) {
                throw (PathEvaluationException)e.getCause();
            }
            throw new PathEvaluationException("Could not evaluate path.", e.getCause());
        }
    }

    public int getTimeoutForNodeEvaluationInMS() {
        return this.timeoutForNodeEvaluationInMS;
    }

    public IPathEvaluator<T, A, V> getFallbackNodeEvaluator() {
        return this.fallbackNodeEvaluator;
    }

    public long getTotalDeadline() {
        return this.totalDeadline;
    }

    public void setTotalDeadline(long totalDeadline) {
        this.totalDeadline = totalDeadline;
    }

    protected void checkInterruption() throws InterruptedException {
        boolean interrupted = Thread.currentThread().isInterrupted();
        this.logger.debug("Checking interruption of RCNE: {}", (Object)interrupted);
        if (interrupted) {
            Thread.interrupted();
            throw new InterruptedException("Node evaluation of " + this.getClass().getName() + " has been interrupted.");
        }
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Switched logger name to {}", (Object)name);
    }

    public String getLoggerName() {
        return this.logger.getName();
    }
}

