/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.dfs;

import ai.libs.jaicore.basic.algorithm.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.AlgorithmInitializedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.GraphInitializedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeAddedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeTypeSwitchEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.GraphSearchSolutionCandidateFoundEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.NodeExpansionCompletedEvent;
import ai.libs.jaicore.search.core.interfaces.AAnyPathInORGraphSearch;
import ai.libs.jaicore.search.model.other.SearchGraphPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.api4.java.ai.graphsearch.problem.IPathSearchInput;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.IPathGoalTester;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.api4.java.datastructure.graph.implicit.INewNodeDescription;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DepthFirstSearch<N, A>
extends AAnyPathInORGraphSearch<IPathSearchInput<N, A>, SearchGraphPath<N, A>, N, A>
implements ILoggingCustomizable {
    private String loggerName;
    private Logger logger = LoggerFactory.getLogger(DepthFirstSearch.class);
    private final IPathGoalTester<N, A> goalTester;
    private SearchGraphPath<N, A> currentPath;
    private boolean lastNodeWasTrueLeaf = false;
    private Map<N, List<N>> successorsNodes = new HashMap<N, List<N>>();
    private Map<N, List<A>> successorsEdges = new HashMap<N, List<A>>();

    public DepthFirstSearch(IPathSearchInput<N, A> problem) {
        super(problem);
        this.goalTester = problem.getGoalTester();
    }

    public IAlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        try {
            this.checkAndConductTermination();
            this.registerActiveThread();
            this.logger.debug("Conducting step. Current path length is {}", this.currentPath != null ? Integer.valueOf(this.currentPath.getNumberOfNodes()) : "0");
            switch (this.getState()) {
                case CREATED: {
                    Object root = ((ISingleRootGenerator)((IPathSearchInput)this.getInput()).getGraphGenerator().getRootGenerator()).getRoot();
                    this.post(new GraphInitializedEvent((IAlgorithm)this, root));
                    if (this.currentPath == null) {
                        this.currentPath = new SearchGraphPath(((IPathSearchInput)this.getInput()).getGraphGenerator().getRootGenerator().getRoots().iterator().next());
                    } else {
                        if (!this.currentPath.getRoot().equals(root)) {
                            throw new IllegalArgumentException("The root of the given path is not the root of the tree provided by the graph generator.");
                        }
                        int n = this.currentPath.getNumberOfNodes();
                        for (int i = 0; i < n - 1; ++i) {
                            N node = this.currentPath.getNodes().get(i);
                            for (N successor : this.successorsNodes.get(node)) {
                                this.post(new NodeAddedEvent((IAlgorithm)this, node, successor, "or_open"));
                                this.post(new NodeTypeSwitchEvent((IAlgorithm)this, node, "or_closed"));
                            }
                        }
                        N leaf = this.currentPath.getHead();
                        if (this.goalTester.isGoal(this.currentPath)) {
                            this.post(new NodeTypeSwitchEvent((IAlgorithm)this, this.currentPath.getHead(), "or_solution"));
                            this.lastNodeWasTrueLeaf = true;
                        } else if (((IPathSearchInput)this.getInput()).getGraphGenerator().getSuccessorGenerator().generateSuccessors(leaf).isEmpty()) {
                            this.lastNodeWasTrueLeaf = true;
                        }
                    }
                    this.logger.info("Algorithm activated.");
                    AlgorithmInitializedEvent n = this.activate();
                    return n;
                }
                case ACTIVE: {
                    N leaf = this.currentPath.getHead();
                    if (this.lastNodeWasTrueLeaf) {
                        int indexOfChildInSuccessorsOfParent;
                        do {
                            if (this.currentPath.getNumberOfNodes() == 1) {
                                AlgorithmFinishedEvent algorithmFinishedEvent = this.terminate();
                                return algorithmFinishedEvent;
                            }
                            this.successorsNodes.remove(leaf);
                            this.currentPath.cutHead();
                            N formerLeaf = leaf;
                            this.logger.trace("Last node {} was a leaf node (goal or dead-end) in the original graph. Computing new leaf node by first switching to the next sibling of parent {}.", formerLeaf, leaf);
                            leaf = this.currentPath.getHead();
                            indexOfChildInSuccessorsOfParent = this.successorsNodes.get(leaf).indexOf(formerLeaf);
                            assert (indexOfChildInSuccessorsOfParent >= 0) : "Could not identify node " + leaf + " as a successor of " + leaf + ". Successors of parent: " + this.successorsNodes.get(leaf);
                            this.logger.trace("Node {} is child #{} of the parent node {}.", new Object[]{formerLeaf, indexOfChildInSuccessorsOfParent, leaf});
                        } while (indexOfChildInSuccessorsOfParent == this.successorsNodes.get(leaf).size() - 1);
                        A successorAction = this.successorsEdges.get(leaf).get(indexOfChildInSuccessorsOfParent + 1);
                        leaf = this.successorsNodes.get(leaf).get(indexOfChildInSuccessorsOfParent + 1);
                        this.currentPath.extend(leaf, successorAction);
                        assert (this.checkPathConsistency(this.currentPath));
                    }
                    this.logger.debug("Relevant leaf node is {}.", leaf);
                    if (this.goalTester.isGoal(this.currentPath)) {
                        this.lastNodeWasTrueLeaf = true;
                        GraphSearchSolutionCandidateFoundEvent event = new GraphSearchSolutionCandidateFoundEvent((IAlgorithm<?, ?>)this, new SearchGraphPath(this.currentPath));
                        this.post((Object)event);
                        this.post(new NodeTypeSwitchEvent((IAlgorithm)this, leaf, "or_solution"));
                        this.logger.debug("The leaf node is a goal node. Returning goal path {}", this.currentPath);
                        GraphSearchSolutionCandidateFoundEvent indexOfChildInSuccessorsOfParent = event;
                        return indexOfChildInSuccessorsOfParent;
                    }
                    this.logger.debug("The leaf node is not a goal node. Creating successors and diving into the first one.");
                    this.post(new NodeTypeSwitchEvent((IAlgorithm)this, leaf, "or_closed"));
                    N expandedLeaf = leaf;
                    List successorsOfThis = (List)this.computeTimeoutAware(() -> ((IPathSearchInput)this.getInput()).getGraphGenerator().getSuccessorGenerator().generateSuccessors(expandedLeaf), "DFS successor generation", true);
                    long lastTerminationCheck = 0L;
                    ArrayList<Object> successorNodes = new ArrayList<Object>();
                    ArrayList<Object> successorEdges = new ArrayList<Object>();
                    for (INewNodeDescription child : successorsOfThis) {
                        this.post(new NodeAddedEvent((IAlgorithm)this, expandedLeaf, child.getTo(), "or_open"));
                        if (System.currentTimeMillis() - lastTerminationCheck > 50L) {
                            this.checkAndConductTermination();
                            lastTerminationCheck = System.currentTimeMillis();
                        }
                        successorNodes.add(child.getTo());
                        successorEdges.add(child.getArcLabel());
                    }
                    this.successorsNodes.put(leaf, successorNodes);
                    this.successorsEdges.put(leaf, successorEdges);
                    this.lastNodeWasTrueLeaf = successorsOfThis.isEmpty();
                    if (this.lastNodeWasTrueLeaf) {
                        this.logger.debug("Detected that {} is a dead-end (has no successors and is not a goal node).", leaf);
                    } else {
                        this.currentPath.extend(successorNodes.get(0), successorEdges.get(0));
                        assert (this.checkPathConsistency(this.currentPath));
                        this.logger.debug("Computed {} successors for {}, and selected {} as the next successor. Current path is now {}.", new Object[]{successorsOfThis.size(), leaf, successorsOfThis.get(0), this.currentPath});
                    }
                    Object object = new NodeExpansionCompletedEvent<N>((IAlgorithm<?, ?>)this, leaf);
                    return object;
                }
            }
            throw new IllegalStateException("Cannot do anything in state " + this.getState());
        }
        finally {
            this.unregisterActiveThread();
        }
    }

    public ILabeledPath<N, A> getCurrentPath() {
        return this.currentPath.getUnmodifiableAccessor();
    }

    public int[] getDecisionIndicesForCurrentPath() {
        int n = this.currentPath.getNumberOfNodes();
        int[] decisions = new int[n - 1];
        ILabeledPath tmpPath = this.getCurrentPath();
        Object last = null;
        for (int i = 0; i < n; ++i) {
            Object current = tmpPath.getRoot();
            if (last != null) {
                decisions[i - 1] = this.successorsNodes.get(last).indexOf(current);
                assert (decisions[i - 1] != -1);
            }
            last = current;
            tmpPath = tmpPath.getPathFromChildOfRoot();
        }
        return decisions;
    }

    public void setCurrentPath(ILabeledPath<N, A> path) {
        try {
            Object root;
            Object object = root = this.currentPath.getNumberOfNodes() == 0 ? ((ISingleRootGenerator)this.getGraphGenerator().getRootGenerator()).getRoot() : this.currentPath.getNodes().get(0);
            if (!root.equals(path.getRoot())) {
                throw new IllegalArgumentException();
            }
            HashMap tentativeSuccessors = new HashMap();
            ISuccessorGenerator successorGenerator = this.getGraphGenerator().getSuccessorGenerator();
            int n = path.getNumberOfNodes();
            for (int i = 0; i < n; ++i) {
                Object node = path.getNodes().get(i);
                if (i > 0 && !((List)tentativeSuccessors.get(path.getNodes().get(i - 1))).contains(node)) {
                    throw new IllegalArgumentException("Node " + node + " is not a successor of " + path.getNodes().get(i - 1) + " in the original graph.");
                }
                if (i >= n - 1) continue;
                tentativeSuccessors.put(node, successorGenerator.generateSuccessors(node).stream().map(INewNodeDescription::getTo).collect(Collectors.toList()));
            }
            this.currentPath = new SearchGraphPath(path);
            this.successorsNodes.clear();
            this.successorsNodes.putAll(tentativeSuccessors);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void setCurrentPath(int ... decisions) {
        try {
            N root = this.currentPath.getNumberOfNodes() == 0 ? ((ISingleRootGenerator)this.getGraphGenerator().getRootGenerator()).getRoot() : this.currentPath.getRoot();
            SearchGraphPath tentativePath = new SearchGraphPath(root);
            HashMap tentativeSuccessors = new HashMap();
            HashMap tentativeSuccessorActions = new HashMap();
            ISuccessorGenerator successorGenerator = this.getGraphGenerator().getSuccessorGenerator();
            int n = decisions.length;
            for (int i = 0; i < n; ++i) {
                N node = tentativePath.getHead();
                List descriptions = successorGenerator.generateSuccessors(node);
                tentativeSuccessors.put(node, descriptions.stream().map(INewNodeDescription::getTo).collect(Collectors.toList()));
                tentativeSuccessorActions.put(node, descriptions.stream().map(INewNodeDescription::getArcLabel).collect(Collectors.toList()));
                tentativePath.extend(((List)tentativeSuccessors.get(node)).get(decisions[i]), ((List)tentativeSuccessorActions.get(node)).get(decisions[i]));
            }
            this.currentPath = tentativePath;
            this.successorsNodes.clear();
            this.successorsNodes.putAll(tentativeSuccessors);
            this.checkPathConsistency(this.currentPath);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean checkPathConsistency(ILabeledPath<N, A> path) {
        Object last = null;
        for (Object node : path.getNodes()) {
            if (last != null) {
                assert (this.successorsNodes.containsKey(last)) : "No successor entry found for node " + last;
                if (!this.successorsNodes.containsKey(last)) {
                    return false;
                }
                if (!this.successorsNodes.get(last).contains(node)) {
                    throw new IllegalStateException("The path has an edge from " + last + " to " + node + " that is not reflected in the successors.");
                }
            }
            last = node;
        }
        return true;
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switch logger name from {} to {}", (Object)this.loggerName, (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)this.loggerName);
        if (this.getGraphGenerator() instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.getGraphGenerator()).setLoggerName(name + ".graphgen");
        }
        this.logger.info("Switched logger name to {}", (Object)this.loggerName);
        super.setLoggerName(this.loggerName + "._algorithm");
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }
}

