/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.dfs;

import ai.libs.jaicore.search.model.other.SearchGraphPath;
import ai.libs.jaicore.search.probleminputs.GraphSearchInput;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.INodeGoalTester;
import org.api4.java.datastructure.graph.implicit.INewNodeDescription;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;

public class TinyDepthFirstSearch<N, A> {
    private final List<SearchGraphPath<N, A>> solutionPaths = new LinkedList<SearchGraphPath<N, A>>();
    private final ISuccessorGenerator<N, A> successorGenerator;
    private final INodeGoalTester<N, A> goalTester;
    private final N root;
    private final Deque<N> nodes = new LinkedList<N>();
    private final Deque<A> edges = new LinkedList<A>();

    public TinyDepthFirstSearch(GraphSearchInput<N, A> problem) {
        this.root = ((ISingleRootGenerator)problem.getGraphGenerator().getRootGenerator()).getRoot();
        this.goalTester = (INodeGoalTester)problem.getGoalTester();
        this.successorGenerator = problem.getGraphGenerator().getSuccessorGenerator();
        this.nodes.add(this.root);
    }

    public void run() throws InterruptedException {
        this.dfs(this.root);
    }

    public void dfs(N head) throws InterruptedException {
        if (this.goalTester.isGoal(head)) {
            this.solutionPaths.add(new SearchGraphPath<N, A>(new ArrayList<N>(this.nodes), new ArrayList<A>(this.edges)));
        } else {
            List successors = this.successorGenerator.generateSuccessors(head);
            for (INewNodeDescription succ : successors) {
                Object to = succ.getTo();
                Object label = succ.getArcLabel();
                this.nodes.addFirst(to);
                this.edges.addFirst(label);
                this.dfs(to);
                N removed = this.nodes.removeFirst();
                this.edges.removeFirst();
                assert (removed == to) : "Expected " + to + " but removed " + removed;
            }
        }
    }

    public List<SearchGraphPath<N, A>> getSolutionPaths() {
        return this.solutionPaths;
    }
}

