/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.lds;

import ai.libs.jaicore.basic.algorithm.ASolutionCandidateFoundEvent;
import ai.libs.jaicore.basic.algorithm.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.algorithm.EAlgorithmState;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.StandardBestFirst;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.SuccessorComputationCompletedEvent;
import ai.libs.jaicore.search.algorithms.standard.lds.NodeOrderList;
import ai.libs.jaicore.search.core.interfaces.AOptimalPathInORGraphSearch;
import ai.libs.jaicore.search.model.other.EvaluatedSearchGraphPath;
import ai.libs.jaicore.search.model.travesaltree.BackPointerPath;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithNodeRecommenderInput;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithSubpathEvaluationsInput;
import com.google.common.eventbus.Subscribe;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.events.result.ISolutionCandidateFoundEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.api4.java.datastructure.graph.implicit.INewNodeDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestFirstLimitedDiscrepancySearch<I extends GraphSearchWithNodeRecommenderInput<T, A>, T, A, V extends Comparable<V>>
extends AOptimalPathInORGraphSearch<I, T, A, V> {
    private Logger logger = LoggerFactory.getLogger(BestFirstLimitedDiscrepancySearch.class);
    private String loggerName;
    private final StandardBestFirst<T, A, NodeOrderList> bestFirst;

    public BestFirstLimitedDiscrepancySearch(I problem) {
        super(problem);
        OrderListNumberComputer nodeEvaluator = new OrderListNumberComputer(((GraphSearchWithNodeRecommenderInput)problem).getRecommender());
        this.bestFirst = new StandardBestFirst(new GraphSearchWithSubpathEvaluationsInput(problem, nodeEvaluator));
        this.bestFirst.registerListener(nodeEvaluator);
    }

    public void cancel() {
        super.cancel();
        this.bestFirst.cancel();
    }

    public void registerListener(Object listener) {
        this.bestFirst.registerListener(listener);
    }

    public void setNumCPUs(int numberOfCPUs) {
        super.setNumCPUs(numberOfCPUs);
        this.bestFirst.setNumCPUs(numberOfCPUs);
    }

    public IAlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        this.checkAndConductTermination();
        if (this.getState().equals((Object)EAlgorithmState.CREATED)) {
            this.bestFirst.setTimeout(this.getTimeout());
            return this.activate();
        }
        IAlgorithmEvent e = this.bestFirst.nextWithException();
        if (e instanceof AlgorithmInitializedEvent) {
            return this.nextWithException();
        }
        if (e instanceof AlgorithmFinishedEvent) {
            return this.terminate();
        }
        if (e instanceof ISolutionCandidateFoundEvent) {
            EvaluatedSearchGraphPath solution = (EvaluatedSearchGraphPath)((ISolutionCandidateFoundEvent)e).getSolutionCandidate();
            EvaluatedSearchGraphPath modifiedSolution = new EvaluatedSearchGraphPath(solution.getNodes(), solution.getArcs(), null);
            return new ASolutionCandidateFoundEvent((IAlgorithm)this, modifiedSolution);
        }
        return e;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        if (this.bestFirst instanceof ILoggingCustomizable) {
            this.bestFirst.setLoggerName(name + ".bestfirst");
        }
        super.setLoggerName(this.loggerName + "._orgraphsearch");
    }

    private class OrderListNumberComputer
    implements IPathEvaluator<T, A, NodeOrderList> {
        private final Comparator<T> heuristic;
        private final Map<BackPointerPath<T, A, ?>, List<T>> childOrdering = new HashMap();

        public OrderListNumberComputer(Comparator<T> heuristic) {
            this.heuristic = heuristic;
        }

        public NodeOrderList evaluate(ILabeledPath<T, A> node) {
            NodeOrderList list = new NodeOrderList();
            BackPointerPath parent = ((BackPointerPath)node).getParent();
            if (parent == null) {
                return list;
            }
            list.addAll((NodeOrderList)parent.getScore());
            list.add(this.childOrdering.get(parent).indexOf(node.getHead()));
            return list;
        }

        @Subscribe
        public void receiveSuccessorsCreatedEvent(SuccessorComputationCompletedEvent<T, A, ?> successorDescriptions) {
            List successors = successorDescriptions.getSuccessorDescriptions().stream().map(INewNodeDescription::getTo).sorted(this.heuristic).collect(Collectors.toList());
            this.childOrdering.put(successorDescriptions.getNode(), successors);
        }
    }
}

