/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.lds;

import ai.libs.jaicore.basic.algorithm.ASolutionCandidateFoundEvent;
import ai.libs.jaicore.basic.algorithm.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.AlgorithmInitializedEvent;
import ai.libs.jaicore.graph.TreeNode;
import ai.libs.jaicore.graphvisualizer.events.graph.GraphInitializedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeAddedEvent;
import ai.libs.jaicore.search.algorithms.standard.lds.NoMoreNodesOnLevelEvent;
import ai.libs.jaicore.search.core.interfaces.AOptimalPathInORGraphSearch;
import ai.libs.jaicore.search.model.other.EvaluatedSearchGraphPath;
import ai.libs.jaicore.search.model.travesaltree.BackPointerPath;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithNodeRecommenderInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.IPathGoalTester;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.attributedobjects.ScoredItem;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.api4.java.datastructure.graph.implicit.INewNodeDescription;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitedDiscrepancySearch<I extends GraphSearchWithNodeRecommenderInput<N, A>, N, A, V extends Comparable<V>>
extends AOptimalPathInORGraphSearch<I, N, A, V> {
    private Logger logger = LoggerFactory.getLogger(LimitedDiscrepancySearch.class);
    private String loggerName;
    protected TreeNode<N> traversalTree;
    protected Map<N, A> actionToNode = new HashMap<N, A>();
    protected Collection<TreeNode<N>> expanded = new HashSet<TreeNode<N>>();
    protected Collection<TreeNode<N>> exhausted = new HashSet<TreeNode<N>>();
    protected final ISingleRootGenerator<N> rootGenerator = (ISingleRootGenerator)((GraphSearchWithNodeRecommenderInput)this.getInput()).getGraphGenerator().getRootGenerator();
    protected final ISuccessorGenerator<N, A> successorGenerator = ((GraphSearchWithNodeRecommenderInput)this.getInput()).getGraphGenerator().getSuccessorGenerator();
    protected final IPathGoalTester<N, A> pathGoalTester = ((GraphSearchWithNodeRecommenderInput)this.getInput()).getGoalTester();
    protected final Comparator<N> heuristic;
    private int maxK = 0;
    private int currentK = 0;

    public LimitedDiscrepancySearch(I problemInput) {
        super(problemInput);
        this.heuristic = ((GraphSearchWithNodeRecommenderInput)problemInput).getRecommender();
    }

    public IAlgorithmEvent nextWithException() throws InterruptedException, AlgorithmTimeoutedException, AlgorithmExecutionCanceledException, AlgorithmException {
        this.registerActiveThread();
        try {
            switch (this.getState()) {
                case CREATED: {
                    this.traversalTree = this.newNode(null, this.rootGenerator.getRoot());
                    this.post(new GraphInitializedEvent((IAlgorithm)this, this.traversalTree));
                    AlgorithmInitializedEvent algorithmInitializedEvent = this.activate();
                    return algorithmInitializedEvent;
                }
                case ACTIVE: {
                    this.currentK = this.maxK;
                    IAlgorithmEvent event = this.ldsProbe(this.traversalTree);
                    if (event instanceof NoMoreNodesOnLevelEvent) {
                        if (this.currentK == 0) {
                            this.logger.info("Probe process has no more nodes to be considered, restarting with augmented k {}", (Object)(this.maxK + 1));
                            ++this.maxK;
                            IAlgorithmEvent iAlgorithmEvent = event;
                            return iAlgorithmEvent;
                        }
                        AlgorithmFinishedEvent algorithmFinishedEvent = this.terminate();
                        return algorithmFinishedEvent;
                    }
                    this.logger.info("Returning event {}", (Object)event);
                    this.post(event);
                    IAlgorithmEvent iAlgorithmEvent = event;
                    return iAlgorithmEvent;
                }
            }
            throw new IllegalStateException("The algorithm cannot do anything in state " + this.getState());
        }
        finally {
            this.unregisterActiveThread();
        }
    }

    private void updateExhaustMap(TreeNode<N> node) {
        if (node == null) {
            return;
        }
        if (this.exhausted.contains(node)) {
            this.updateExhaustMap(node.getParent());
        }
        if (this.exhausted.containsAll(node.getChildren())) {
            this.exhausted.add(node);
            this.updateExhaustMap(node.getParent());
        }
    }

    private IAlgorithmEvent ldsProbe(TreeNode<N> node) throws InterruptedException, AlgorithmTimeoutedException, AlgorithmExecutionCanceledException, AlgorithmException {
        this.logger.debug("Probing under node {} with k = {}. Exhausted: {}", new Object[]{node.getValue(), this.currentK, this.exhausted.contains(node)});
        if (this.pathGoalTester.isGoal(this.getPathForGoalCheck(node.getValue()))) {
            this.updateExhaustMap(node);
            List path = node.getValuesOnPathFromRoot();
            List actions = path.stream().map(n -> this.actionToNode.get(n)).filter(Objects::nonNull).collect(Collectors.toList());
            EvaluatedSearchGraphPath solution = new EvaluatedSearchGraphPath(path, actions, null);
            this.updateBestSeenSolution((ScoredItem)solution);
            this.logger.debug("Found solution {}.", node.getValue());
            return new ASolutionCandidateFoundEvent((IAlgorithm)this, solution);
        }
        if (!this.expanded.contains(node)) {
            this.expanded.add(node);
            this.logger.debug("Starting successor generation of {}", node.getValue());
            long start = System.currentTimeMillis();
            Collection succ = (Collection)this.computeTimeoutAware(() -> this.successorGenerator.generateSuccessors(node.getValue()), "Successor generation", true);
            if (succ == null || succ.isEmpty()) {
                this.logger.debug("No successors were generated.");
                return new NoMoreNodesOnLevelEvent((IAlgorithm<?, ?>)this);
            }
            this.logger.debug("Computed {} successors in {}ms. Attaching the nodes to the local model.", (Object)succ.size(), (Object)(System.currentTimeMillis() - start));
            List prioSucc = succ.stream().sorted((d1, d2) -> this.heuristic.compare(d1.getTo(), d2.getTo())).collect(Collectors.toList());
            this.checkAndConductTermination();
            ArrayList<TreeNode<Object>> generatedNodes = new ArrayList<TreeNode<Object>>();
            long lastCheck = System.currentTimeMillis();
            for (INewNodeDescription successorDescription : prioSucc) {
                if (System.currentTimeMillis() - lastCheck > 10L) {
                    this.checkAndConductTermination();
                    lastCheck = System.currentTimeMillis();
                }
                TreeNode<Object> newNode = this.newNode(node, successorDescription.getTo());
                this.actionToNode.put(successorDescription.getTo(), successorDescription.getArcLabel());
                generatedNodes.add(newNode);
            }
            this.logger.debug("Local model updated.");
            this.checkAndConductTermination();
        } else {
            this.logger.info("Not expanding node {} again.", node.getValue());
        }
        List children = node.getChildren();
        if (children.isEmpty()) {
            return new NoMoreNodesOnLevelEvent((IAlgorithm<?, ?>)this);
        }
        if (this.currentK == 0 || children.size() == 1) {
            boolean onlyAdmissibleChildExhausted = this.exhausted.contains(children.get(0));
            this.logger.debug("No deviation allowed or only one child node. Probing this child (if not, the reason is that it is exhausted already): {}", (Object)(!onlyAdmissibleChildExhausted ? 1 : 0));
            return !onlyAdmissibleChildExhausted ? this.ldsProbe((TreeNode)children.get(0)) : new NoMoreNodesOnLevelEvent((IAlgorithm<?, ?>)this);
        }
        --this.currentK;
        this.logger.debug("Deviating from heuristic. Decreased current k to {}", (Object)this.currentK);
        if (this.exhausted.contains(children.get(1))) {
            return new NoMoreNodesOnLevelEvent((IAlgorithm<?, ?>)this);
        }
        return this.ldsProbe((TreeNode)children.get(1));
    }

    protected synchronized TreeNode<N> newNode(TreeNode<N> parent, N newNode) {
        TreeNode newTree;
        TreeNode treeNode = newTree = parent != null ? parent.addChild(newNode) : new TreeNode(newNode);
        if (parent != null) {
            boolean isGoal = this.pathGoalTester.isGoal(this.getPathForGoalCheck(newNode));
            this.post(new NodeAddedEvent((IAlgorithm)this, parent, (Object)newTree, "or_" + (isGoal ? "solution" : "created")));
        }
        return newTree;
    }

    private ILabeledPath<N, A> getPathForGoalCheck(N node) {
        return new BackPointerPath(null, node, null);
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        super.setLoggerName(this.loggerName + "._orgraphsearch");
    }
}

