/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.opencollections;

import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.search.model.travesaltree.BackPointerPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnforcedExplorationOpenSelection<N, A, V extends Comparable<V>>
extends PriorityQueue<BackPointerPath<N, A, V>> {
    private static final Logger logger = LoggerFactory.getLogger(EnforcedExplorationOpenSelection.class);
    private final Collection<BackPointerPath<N, A, V>> suspended = new ArrayList<BackPointerPath<N, A, V>>();
    private BackPointerPath<N, A, V> temporaryRoot;

    public void setTemporaryRoot(BackPointerPath<N, A, V> temporaryRoot) {
        int numItemsBefore = this.size() + this.suspended.size();
        this.temporaryRoot = temporaryRoot;
        Collection openAndSuspendedNodes = SetUtil.union((Collection[])new Collection[]{this.suspended, this});
        this.suspended.clear();
        this.clear();
        Iterator iterator = openAndSuspendedNodes.iterator();
        while (iterator.hasNext()) {
            BackPointerPath n;
            boolean isSuspsended = true;
            for (BackPointerPath current = n = (BackPointerPath)iterator.next(); current != null; current = current.getParent()) {
                if (!current.equals(temporaryRoot)) continue;
                isSuspsended = false;
                break;
            }
            if (isSuspsended) {
                this.suspended.add(n);
                continue;
            }
            this.add(n);
        }
        int numItemsAfter = this.size() + this.suspended.size();
        assert (numItemsAfter == numItemsBefore) : "The total number of elements in OPEN/SUSPENDED has changed from " + numItemsBefore + " to " + numItemsAfter + " by setting the temporary root!";
    }

    public BackPointerPath<N, A, V> getTemporaryRoot() {
        return this.temporaryRoot;
    }
}

