/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.random;

import ai.libs.jaicore.basic.algorithm.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.graph.Graph;
import ai.libs.jaicore.graph.LabeledGraph;
import ai.libs.jaicore.graphvisualizer.events.graph.GraphInitializedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeAddedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeTypeSwitchEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.GraphSearchSolutionCandidateFoundEvent;
import ai.libs.jaicore.search.algorithms.standard.random.RandomSearchUtil;
import ai.libs.jaicore.search.algorithms.standard.random.exception.IllegalArgumentForPathExtensionException;
import ai.libs.jaicore.search.core.interfaces.AAnyPathInORGraphSearch;
import ai.libs.jaicore.search.model.ILazyRandomizableSuccessorGenerator;
import ai.libs.jaicore.search.model.other.SearchGraphPath;
import ai.libs.jaicore.timing.TimedComputation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.api4.java.ai.graphsearch.problem.IPathSearchInput;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.IPathGoalTester;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.Timeout;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.api4.java.datastructure.graph.implicit.INewNodeDescription;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomSearch<N, A>
extends AAnyPathInORGraphSearch<IPathSearchInput<N, A>, SearchGraphPath<N, A>, N, A>
implements ILoggingCustomizable {
    private String loggerName;
    private Logger logger = LoggerFactory.getLogger(RandomSearch.class);
    private final ILabeledPath<N, A> root;
    private final ISuccessorGenerator<N, A> gen;
    private final boolean isRandomizableSingleNodeSuccessorGenerator;
    private final IPathGoalTester<N, A> goalTester;
    private final LabeledGraph<N, A> exploredGraph = new LabeledGraph();
    private final Set<N> closed = new HashSet<N>();
    private final Predicate<N> priorityPredicate;
    private final Set<N> prioritizedNodes = new HashSet<N>();
    private final Set<N> exhausted = new HashSet<N>();
    private final Random random;
    private final Map<N, Iterator<INewNodeDescription<N, A>>> successorGenerators = new HashMap<N, Iterator<INewNodeDescription<N, A>>>();
    private int iterations = 0;

    public RandomSearch(IPathSearchInput<N, A> problem) {
        this(problem, 0);
    }

    public RandomSearch(IPathSearchInput<N, A> problem, int seed) {
        this(problem, new Random(seed));
    }

    public RandomSearch(IPathSearchInput<N, A> problem, Random random) {
        this(problem, null, random);
    }

    public RandomSearch(IPathSearchInput<N, A> problem, Predicate<N> priorityPredicate, Random random) {
        super(problem);
        Object rootNode = ((ISingleRootGenerator)problem.getGraphGenerator().getRootGenerator()).getRoot();
        this.gen = problem.getGraphGenerator().getSuccessorGenerator();
        this.isRandomizableSingleNodeSuccessorGenerator = this.gen instanceof ILazyRandomizableSuccessorGenerator;
        this.goalTester = problem.getGoalTester();
        this.exploredGraph.addItem(rootNode);
        this.root = new SearchGraphPath(rootNode);
        this.random = random;
        this.priorityPredicate = priorityPredicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandPath(ILabeledPath<N, A> path) throws InterruptedException, AlgorithmTimeoutedException, AlgorithmExecutionCanceledException {
        LabeledGraph<N, A> labeledGraph = this.exploredGraph;
        synchronized (labeledGraph) {
            assert (this.exploredGraph.isGraphSane());
            assert (!this.goalTester.isGoal(path)) : "Goal nodes cannot be expanded!";
            Object node = path.getHead();
            assert (this.exploredGraph.hasItem(node)) : "Node that shall be expanded is not part of the graph: " + node;
            assert (!this.closed.contains(node));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Expanding next node with hash code {}", (Object)node.hashCode());
            }
            boolean closeNodeAfterwards = false;
            if (this.isRandomizableSingleNodeSuccessorGenerator) {
                this.logger.debug("Graph generator is lazy. Get iterator for node.");
                Iterator iterator = this.successorGenerators.computeIfAbsent(node, n -> ((ILazyRandomizableSuccessorGenerator)this.gen).getIterativeGenerator(n, this.random));
                if (!iterator.hasNext()) {
                    throw new IllegalArgumentForPathExtensionException("The path cannot be expanded since the head has no successors. However, it is also not marked as a goal node. Output of goal check is: " + this.goalTester.isGoal(path) + ".", path);
                }
                INewNodeDescription successor = (INewNodeDescription)iterator.next();
                assert (this.exploredGraph.isGraphSane());
                Objects.requireNonNull(successor, "Received null object as a successor");
                assert (this.exploredGraph.hasItem(node)) : "Parent node of successor is not part of the explored graph.";
                if (this.exploredGraph.getSuccessors(node).contains(successor.getTo())) {
                    throw new IllegalStateException("Single node generator has generated a known successor. Generating another candidate.");
                }
                assert (!this.exploredGraph.hasItem(successor.getTo())) : "Successor " + successor.getTo() + " has been reached before. Predecessors of that node are: " + this.exploredGraph.getPredecessors(successor.getTo());
                this.addNodeToLocalModel(path, successor.getTo(), successor.getArcLabel());
                boolean bl = closeNodeAfterwards = !iterator.hasNext();
                if (closeNodeAfterwards) {
                    this.successorGenerators.remove(node);
                }
            } else {
                List successors;
                Timeout toForSuccessorComputation = new Timeout(this.getRemainingTimeToDeadline().milliseconds() - (long)this.getTimeoutPrecautionOffset(), TimeUnit.MILLISECONDS);
                this.logger.debug("Graph generator is not lazy or cannot cope with randomness. Computing all successors of node. Timeout is {}ms", (Object)toForSuccessorComputation.milliseconds());
                long start = System.currentTimeMillis();
                try {
                    successors = (List)TimedComputation.compute(() -> this.gen.generateSuccessors(node), (Timeout)toForSuccessorComputation, (String)"Successor computation in RandomSearch");
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                this.logger.debug("Identified {} successor(s) in {}ms, which are now appended.", (Object)successors.size(), (Object)(System.currentTimeMillis() - start));
                Set knownSuccessors = this.exploredGraph.getSuccessors(node);
                long lastTerminationCheck = 0L;
                int addedSuccessors = 0;
                for (INewNodeDescription successor : successors) {
                    if (System.currentTimeMillis() - lastTerminationCheck > 100L) {
                        this.checkAndConductTermination();
                        lastTerminationCheck = System.currentTimeMillis();
                    }
                    if (knownSuccessors.contains(successor.getTo())) {
                        this.logger.debug("Skipping successor {}, which is already part of the model.", successor.getTo());
                        continue;
                    }
                    this.addNodeToLocalModel(path, successor.getTo(), successor.getArcLabel());
                    ++addedSuccessors;
                }
                this.logger.debug("{} nodes have been added to the local model. Now checking prioritization.", (Object)addedSuccessors);
                if (this.prioritizedNodes.contains(node) && SetUtil.intersection((Collection)this.exploredGraph.getSuccessors(node), this.prioritizedNodes).isEmpty()) {
                    this.prioritizedNodes.remove(node);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Removed node with code {} from set of prioritized nodes.", (Object)node.hashCode());
                    }
                    this.updateExhaustedAndPrioritizedState(node);
                }
                closeNodeAfterwards = true;
            }
            if (closeNodeAfterwards) {
                if (!this.prioritizedNodes.contains(node)) {
                    this.post(new NodeTypeSwitchEvent((IAlgorithm)this, node, "or_closed"));
                }
                this.closed.add(node);
            }
            this.logger.debug("Finished node expansion. Sizes of explored graph and CLOSED are {} and {} respectively.", (Object)this.exploredGraph.getItems().size(), (Object)this.closed.size());
        }
    }

    private SearchGraphPath<N, A> addNodeToLocalModel(ILabeledPath<N, A> path, N to, A label) {
        boolean isPrioritized;
        assert (this.exploredGraph.isGraphSane());
        Object from = path.getHead();
        assert (from != null);
        assert (to != null);
        if (this.exploredGraph.hasItem(to)) {
            throw new IllegalArgumentException("Cannot add node " + to + " to local model, because it is already contained in it.\n\tThe most probable explanation for this exception is that the underlying graph is not a tree!");
        }
        assert (this.exploredGraph.hasItem(from)) : "The head " + from + " of the path with " + path.getNumberOfNodes() + " nodes is not part of the explored graph! Here is the path: \n\t" + path.getNodes().stream().map(Object::toString).collect(Collectors.joining("\n\t"));
        this.exploredGraph.addItem(to);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Added node with hash code {} to graph.", (Object)to.hashCode());
        }
        assert (this.exploredGraph.hasItem(to));
        assert (this.exploredGraph.isGraphSane());
        boolean bl = isPrioritized = this.priorityPredicate != null && this.priorityPredicate.test(to);
        if (isPrioritized) {
            this.prioritizedNodes.add(to);
        }
        this.exploredGraph.addEdge(from, to, label);
        SearchGraphPath<N, A> extendedPath = new SearchGraphPath<N, A>(path, to, label);
        boolean isGoalNode = this.goalTester.isGoal(extendedPath);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Added node {} as a successor of {} with edge label {} to the model. Contained in prioritized: {}", new Object[]{to.hashCode(), from.hashCode(), label, this.prioritizedNodes.contains(to)});
        }
        this.post(new NodeAddedEvent((IAlgorithm)this, from, to, isGoalNode ? "or_solution" : (isPrioritized ? "or_prioritized" : "or_open")));
        return extendedPath;
    }

    public IAlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        try {
            this.registerActiveThread();
            this.logger.debug("Starting next algorithm step.");
            assert (this.exploredGraph.isGraphSane());
            switch (this.getState()) {
                case CREATED: {
                    this.post(new GraphInitializedEvent((IAlgorithm)this, this.root));
                    this.logger.info("Starting random search ...");
                    assert (this.exploredGraph.isGraphSane());
                    AlgorithmInitializedEvent algorithmInitializedEvent = this.activate();
                    return algorithmInitializedEvent;
                }
                case ACTIVE: {
                    ++this.iterations;
                    SearchGraphPath<N, A> drawnPath = null;
                    drawnPath = this.nextSolutionUnderSubPath(this.root);
                    if (drawnPath == null) {
                        this.logger.info("Drew NULL path, terminating");
                        AlgorithmFinishedEvent algorithmFinishedEvent = this.terminate();
                        return algorithmFinishedEvent;
                    }
                    assert (!drawnPath.getNodes().isEmpty() && this.goalTester.isGoal(drawnPath)) : "The drawn path is empty or its leaf node is not a goal!";
                    this.logger.info("Drew path of length {}. Posting this event. For more details on the path, enable TRACE", (Object)drawnPath.getNodes().size());
                    this.logger.trace("The drawn path is {}", drawnPath);
                    GraphSearchSolutionCandidateFoundEvent event = new GraphSearchSolutionCandidateFoundEvent((IAlgorithm<?, ?>)this, drawnPath);
                    this.logger.info("Identified new solution. Event is {}", event);
                    this.post((Object)event);
                    assert (this.exploredGraph.isGraphSane());
                    GraphSearchSolutionCandidateFoundEvent graphSearchSolutionCandidateFoundEvent = event;
                    return graphSearchSolutionCandidateFoundEvent;
                }
            }
            try {
                throw new IllegalStateException("Cannot do anything in state " + this.getState());
            }
            catch (InterruptedException e) {
                if (this.hasThreadBeenInterruptedDuringShutdown(Thread.currentThread())) {
                    this.checkTermination(false);
                    assert (false) : "The thread has been interrupted due to shutdown but apparently no stopping criterion is satisfied!";
                    throw new AlgorithmException("This part should never be reached!");
                }
                throw e;
            }
        }
        finally {
            this.unregisterActiveThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean knowsNode(N node) {
        LabeledGraph<N, A> labeledGraph = this.exploredGraph;
        synchronized (labeledGraph) {
            return this.exploredGraph.getItems().contains(node);
        }
    }

    public void appendPathToNode(ILabeledPath<N, A> path) {
        SearchGraphPath<Object, Object> cPath = new SearchGraphPath(path.getRoot());
        for (Object node : path.getNodes()) {
            if (this.exploredGraph.getItems().contains(node)) continue;
            cPath = this.addNodeToLocalModel(cPath, node, path.getInArc(node));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchGraphPath<N, A> nextSolutionUnderSubPath(ILabeledPath<N, A> path) throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Looking for next solution under node with hash code {}. Remaining time is {}. Enable TRACE for concrete node description.", (Object)path.getHead().hashCode(), (Object)this.getRemainingTimeToDeadline());
            this.logger.trace("Description of node under which we search: {}", path.getHead());
        }
        this.checkAndConductTermination();
        assert (this.exploredGraph.isGraphSane());
        if (this.exhausted.contains(path)) {
            return null;
        }
        boolean hasCheckedWhetherPrioritizedPathExists = false;
        boolean chasePrioritizedPath = false;
        ILabeledPath cPath = new SearchGraphPath(path);
        int origLength = cPath.getNumberOfNodes();
        Object head = cPath.getHead();
        int triedStepbacks = 0;
        LabeledGraph<N, A> labeledGraph = this.exploredGraph;
        synchronized (labeledGraph) {
            while (!this.goalTester.isGoal(cPath)) {
                this.checkAndConductTermination();
                assert (RandomSearchUtil.checkValidityOfPathCompletion(path, cPath)) : "Completion has become invalid!";
                assert (this.checkThatNodeExistsInExploredGraph(head));
                assert (this.exploredGraph.isGraphSane());
                if (!this.closed.contains(head)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Current head {} has not been expanded yet, expanding it now.", (Object)head.hashCode());
                    }
                    this.expandPath(cPath);
                }
                List successors = this.exploredGraph.getSuccessors(head).stream().filter(n -> !this.exhausted.contains(n)).collect(Collectors.toList());
                assert (this.exploredGraph.getSuccessors(head).stream().filter(n -> !this.exploredGraph.hasItem(n)).collect(Collectors.toList()).isEmpty()) : "Corrupt exploration graph: Some successors cannot be found again in the graph: " + this.exploredGraph.getSuccessors(head).stream().filter(n -> !this.exploredGraph.hasItem(n)).collect(Collectors.toList());
                if (successors.isEmpty()) {
                    this.logger.debug("Detected a dead-end in {}.", head);
                    this.exhausted.add(head);
                    this.prioritizedNodes.remove(head);
                    if (this.isExhausted()) {
                        this.logger.debug("The graph has been exhausted.");
                        return null;
                    }
                    if (head == path.getHead()) {
                        return null;
                    }
                    cPath = cPath.getPathToParentOfHead();
                    assert (RandomSearchUtil.checkValidityOfPathCompletion(path, cPath)) : "Completion has become invalid!";
                    head = cPath.getHead();
                    this.logger.debug("Reset head due to dead-end to parent. New head: {}.", head);
                    continue;
                }
                assert (SetUtil.intersection(this.exhausted, this.prioritizedNodes).isEmpty()) : "There are nodes that are both exhausted and prioritized, which must not be the case:" + SetUtil.intersection(this.exhausted, this.prioritizedNodes).stream().map(n -> "\n\t" + n).collect(Collectors.joining());
                Collection prioritizedSuccessors = SetUtil.intersection(successors, this.prioritizedNodes);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Number of prioritized successors of node {} is {}", (Object)head.hashCode(), (Object)prioritizedSuccessors.size());
                }
                ILabeledPath<N, A> lastHead = head;
                if (!prioritizedSuccessors.isEmpty()) {
                    head = prioritizedSuccessors.iterator().next();
                    this.logger.debug("Following arc {} to prioritized node {}", this.exploredGraph.getEdgeLabel(lastHead, head), head);
                    if (!hasCheckedWhetherPrioritizedPathExists) {
                        hasCheckedWhetherPrioritizedPathExists = true;
                        chasePrioritizedPath = true;
                    }
                } else {
                    if (chasePrioritizedPath) {
                        if (cPath.getNumberOfNodes() > origLength) {
                            this.logger.debug("The current head is not prioritized, but we know that there are prioritized nodes we could follow. Stepping back! Current head: {}", head);
                            cPath = cPath.getPathToParentOfHead();
                            head = cPath.getHead();
                            if (++triedStepbacks <= 50) continue;
                            chasePrioritizedPath = false;
                            continue;
                        }
                        this.logger.debug("The current head is not prioritized, and we throught that there should be more prioritized nodes. But we have reached the root and hence know that there are none. Hence, we change the flag and now follow unprioritized nodes!");
                        chasePrioritizedPath = false;
                        continue;
                    }
                    int n2 = successors.size();
                    assert (n2 != 0) : "Ended up in a situation where only exhausted nodes can be chosen.";
                    int k = this.random.nextInt(n2);
                    Object tmpHead = head = successors.get(k);
                    assert (!cPath.containsNode(head)) : "Going in circles ... " + cPath.getNodes().stream().map(pn -> "\n\t[" + (pn.equals(tmpHead) ? "*" : " ") + "]" + pn.toString()).collect(Collectors.joining()) + "\n\t[*]" + head;
                    this.logger.trace("Selected {} as new head.", head);
                    assert (this.checkThatNodeExistsInExploredGraph(head));
                }
                cPath.extend(head, this.exploredGraph.getEdgeLabel(lastHead, head));
            }
        }
        assert (RandomSearchUtil.checkValidityOfPathCompletion(path, cPath));
        this.logger.trace("Head node {} has been exhausted.", head);
        this.exhausted.add(head);
        this.prioritizedNodes.remove(head);
        this.updateExhaustedAndPrioritizedState(head);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Returning next solution path. Hash code is {}", (Object)cPath.hashCode());
        }
        if (cPath.getRoot() != path.getRoot()) {
            throw new IllegalStateException("Root got lost over the path!");
        }
        return head == this.root ? null : cPath;
    }

    private boolean checkThatNodeExistsInExploredGraph(N node) {
        assert (this.exploredGraph.hasItem(node)) : "Head node of random path is not in explored graph: " + node;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExhaustedAndPrioritizedState(N node) {
        LabeledGraph<N, A> labeledGraph = this.exploredGraph;
        synchronized (labeledGraph) {
            Set predecessors;
            Object current = node;
            while (!(predecessors = this.exploredGraph.getPredecessors(current)).isEmpty()) {
                boolean currentIsCompletelyExpanded;
                assert (predecessors.size() == 1);
                current = predecessors.iterator().next();
                boolean bl = currentIsCompletelyExpanded = !this.isRandomizableSingleNodeSuccessorGenerator || !this.successorGenerators.containsKey(current) || !this.successorGenerators.get(current).hasNext();
                if (!currentIsCompletelyExpanded) {
                    this.logger.trace("Leaving update routine at node {}, which has not been expanded completely.", current);
                    return;
                }
                boolean currentIsPrioritized = this.prioritizedNodes.contains(current);
                boolean allChildrenExhausted = true;
                boolean allPrioritizedChildrenExhausted = true;
                for (Object successor : this.exploredGraph.getSuccessors(current)) {
                    if (this.exhausted.contains(successor)) continue;
                    allChildrenExhausted = false;
                    if (currentIsPrioritized && this.prioritizedNodes.contains(successor)) {
                        allPrioritizedChildrenExhausted = false;
                        break;
                    }
                    if (currentIsPrioritized) continue;
                    break;
                }
                if (allChildrenExhausted) {
                    this.logger.trace("Update state of {} as being exhausted since all its children have been exhausted.", current);
                    this.exhausted.add(current);
                }
                if (!currentIsPrioritized || !allPrioritizedChildrenExhausted) continue;
                int sizeBefore = this.prioritizedNodes.size();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Removing node {} from set of prioritized nodes.", (Object)current.hashCode());
                }
                this.prioritizedNodes.remove(current);
                this.post(new NodeTypeSwitchEvent((IAlgorithm)this, current, "or_closed"));
                int sizeAfter = this.prioritizedNodes.size();
                assert (sizeAfter == sizeBefore - 1);
            }
        }
    }

    public boolean isExhausted() {
        return this.exhausted.contains(this.root.getHead());
    }

    public Graph<N> getExploredGraph() {
        return this.exploredGraph;
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switch logger name from {} to {}", (Object)this.loggerName, (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)this.loggerName);
        if (this.getGraphGenerator() instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.getGraphGenerator()).setLoggerName(name + ".graphgen");
        }
        this.logger.info("Switched logger name to {}", (Object)this.loggerName);
        super.setLoggerName(this.loggerName + "._algorithm");
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    public Random getRandom() {
        return this.random;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }
}

