/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.random;

import java.util.List;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomSearchUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomSearchUtil.class);

    private RandomSearchUtil() {
    }

    public static <N, A> boolean checkValidityOfPathCompletion(ILabeledPath<N, A> prefix, ILabeledPath<N, A> completion) throws InterruptedException {
        List prefixNodes = prefix.getNodes();
        List prefixArcs = prefix.getArcs();
        List completionNodes = completion.getNodes();
        List completionArcs = completion.getArcs();
        if (completionArcs.size() != completionNodes.size() - 1) {
            LOGGER.error("Incorrect number of arcs!");
            return false;
        }
        if (prefixArcs.size() != prefixNodes.size() - 1) {
            LOGGER.error("Incorrect number of arcs!");
            return false;
        }
        if (prefixNodes.size() > completionNodes.size()) {
            LOGGER.error("Completion is shorter than prefix!");
            return false;
        }
        int l = prefixNodes.size();
        for (int i = 0; i < l; ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (prefixNodes.get(i) != completionNodes.get(i)) {
                LOGGER.error("The {}-th node on the path does not match the respective node in the prefix:\n\tPath:\t{}\n\tPrefix:\t{}", new Object[]{i, completionNodes.get(i), prefixNodes.get(i)});
                return false;
            }
            if (i >= l - 1 || prefixArcs.get(i) == completionArcs.get(i)) continue;
            LOGGER.error("The {}-th arc on the path does not match the respective arc in the prefix:\n\tPath:\t{}\n\tPrefix:\t{}", new Object[]{i, completionArcs.get(i), prefixArcs.get(i)});
            return false;
        }
        int n = completionNodes.size();
        for (int i = l; i < n; ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (!prefixNodes.contains(completionNodes.get(i))) continue;
            LOGGER.error("A node contained in the completion (without prefix) must not also be contained in the prefix already. The following node is contained twice:\n\t{}", completionNodes.get(i));
            return false;
        }
        return true;
    }
}

