/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.rstar;

import ai.libs.jaicore.basic.algorithm.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.search.algorithms.standard.astar.AStar;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.EvaluatedSearchSolutionCandidateFoundEvent;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.NodeExpansionCompletedEvent;
import ai.libs.jaicore.search.algorithms.standard.rstar.GammaNode;
import ai.libs.jaicore.search.algorithms.standard.rstar.RStarK;
import ai.libs.jaicore.search.algorithms.standard.rstar.SubPathGraphGenerator;
import ai.libs.jaicore.search.core.interfaces.AOptimalPathInORGraphSearch;
import ai.libs.jaicore.search.model.other.EvaluatedSearchGraphPath;
import ai.libs.jaicore.search.model.other.SearchGraphPath;
import ai.libs.jaicore.search.model.travesaltree.BackPointerPath;
import ai.libs.jaicore.search.probleminputs.GraphSearchInput;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithNumberBasedAdditivePathEvaluation;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.INodeGoalTester;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.PathEvaluationException;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.Timeout;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.events.result.ISolutionCandidateFoundEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.attributedobjects.ScoredItem;
import org.api4.java.common.control.ICancelable;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.common.math.IMetric;
import org.api4.java.datastructure.graph.implicit.IRootGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RStar<I extends GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic<T, A>, T, A>
extends AOptimalPathInORGraphSearch<I, T, A, Double> {
    protected PriorityQueue<GammaNode<T, A>> open = new PriorityQueue((n1, n2) -> ((RStarK)n1.getScore()).compareTo((RStarK)n2.getScore()));
    protected ArrayList<GammaNode<T, A>> closed = new ArrayList();
    private final IPathEvaluator<T, A, Double> h;
    private final GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic.PathCostEstimator<T, A> hPath;
    private final int k;
    protected final double w;
    private final double delta;
    private final IMetric<T> metricOverStates;
    private GammaNode<T, A> bestSeenGoalNode;
    private final Map<Pair<GammaNode<T, A>, GammaNode<T, A>>, SearchGraphPath<T, A>> externalPathsBetweenGammaNodes = new HashMap<Pair<GammaNode<T, A>, GammaNode<T, A>>, SearchGraphPath<T, A>>();
    private List<ISolutionCandidateFoundEvent<EvaluatedSearchGraphPath<T, A, Double>>> unreturnedSolutionEvents = new LinkedList<ISolutionCandidateFoundEvent<EvaluatedSearchGraphPath<T, A, Double>>>();
    private Collection<AStar<T, A>> activeAStarSubroutines = new ArrayList<AStar<T, A>>();
    private Logger logger = LoggerFactory.getLogger(RStar.class);

    public RStar(I problem, double w, int k, double delta) {
        super(problem);
        this.h = ((GraphSearchWithNumberBasedAdditivePathEvaluation.FComputer)((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput()).getPathEvaluator()).getH();
        this.hPath = ((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic.SubPathEvaluationBasedFComputer)((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput()).getPathEvaluator()).gethPath();
        this.w = w;
        this.k = k;
        this.metricOverStates = ((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput()).getMetricOverStates();
        this.delta = delta;
    }

    private void updateState(GammaNode<T, A> n) throws PathEvaluationException, InterruptedException {
        if (n.getG() > this.w * (Double)this.h.evaluate(n) || (n.getParent() == null || !this.isPathRealizationKnownForAbstractEdgeToNode(n)) && n.getAvoid()) {
            n.setScore(new RStarK(true, n.getG() + this.w * (Double)this.h.evaluate(n)));
        } else {
            n.setScore(new RStarK(false, n.getG() + this.w * (Double)this.h.evaluate(n)));
        }
    }

    private void reevaluateState(GammaNode<T, A> n) throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        this.logger.debug("Reevaluating node {}", n);
        if (n.getParent() == null) {
            throw new IllegalArgumentException("Can only re-evaluate nodes that have a parent!");
        }
        GraphSearchInput subProblem = new GraphSearchInput(new SubPathGraphGenerator(((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput()).getGraphGenerator(), n.getParent().getHead()), c -> c.equals(n.getHead()));
        AStar astar = new AStar(new GraphSearchWithNumberBasedAdditivePathEvaluation(subProblem, (GraphSearchWithNumberBasedAdditivePathEvaluation.FComputer)((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput()).getPathEvaluator()));
        astar.setLoggerName(this.getLoggerName() + ".astar");
        astar.setTimeout(new Timeout(this.getRemainingTimeToDeadline().milliseconds(), TimeUnit.MILLISECONDS));
        this.logger.trace("Invoking AStar with root {} and only goal node {}", n.getParent().getHead(), n.getHead());
        this.activeAStarSubroutines.add(astar);
        EvaluatedSearchGraphPath optimalPath = (EvaluatedSearchGraphPath)astar.call();
        this.checkAndConductTermination();
        this.activeAStarSubroutines.remove((Object)astar);
        this.externalPathsBetweenGammaNodes.put(new Pair((Object)n.getParent(), n), optimalPath);
        double bestKnownValueFromParentToNode = optimalPath != null ? (Double)optimalPath.getScore() : Double.MAX_VALUE;
        ((GammaNode)n.getParent()).cLow.put(n, bestKnownValueFromParentToNode);
        if (!n.isGoal() && (optimalPath == null || ((GammaNode)n.getParent()).getG() + bestKnownValueFromParentToNode > this.w * this.hPath.h(n.getParent(), n))) {
            n.setParent(this.argminCostToStateOverPredecessors(n));
            n.setAvoid(true);
        }
        n.setG(((GammaNode)n.getParent()).getG() + ((GammaNode)n.getParent()).cLow.get(n));
        if (!n.isGoal()) {
            try {
                this.updateState(n);
            }
            catch (PathEvaluationException e) {
                throw new AlgorithmException("Failed due to path evaluation failure.", (Throwable)e);
            }
        }
    }

    public IAlgorithmEvent nextWithException() throws InterruptedException, AlgorithmException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        try {
            this.registerActiveThread();
            this.logger.debug("Performing next step. Current state is {}", (Object)this.getState());
            this.checkAndConductTermination();
            switch (this.getState()) {
                case CREATED: {
                    AlgorithmInitializedEvent initializationEvent = this.activate();
                    IRootGenerator rootGenerator = ((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput()).getGraphGenerator().getRootGenerator();
                    for (Object root : rootGenerator.getRoots()) {
                        GammaNode internalRoot = new GammaNode(root);
                        internalRoot.setScore(new RStarK(false, this.w * (Double)this.h.evaluate(internalRoot)));
                        internalRoot.setG(0.0);
                        this.open.add(internalRoot);
                    }
                    assert (!this.open.isEmpty()) : "OPEN must not be empty after initialization!";
                    AlgorithmInitializedEvent algorithmInitializedEvent = initializationEvent;
                    return algorithmInitializedEvent;
                }
                case ACTIVE: {
                    if (!this.unreturnedSolutionEvents.isEmpty()) {
                        this.logger.info("Returning known solution from solution cache!");
                        IAlgorithmEvent iAlgorithmEvent = (IAlgorithmEvent)this.unreturnedSolutionEvents.remove(0);
                        return iAlgorithmEvent;
                    }
                    GammaNode<T, A> n = this.open.poll();
                    this.logger.debug("Selected {} for expansion.", n);
                    if (n == null || this.bestSeenGoalNode != null && ((RStarK)n.getScore()).compareTo((RStarK)this.bestSeenGoalNode.getScore()) > 0) {
                        this.logger.info("Terminating RStar.");
                        AlgorithmFinishedEvent root = this.terminate();
                        return root;
                    }
                    if (n.getParent() != null && !this.isPathRealizationKnownForAbstractEdgeToNode(n)) {
                        this.reevaluateState(n);
                        this.logger.debug("Putting node {} on OPEN again", n);
                        this.open.add(n);
                    } else {
                        this.closed.add(n);
                        this.logger.debug("Starting generation of successors of {}", n);
                        Collection<GammaNode<T, A>> successors = this.generateGammaSuccessors(n);
                        this.logger.debug("Generated {} successors.", (Object)successors.size());
                        for (GammaNode<T, A> n_ : successors) {
                            boolean isNewNode;
                            n.cLow.put(n_, this.hPath.h(n, n_));
                            boolean bl = isNewNode = n_.getParent() == null;
                            if (!isNewNode && !(n.getG() + n.cLow.get(n_) < n_.getG())) continue;
                            n_.setG(n.getG() + n.cLow.get(n_));
                            n_.setParent(n);
                            this.updateState(n_);
                            if (!isNewNode) continue;
                            this.logger.debug("Adding new node {} to OPEN.", n_);
                            this.open.add(n_);
                        }
                    }
                    NodeExpansionCompletedEvent nodeExpansionCompletedEvent = new NodeExpansionCompletedEvent((IAlgorithm<?, ?>)this, n.getHead());
                    return nodeExpansionCompletedEvent;
                }
            }
            try {
                throw new IllegalStateException("Cannot do anything in state " + this.getState());
            }
            catch (PathEvaluationException e) {
                throw new AlgorithmException("Failed due to path evaluation failure.", (Throwable)e);
            }
        }
        finally {
            this.unregisterActiveThread();
        }
    }

    private boolean isPathRealizationKnownForAbstractEdgeToNode(GammaNode<T, A> node) {
        return this.externalPathsBetweenGammaNodes.containsKey(new Pair((Object)node.getParent(), node));
    }

    private EvaluatedSearchGraphPath<T, A, Double> getFullExternalPath(GammaNode<T, A> n) {
        ArrayList<Object> nodes = new ArrayList<Object>();
        ArrayList<A> edges = new ArrayList<A>();
        BackPointerPath current = n;
        nodes.add(n.getHead());
        while (current.getParent() != null) {
            Pair pair = new Pair((Object)current.getParent(), current);
            assert (this.externalPathsBetweenGammaNodes.containsKey(pair));
            SearchGraphPath<T, A> externalPath = this.externalPathsBetweenGammaNodes.get(pair);
            nodes.addAll(0, externalPath.getNodes());
            List<A> concreteEdges = externalPath.getArcs();
            if (concreteEdges == null) {
                concreteEdges = new ArrayList<A>();
                int m = externalPath.getNodes().size();
                for (int i = 0; i < m; ++i) {
                    concreteEdges.add(null);
                }
            }
            edges.addAll(0, concreteEdges);
            current = current.getParent();
        }
        return new EvaluatedSearchGraphPath(nodes, edges, n.getG());
    }

    private GammaNode<T, A> argminCostToStateOverPredecessors(GammaNode<T, A> n) {
        GammaNode<T, A> argmin = null;
        for (GammaNode<T, A> p : n.getPredecessors()) {
            if (argmin != null && !(p.getG() + p.cLow.get(n) < argmin.getG() + argmin.cLow.get(n))) continue;
            argmin = p;
        }
        return argmin;
    }

    private Collection<GammaNode<T, A>> generateGammaSuccessors(GammaNode<T, A> n) throws InterruptedException, AlgorithmTimeoutedException, AlgorithmException, AlgorithmExecutionCanceledException {
        this.logger.trace("Invoking distant successor generator timeout-aware.");
        List randomDistantSuccessors = (List)this.computeTimeoutAware(() -> ((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput()).getDistantSuccessorGenerator().getDistantSuccessors(n.getHead(), this.k, this.metricOverStates, this.delta), "Computing distant successors", true);
        assert (randomDistantSuccessors.size() == new HashSet(randomDistantSuccessors).size()) : "Distant successor generator has created the same successor ar least twice: \n\t " + SetUtil.getMultiplyContainedItems((List)randomDistantSuccessors).stream().map(Object::toString).collect(Collectors.joining("\n\t"));
        this.logger.trace("Distant successor generator generated {}/{} successors.", (Object)randomDistantSuccessors.size(), (Object)this.k);
        randomDistantSuccessors.removeIf(childNode -> this.closed.stream().anyMatch(closedNode -> closedNode.getHead().equals(childNode)));
        this.logger.trace("{} successors are still considered after having removed nodes that already are on CLOSED, which holds {} item(s).", (Object)randomDistantSuccessors.size(), (Object)this.closed.size());
        ArrayList<GammaNode<T, A>> succWithoutClosed = new ArrayList<GammaNode<T, A>>();
        for (Object childNode2 : randomDistantSuccessors) {
            GammaNode gammaNodeForThisChild;
            Optional<GammaNode> representantOnOpen = this.open.stream().filter(closedNode -> closedNode.getHead().equals(childNode2)).findFirst();
            if (representantOnOpen.isPresent()) {
                gammaNodeForThisChild = representantOnOpen.get();
            } else {
                gammaNodeForThisChild = new GammaNode(childNode2);
                gammaNodeForThisChild.setGoal(((INodeGoalTester)((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput()).getGoalTester()).isGoal(childNode2));
            }
            if (gammaNodeForThisChild.isGoal()) {
                this.logger.info("Found new solution. Adding it to the solution set.");
                if (this.bestSeenGoalNode == null || this.bestSeenGoalNode.getG() > n.getG()) {
                    this.bestSeenGoalNode = n;
                    this.updateBestSeenSolution((ScoredItem)this.getFullExternalPath(n));
                }
                EvaluatedSearchSolutionCandidateFoundEvent solutionEvent = new EvaluatedSearchSolutionCandidateFoundEvent((IAlgorithm<?, ?>)this, this.getFullExternalPath(gammaNodeForThisChild));
                this.post((Object)solutionEvent);
                this.unreturnedSolutionEvents.add((ISolutionCandidateFoundEvent<EvaluatedSearchGraphPath<T, A, Double>>)solutionEvent);
            }
            gammaNodeForThisChild.addPredecessor(n);
            succWithoutClosed.add(gammaNodeForThisChild);
        }
        return succWithoutClosed;
    }

    @Override
    public void setLoggerName(String name) {
        GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic.DistantSuccessorGenerator distantSuccessorGenerator;
        this.logger = LoggerFactory.getLogger((String)name);
        super.setLoggerName(name + "._orgraphsearch");
        if (this.getGraphGenerator() instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.getGraphGenerator()).setLoggerName(name + ".graphgenerator");
        }
        if ((distantSuccessorGenerator = ((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput()).getDistantSuccessorGenerator()) instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)distantSuccessorGenerator).setLoggerName(name + ".distantsuccessorgenerator");
        }
    }

    @Override
    public String getLoggerName() {
        return this.logger.getName();
    }

    public void cancel() {
        this.logger.info("RStar received cancel. Now invoking shutdown routing and cancel the AStar subroutines.");
        super.cancel();
        this.activeAStarSubroutines.forEach(ICancelable::cancel);
    }
}

