/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.rstar;

import ai.libs.jaicore.search.algorithms.standard.rstar.RStar;
import ai.libs.jaicore.search.core.interfaces.StandardORGraphSearchFactory;
import ai.libs.jaicore.search.model.other.EvaluatedSearchGraphPath;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;

public class RStarFactory<I extends GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic<T, A>, T, A>
extends StandardORGraphSearchFactory<I, EvaluatedSearchGraphPath<T, A, Double>, T, A, Double, RStar<I, T, A>> {
    private int timeoutForFInMS;
    private IPathEvaluator<T, A, Double> timeoutEvaluator;
    private String loggerName;
    private double w = 1.0;
    private int k = 3;
    private double delta = 0.0;

    public RStarFactory() {
    }

    public RStarFactory(int timeoutForFInMS) {
        this();
        if (timeoutForFInMS > 0) {
            this.timeoutForFInMS = timeoutForFInMS;
        }
    }

    public double getW() {
        return this.w;
    }

    public void setW(double w) {
        this.w = w;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    public RStar<I, T, A> getAlgorithm() {
        return this.getAlgorithm((I)((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput()));
    }

    public RStar<I, T, A> getAlgorithm(I input) {
        RStar search = new RStar(input, this.w, this.k, this.delta);
        if (this.loggerName != null && this.loggerName.length() > 0) {
            search.setLoggerName(this.loggerName);
        }
        return search;
    }

    public void setTimeoutForFComputation(int timeoutInMS, IPathEvaluator<T, A, Double> timeoutEvaluator) {
        this.timeoutForFInMS = timeoutInMS;
        this.timeoutEvaluator = timeoutEvaluator;
    }

    public int getTimeoutForFInMS() {
        return this.timeoutForFInMS;
    }

    public IPathEvaluator<T, A, Double> getTimeoutEvaluator() {
        return this.timeoutEvaluator;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }
}

