/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.uncertainty;

import java.util.List;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IEvaluatedPath;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IUncertaintySource;
import org.api4.java.datastructure.graph.ILabeledPath;

public class BasicUncertaintySource<T, A, V extends Comparable<V>>
implements IUncertaintySource<T, A, V> {
    public double calculateUncertainty(IEvaluatedPath<T, A, V> n, List<ILabeledPath<T, A>> simulationPaths, List<V> simulationEvaluations) {
        double uncertainty = 1.0;
        if (simulationPaths != null && !simulationPaths.isEmpty()) {
            Object t = n.getHead();
            double meanDepth = 0.0;
            for (ILabeledPath<T, A> iLabeledPath : simulationPaths) {
                if (!iLabeledPath.getNodes().contains(t) || iLabeledPath.isPoint()) continue;
                double post = 0.0;
                boolean startsCounting = false;
                for (Object pe : iLabeledPath.getNodes()) {
                    if (startsCounting) {
                        post += 1.0;
                    }
                    if (!pe.equals(t)) continue;
                    startsCounting = true;
                }
                meanDepth += post / (double)iLabeledPath.getNumberOfNodes();
            }
            if (meanDepth != 0.0) {
                uncertainty = meanDepth / (double)simulationPaths.size();
            }
        }
        if (simulationEvaluations != null && simulationEvaluations.size() > 1 && simulationEvaluations.get(0) instanceof Double) {
            double mean = 0.0;
            double sampleVariance = 0.0;
            for (Comparable f : simulationEvaluations) {
                mean += ((Double)f).doubleValue();
            }
            mean /= (double)simulationEvaluations.size();
            for (Comparable f : simulationEvaluations) {
                sampleVariance += ((Double)f - mean) * ((Double)f - mean);
            }
            sampleVariance = Math.sqrt(sampleVariance / (double)(simulationEvaluations.size() - 1));
            if (mean != 0.0) {
                double d = sampleVariance / mean;
                d = Math.max(Math.abs(d), 1.0);
                uncertainty *= d;
            }
        }
        return uncertainty;
    }
}

