/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.uncertainty.explorationexploitationsearch;

import ai.libs.jaicore.search.algorithms.standard.uncertainty.ISolutionDistanceMetric;
import ai.libs.jaicore.search.algorithms.standard.uncertainty.explorationexploitationsearch.IExplorationCandidateSelector;
import ai.libs.jaicore.search.model.travesaltree.BackPointerPath;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;

public class BasicExplorationCandidateSelector<T, A, V extends Comparable<V>>
implements IExplorationCandidateSelector<T, A, V> {
    private double minimumSolutionDistanceForExploration;

    public BasicExplorationCandidateSelector(double minimumSolutionDistanceForExploration) {
        this.minimumSolutionDistanceForExploration = minimumSolutionDistanceForExploration;
    }

    @Override
    public List<BackPointerPath<T, A, V>> selectExplorationCandidates(Queue<BackPointerPath<T, A, V>> allCandidates, BackPointerPath<T, A, V> bestCandidate, ISolutionDistanceMetric<T> solutionDistanceMetric) {
        return allCandidates.stream().filter(n -> {
            if (bestCandidate == n) {
                return false;
            }
            double solutionDistance = solutionDistanceMetric.getDistance(n.getNodes(), bestCandidate.getNodes());
            return solutionDistance >= this.minimumSolutionDistanceForExploration;
        }).collect(Collectors.toList());
    }
}

