/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.uncertainty.paretosearch;

import ai.libs.jaicore.search.algorithms.standard.bestfirst.ENodeAnnotation;
import ai.libs.jaicore.search.model.travesaltree.BackPointerPath;
import java.util.Comparator;

public class CosinusDistanceComparator<T, A, V extends Comparable<V>>
implements Comparator<BackPointerPath<T, A, V>> {
    public final double x1;
    public final double x2;

    public CosinusDistanceComparator(double x1, double x2) {
        this.x1 = x1;
        this.x2 = x2;
    }

    @Override
    public int compare(BackPointerPath<T, A, V> first, BackPointerPath<T, A, V> second) {
        Double firstF = (Double)first.getAnnotation(ENodeAnnotation.F_SCORE.name());
        Double firstU = (Double)first.getAnnotation(ENodeAnnotation.F_UNCERTAINTY.name());
        Double secondF = (Double)second.getAnnotation(ENodeAnnotation.F_SCORE.name());
        Double secondU = (Double)second.getAnnotation(ENodeAnnotation.F_UNCERTAINTY.name());
        double cosDistanceFirst = 1.0 - this.cosineSimilarity(firstF, firstU);
        double cosDistanceSecond = 1.0 - this.cosineSimilarity(secondF, secondU);
        return (int)((cosDistanceFirst - cosDistanceSecond) * 10000.0);
    }

    public double cosineSimilarity(double f, double u) {
        return (this.x1 * f + this.x2 * u) / (Math.sqrt(f * f + u * u) * Math.sqrt(this.x1 * this.x1 + this.x2 * this.x2));
    }
}

