/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.uncertainty.paretosearch;

import ai.libs.jaicore.search.model.travesaltree.BackPointerPath;
import java.util.HashSet;

public class ParetoNode<T, A, V extends Comparable<V>> {
    private final BackPointerPath<T, A, V> node;
    private final HashSet<ParetoNode<T, A, V>> dominates;
    private final HashSet<ParetoNode<T, A, V>> dominatedBy;

    public ParetoNode(BackPointerPath<T, A, V> node) {
        this.node = node;
        this.dominates = new HashSet();
        this.dominatedBy = new HashSet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{" + this.node.getHead() + "] dominated by {");
        for (ParetoNode<T, A, V> p : this.dominatedBy) {
            sb.append(p.node.getHead() + ",");
        }
        sb.append("} dominates { ");
        for (ParetoNode<T, A, V> p : this.dominates) {
            sb.append(p.node.getHead() + ",");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParetoNode other = (ParetoNode)obj;
        return !(this.node == null ? other.node != null : !this.node.equals(other.node));
    }
}

