/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.algorithms.standard.uncertainty.paretosearch;

import ai.libs.jaicore.search.algorithms.standard.bestfirst.ENodeAnnotation;
import ai.libs.jaicore.search.model.travesaltree.BackPointerPath;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class ParetoSelection<T, A, V extends Comparable<V>>
implements Queue<BackPointerPath<T, A, V>> {
    private static final String UNCERTAINTY = ENodeAnnotation.F_UNCERTAINTY.name();
    private static final String DOMINATES = "dominates";
    private static final String DOMINATED_BY = "dominatedBy";
    private final LinkedList<BackPointerPath<T, A, V>> open = new LinkedList();
    private final Queue<BackPointerPath<T, A, V>> pareto;
    private int n = 0;

    public ParetoSelection(Queue<BackPointerPath<T, A, V>> pareto) {
        this.pareto = pareto;
    }

    private boolean dominates(BackPointerPath<T, A, V> p, BackPointerPath<T, A, V> q) {
        if (!p.getAnnotations().containsKey(UNCERTAINTY)) {
            throw new IllegalArgumentException("Node " + p + " has no uncertainty information.");
        }
        if (!q.getAnnotations().containsKey(UNCERTAINTY)) {
            throw new IllegalArgumentException("Node " + q + " has no uncertainty information.");
        }
        Comparable p_f = (Comparable)p.getAnnotation("f");
        double p_u = (Double)p.getAnnotation(UNCERTAINTY);
        Comparable q_f = (Comparable)q.getAnnotation("f");
        double q_u = (Double)q.getAnnotation(UNCERTAINTY);
        return p_f.compareTo(q_f) < 0 && p_u <= q_u || p_f.compareTo(q_f) <= 0 && p_u < q_u;
    }

    private boolean isMaximal(BackPointerPath<T, A, V> n) {
        return ((HashSet)n.getAnnotation(DOMINATED_BY)).size() == 0;
    }

    @Override
    public boolean add(BackPointerPath<T, A, V> n) {
        if (n.getScore() == null) {
            throw new IllegalArgumentException("Cannot add nodes with value NULL to OPEN!");
        }
        n.setAnnotation("n", this.n++);
        n.setAnnotation(DOMINATES, new HashSet());
        n.setAnnotation(DOMINATED_BY, new HashSet());
        for (BackPointerPath backPointerPath : this.open) {
            if (this.dominates(n, backPointerPath)) {
                ((HashSet)n.getAnnotation(DOMINATES)).add(backPointerPath);
                ((HashSet)backPointerPath.getAnnotation(DOMINATED_BY)).add(n);
                if (!this.isMaximal(backPointerPath)) {
                    this.pareto.remove(backPointerPath);
                }
            }
            if (!this.dominates(backPointerPath, n)) continue;
            ((HashSet)n.getAnnotation(DOMINATES)).add(backPointerPath);
            ((HashSet)backPointerPath.getAnnotation(DOMINATED_BY)).add(n);
        }
        if (this.isMaximal(n)) {
            this.pareto.add(n);
        }
        return this.open.add(n);
    }

    @Override
    public boolean addAll(Collection<? extends BackPointerPath<T, A, V>> c) {
        boolean changed = false;
        for (BackPointerPath<T, A, V> p : c) {
            changed |= this.add(p);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.open.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.open.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.open.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.open.isEmpty();
    }

    @Override
    public Iterator<BackPointerPath<T, A, V>> iterator() {
        return this.pareto.iterator();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.open.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.open.retainAll(c);
    }

    @Override
    public int size() {
        return this.open.size();
    }

    @Override
    public Object[] toArray() {
        return this.open.toArray();
    }

    @Override
    public <X> X[] toArray(X[] a) {
        return this.open.toArray(a);
    }

    @Override
    public BackPointerPath<T, A, V> peek() {
        return this.pareto.isEmpty() ? null : this.pareto.peek();
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof BackPointerPath) {
            BackPointerPath node = (BackPointerPath)o;
            for (BackPointerPath q : (HashSet)node.getAnnotation(DOMINATES)) {
                ((HashSet)q.getAnnotation(DOMINATED_BY)).remove(node);
                if (!this.isMaximal(q)) continue;
                this.pareto.add(q);
            }
            for (BackPointerPath q : (HashSet)node.getAnnotation(DOMINATED_BY)) {
                ((HashSet)q.getAnnotation(DOMINATES)).remove(node);
            }
            this.pareto.remove(node);
            return this.open.remove(node);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OPEN LIST: \n");
        for (BackPointerPath backPointerPath : this.open) {
            sb.append(backPointerPath.toString());
            sb.append("\n");
        }
        sb.append("PARETO = [");
        for (BackPointerPath backPointerPath : this.pareto) {
            sb.append(backPointerPath.getHead());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public BackPointerPath<T, A, V> element() {
        return this.peek();
    }

    @Override
    public boolean offer(BackPointerPath<T, A, V> arg0) {
        return this.add(arg0);
    }

    @Override
    public BackPointerPath<T, A, V> poll() {
        Object node = this.peek();
        this.remove(node);
        return node;
    }

    @Override
    public BackPointerPath<T, A, V> remove() {
        return this.poll();
    }
}

