/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.core.interfaces;

import ai.libs.jaicore.basic.IOwnerBasedAlgorithmConfig;
import ai.libs.jaicore.basic.algorithm.AAlgorithm;
import ai.libs.jaicore.basic.algorithm.AOptimizer;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.events.EvaluatedSearchSolutionCandidateFoundEvent;
import ai.libs.jaicore.search.model.other.EvaluatedSearchGraphPath;
import org.api4.java.ai.graphsearch.problem.IOptimalPathInORGraphSearch;
import org.api4.java.ai.graphsearch.problem.IPathSearchInput;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.IPathGoalTester;
import org.api4.java.algorithm.IAlgorithm;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.attributedobjects.ScoredItem;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AOptimalPathInORGraphSearch<I extends IPathSearchInput<N, A>, N, A, V extends Comparable<V>>
extends AOptimizer<I, EvaluatedSearchGraphPath<N, A, V>, V>
implements IOptimalPathInORGraphSearch<I, EvaluatedSearchGraphPath<N, A, V>, N, A, V> {
    private Logger logger = LoggerFactory.getLogger(AAlgorithm.class);
    private String loggerName;

    public AOptimalPathInORGraphSearch(I problem) {
        super(problem);
    }

    protected AOptimalPathInORGraphSearch(IOwnerBasedAlgorithmConfig config, I problem) {
        super(config, problem);
    }

    public EvaluatedSearchSolutionCandidateFoundEvent<N, A, V> nextSolutionCandidateEvent() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        return (EvaluatedSearchSolutionCandidateFoundEvent)super.nextSolutionCandidateEvent();
    }

    protected EvaluatedSearchSolutionCandidateFoundEvent<N, A, V> registerSolution(EvaluatedSearchGraphPath<N, A, V> path) {
        this.updateBestSeenSolution((ScoredItem)path);
        EvaluatedSearchSolutionCandidateFoundEvent<N, A, V> event = new EvaluatedSearchSolutionCandidateFoundEvent<N, A, V>((IAlgorithm<?, ?>)this, path);
        this.logger.info("Identified solution with score {}. Now posting the solution event {} to {} listeners. Enable DEBUG to see the concrete nodes, actions and listeners.", new Object[]{path.getScore(), event, this.getListeners().size()});
        this.logger.debug("{} nodes (enable TRACE to see exact definitions). Actions: {}. Listeners: {}", new Object[]{path.getNumberOfNodes(), path.getArcs(), this.getListeners()});
        this.logger.trace("Nodes: {}", path.getNodes());
        this.post(event);
        this.logger.debug("Event transmitted successfully.");
        return event;
    }

    public IGraphGenerator<N, A> getGraphGenerator() {
        return ((IPathSearchInput)this.getInput()).getGraphGenerator();
    }

    public IPathGoalTester<N, A> getGoalTester() {
        return ((IPathSearchInput)this.getInput()).getGoalTester();
    }

    public void setLoggerName(String name) {
        this.logger.info("Switching logger to {}", (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Switched to logger {}", (Object)name);
        super.setLoggerName(this.loggerName + "._algorithm");
    }

    public String getLoggerName() {
        return this.loggerName;
    }
}

