/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.canadiantravelerproblem;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.graph.LabeledGraph;
import ai.libs.jaicore.search.exampleproblems.canadiantravelerproblem.CTPState;
import ai.libs.jaicore.search.exampleproblems.lake.ECTPEdgeKnowledge;
import ai.libs.jaicore.search.probleminputs.AMDP;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CTPMDP
extends AMDP<CTPState, Short, Double> {
    private final LabeledGraph<Short, Double> network;

    public CTPMDP(LabeledGraph<Short, Double> network) {
        super(new CTPState((ShortList)new ShortArrayList(Arrays.asList((short)0)), new HashMap<Pair<Short, Short>, ECTPEdgeKnowledge>()));
        this.network = network;
        Iterator iterator = network.getSuccessors((Object)0).iterator();
        while (iterator.hasNext()) {
            short succ = (Short)iterator.next();
            ((CTPState)this.getInitState()).getEdgeKnowledge().put((Pair<Short, Short>)new Pair((Object)0, (Object)succ), Math.random() < 0.5 ? ECTPEdgeKnowledge.KNOWN_BLOCKED : ECTPEdgeKnowledge.KNOWN_FREE);
        }
    }

    @Override
    public Collection<Short> getApplicableActions(CTPState state) {
        ArrayList<Short> applicable = new ArrayList<Short>();
        Iterator iterator = this.network.getConnected((Object)state.getPosition()).iterator();
        while (iterator.hasNext()) {
            short nextPos = (Short)iterator.next();
            if (state.getCurrentTour().contains(nextPos) && (nextPos != 0 || state.getCurrentTour().size() != this.network.getItems().size())) continue;
            short first = (short)Math.min(state.getPosition(), nextPos);
            short second = (short)Math.max(state.getPosition(), nextPos);
            ECTPEdgeKnowledge edgeKnowledge = state.getEdgeKnowledge().get(new Pair((Object)first, (Object)second));
            if (edgeKnowledge == null || edgeKnowledge == ECTPEdgeKnowledge.UNKNOWN) {
                throw new IllegalStateException("Being at one end of an edge, we should know wheter or not it is blocked. However, knowledge is: " + (Object)((Object)edgeKnowledge));
            }
            if (edgeKnowledge != ECTPEdgeKnowledge.KNOWN_FREE) continue;
            applicable.add(nextPos);
        }
        return applicable;
    }

    @Override
    public Map<CTPState, Double> getProb(CTPState state, Short action) throws InterruptedException {
        ArrayList<Pair> unknownEdges = new ArrayList<Pair>();
        Iterator iterator = this.network.getConnected((Object)action).iterator();
        while (iterator.hasNext()) {
            short nextPos = (Short)iterator.next();
            if (state.getCurrentTour().contains(nextPos)) continue;
            short first = (short)Math.min(action.shortValue(), nextPos);
            short second = (short)Math.max(action.shortValue(), nextPos);
            Pair edge = new Pair((Object)first, (Object)second);
            if (state.getEdgeKnowledge().containsKey(edge)) continue;
            unknownEdges.add(edge);
        }
        if (unknownEdges.isEmpty()) {
            HashMap<CTPState, Double> out = new HashMap<CTPState, Double>();
            Map<Pair<Short, Short>, ECTPEdgeKnowledge> curKnowledge = state.getEdgeKnowledge();
            ShortArrayList newTour = new ShortArrayList(state.getCurrentTour());
            newTour.add(action.shortValue());
            CTPState succ = new CTPState((ShortList)newTour, new HashMap<Pair<Short, Short>, ECTPEdgeKnowledge>(curKnowledge));
            out.put(succ, 1.0);
            return out;
        }
        Collection combos = SetUtil.cartesianProduct(Arrays.asList(ECTPEdgeKnowledge.KNOWN_FREE, ECTPEdgeKnowledge.KNOWN_BLOCKED), (int)unknownEdges.size());
        HashMap<CTPState, Double> out = new HashMap<CTPState, Double>();
        double prob = 1.0 / (double)combos.size();
        ShortArrayList newTour = new ShortArrayList(state.getCurrentTour());
        Map<Pair<Short, Short>, ECTPEdgeKnowledge> curKnowledge = state.getEdgeKnowledge();
        newTour.add(action.shortValue());
        for (List combo : combos) {
            HashMap<Pair<Short, Short>, ECTPEdgeKnowledge> newKnowledge = new HashMap<Pair<Short, Short>, ECTPEdgeKnowledge>(curKnowledge);
            for (int i = 0; i < unknownEdges.size(); ++i) {
                newKnowledge.put((Pair<Short, Short>)((Pair)unknownEdges.get(i)), (ECTPEdgeKnowledge)((Object)combo.get(i)));
            }
            CTPState succ = new CTPState((ShortList)newTour, newKnowledge);
            out.put(succ, prob);
        }
        return out;
    }

    @Override
    public Double getScore(CTPState state, Short action, CTPState successor) {
        short first = (short)Math.min(state.getPosition(), action.shortValue());
        short second = (short)Math.max(state.getPosition(), action.shortValue());
        if (this.getApplicableActions(successor).isEmpty()) {
            return Double.MAX_VALUE;
        }
        return (double)((Double)this.network.getEdgeLabel((Object)first, (Object)second));
    }

    @Override
    public boolean isMaximizing() {
        return false;
    }
}

