/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.cannibals;

import ai.libs.jaicore.problems.cannibals.CannibalProblem;
import ai.libs.jaicore.search.model.NodeExpansionDescription;
import java.util.ArrayList;
import java.util.List;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.api4.java.datastructure.graph.implicit.INewNodeDescription;
import org.api4.java.datastructure.graph.implicit.IRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;

public class CannibalGraphGenerator
implements IGraphGenerator<CannibalProblem, String> {
    private final CannibalProblem initState;

    public CannibalGraphGenerator(CannibalProblem initState) {
        this.initState = initState;
    }

    public IRootGenerator<CannibalProblem> getRootGenerator() {
        return new ISingleRootGenerator<CannibalProblem>(){

            public CannibalProblem getRoot() {
                return CannibalGraphGenerator.this.initState;
            }
        };
    }

    public ISuccessorGenerator<CannibalProblem, String> getSuccessorGenerator() {
        return new ISuccessorGenerator<CannibalProblem, String>(){

            public List<INewNodeDescription<CannibalProblem, String>> generateSuccessors(CannibalProblem node) throws InterruptedException {
                ArrayList<INewNodeDescription<CannibalProblem, String>> successors = new ArrayList<INewNodeDescription<CannibalProblem, String>>();
                int ml = node.getMissionariesOnLeft();
                int mr = node.getMissionariesOnRight();
                int cl = node.getCannibalsOnLeft();
                int cr = node.getCannibalsOnRight();
                if (node.isBoatOnLeft()) {
                    CannibalProblem candidate;
                    if (ml >= 2) {
                        candidate = new CannibalProblem(false, ml - 2, cl, mr + 2, cr);
                        CannibalGraphGenerator.this.checkThatNumberOfPeopleHasNotChanged(node, candidate);
                        if (!candidate.isLost()) {
                            successors.add(new NodeExpansionDescription<CannibalProblem, String>(candidate, "2m->"));
                        }
                    }
                    if (ml >= 1) {
                        candidate = new CannibalProblem(false, ml - 1, cl, mr + 1, cr);
                        CannibalGraphGenerator.this.checkThatNumberOfPeopleHasNotChanged(node, candidate);
                        if (!candidate.isLost()) {
                            successors.add(new NodeExpansionDescription<CannibalProblem, String>(candidate, "1m->"));
                        }
                    }
                    if (cl >= 1) {
                        candidate = new CannibalProblem(false, ml, cl - 1, mr, cr + 1);
                        CannibalGraphGenerator.this.checkThatNumberOfPeopleHasNotChanged(node, candidate);
                        if (!candidate.isLost()) {
                            successors.add(new NodeExpansionDescription<CannibalProblem, String>(candidate, "1c->"));
                        }
                    }
                    if (ml >= 1 && cl >= 1) {
                        candidate = new CannibalProblem(false, ml - 1, cl - 1, mr + 1, cr + 1);
                        CannibalGraphGenerator.this.checkThatNumberOfPeopleHasNotChanged(node, candidate);
                        if (!candidate.isLost()) {
                            successors.add(new NodeExpansionDescription<CannibalProblem, String>(candidate, "1m1c->"));
                        }
                    }
                    if (cl >= 2) {
                        candidate = new CannibalProblem(false, ml, cl - 2, mr, cr + 2);
                        CannibalGraphGenerator.this.checkThatNumberOfPeopleHasNotChanged(node, candidate);
                        if (!candidate.isLost()) {
                            successors.add(new NodeExpansionDescription<CannibalProblem, String>(candidate, "2c->"));
                        }
                    }
                } else {
                    CannibalProblem candidate;
                    if (mr >= 2) {
                        candidate = new CannibalProblem(true, ml + 2, cl, mr - 2, cr);
                        CannibalGraphGenerator.this.checkThatNumberOfPeopleHasNotChanged(node, candidate);
                        if (!candidate.isLost()) {
                            successors.add(new NodeExpansionDescription<CannibalProblem, String>(candidate, "2m<-"));
                        }
                    }
                    if (mr >= 1) {
                        candidate = new CannibalProblem(true, ml + 1, cl, mr - 1, cr);
                        CannibalGraphGenerator.this.checkThatNumberOfPeopleHasNotChanged(node, candidate);
                        if (!candidate.isLost()) {
                            successors.add(new NodeExpansionDescription<CannibalProblem, String>(candidate, "1m<-"));
                        }
                    }
                    if (cr >= 1) {
                        candidate = new CannibalProblem(true, ml, cl + 1, mr, cr - 1);
                        CannibalGraphGenerator.this.checkThatNumberOfPeopleHasNotChanged(node, candidate);
                        if (!candidate.isLost()) {
                            successors.add(new NodeExpansionDescription<CannibalProblem, String>(candidate, "1c<-"));
                        }
                    }
                    if (mr >= 1 && cr >= 1) {
                        candidate = new CannibalProblem(true, ml + 1, cl + 1, mr - 1, cr - 1);
                        CannibalGraphGenerator.this.checkThatNumberOfPeopleHasNotChanged(node, candidate);
                        if (!candidate.isLost()) {
                            successors.add(new NodeExpansionDescription<CannibalProblem, String>(candidate, "1m1c<-"));
                        }
                    }
                    if (cr >= 2) {
                        candidate = new CannibalProblem(true, ml, cl + 2, mr, cr - 2);
                        CannibalGraphGenerator.this.checkThatNumberOfPeopleHasNotChanged(node, candidate);
                        if (!candidate.isLost()) {
                            successors.add(new NodeExpansionDescription<CannibalProblem, String>(candidate, "2c<-"));
                        }
                    }
                }
                return successors;
            }
        };
    }

    private void checkThatNumberOfPeopleHasNotChanged(CannibalProblem a, CannibalProblem b) {
        if (a.getTotalNumberOfPeople() != b.getTotalNumberOfPeople()) {
            throw new IllegalStateException("Number of people has changed from " + a.getTotalNumberOfPeople() + " to " + b.getTotalNumberOfPeople());
        }
    }
}

