/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.enhancedttsp;

import ai.libs.jaicore.basic.MappingIterator;
import ai.libs.jaicore.interrupt.UndeclaredInterruptedException;
import ai.libs.jaicore.problems.enhancedttsp.EnhancedTTSP;
import ai.libs.jaicore.problems.enhancedttsp.EnhancedTTSPState;
import ai.libs.jaicore.search.model.NodeExpansionDescription;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.api4.java.datastructure.graph.implicit.ILazySuccessorGenerator;
import org.api4.java.datastructure.graph.implicit.INewNodeDescription;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedTTSPSimpleGraphGenerator
implements IGraphGenerator<EnhancedTTSPState, String>,
ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(EnhancedTTSPSimpleGraphGenerator.class);
    private final EnhancedTTSP problem;

    public EnhancedTTSPSimpleGraphGenerator(EnhancedTTSP problem) {
        this.problem = problem;
    }

    public ISingleRootGenerator<EnhancedTTSPState> getRootGenerator() {
        return () -> ((EnhancedTTSP)this.problem).getInitalState();
    }

    public ISuccessorGenerator<EnhancedTTSPState, String> getSuccessorGenerator() {
        return new ILazySuccessorGenerator<EnhancedTTSPState, String>(){

            public List<INewNodeDescription<EnhancedTTSPState, String>> generateSuccessors(EnhancedTTSPState node) throws InterruptedException {
                ArrayList<INewNodeDescription<EnhancedTTSPState, String>> l = new ArrayList<INewNodeDescription<EnhancedTTSPState, String>>();
                if (node.getCurTour().size() >= EnhancedTTSPSimpleGraphGenerator.this.problem.getPossibleDestinations().size()) {
                    EnhancedTTSPSimpleGraphGenerator.this.logger.warn("Cannot generate successors of a node in which we are in pos {} and in which have already visited everything!", (Object)node.getCurLocation());
                    return l;
                }
                ShortList possibleUntriedDestinations = EnhancedTTSPSimpleGraphGenerator.this.problem.getPossibleRemainingDestinationsInState(node);
                if (possibleUntriedDestinations.contains(node.getCurLocation())) {
                    throw new IllegalStateException("The list of possible destinations must not contain the current position " + node.getCurLocation() + ".");
                }
                int n = possibleUntriedDestinations.size();
                for (int i = 0; i < n; ++i) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException("Successor generation has been interrupted.");
                    }
                    l.add(this.generateSuccessor(node, possibleUntriedDestinations.getShort(i)));
                }
                return l;
            }

            public INewNodeDescription<EnhancedTTSPState, String> generateSuccessor(EnhancedTTSPState n, short destination) throws InterruptedException {
                return new NodeExpansionDescription<EnhancedTTSPState, String>(EnhancedTTSPSimpleGraphGenerator.this.problem.computeSuccessorState(n, destination), n.getCurLocation() + " -> " + destination);
            }

            public Iterator<INewNodeDescription<EnhancedTTSPState, String>> getIterativeGenerator(EnhancedTTSPState node) {
                ShortList availableDestinations = EnhancedTTSPSimpleGraphGenerator.this.problem.getPossibleRemainingDestinationsInState(node);
                return new MappingIterator((Iterator)availableDestinations.iterator(), s -> {
                    try {
                        return this.generateSuccessor(node, (short)s);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new UndeclaredInterruptedException(e);
                    }
                });
            }
        };
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }
}

