/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.enhancedttsp;

import ai.libs.jaicore.problems.enhancedttsp.AEnhancedTTSPBinaryTelescopeNode;
import ai.libs.jaicore.problems.enhancedttsp.EnhancedTTSP;
import ai.libs.jaicore.problems.enhancedttsp.EnhancedTTSPState;
import ai.libs.jaicore.search.model.NodeExpansionDescription;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.api4.java.datastructure.graph.implicit.INewNodeDescription;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedTTSPTelescopeGraphGenerator
implements IGraphGenerator<AEnhancedTTSPBinaryTelescopeNode, String>,
ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(EnhancedTTSPTelescopeGraphGenerator.class);
    private final EnhancedTTSP problem;

    public EnhancedTTSPTelescopeGraphGenerator(EnhancedTTSP problem) {
        this.problem = problem;
        this.logMode();
    }

    private void logMode() {
        this.logger.info("Initialized {} with {} locations: {}", new Object[]{this.getClass().getSimpleName(), this.problem.getPossibleDestinations().size(), this.problem.getPossibleDestinations()});
    }

    public ISingleRootGenerator<AEnhancedTTSPBinaryTelescopeNode> getRootGenerator() {
        return () -> new AEnhancedTTSPBinaryTelescopeNode.EnhancedTTSPBinaryTelescopeDeterminedDestinationNode(null, this.problem.getInitalState());
    }

    public ISuccessorGenerator<AEnhancedTTSPBinaryTelescopeNode, String> getSuccessorGenerator() {
        return new ISuccessorGenerator<AEnhancedTTSPBinaryTelescopeNode, String>(){

            public List<INewNodeDescription<AEnhancedTTSPBinaryTelescopeNode, String>> generateSuccessors(AEnhancedTTSPBinaryTelescopeNode node) throws InterruptedException {
                AEnhancedTTSPBinaryTelescopeNode.EnhancedTTSPBinaryTelescopeDestinationDecisionNode rightChild;
                AEnhancedTTSPBinaryTelescopeNode.EnhancedTTSPBinaryTelescopeDestinationDecisionNode leftChild;
                ArrayList<Boolean> bitSetForRightChild;
                ArrayList<Boolean> bitSetForLeftChild;
                long start = System.currentTimeMillis();
                EnhancedTTSPTelescopeGraphGenerator.this.logger.info("Computing successors of node {}", (Object)node);
                ArrayList<INewNodeDescription<AEnhancedTTSPBinaryTelescopeNode, String>> l = new ArrayList<INewNodeDescription<AEnhancedTTSPBinaryTelescopeNode, String>>();
                if (node.getCurTour().size() >= EnhancedTTSPTelescopeGraphGenerator.this.problem.getPossibleDestinations().size()) {
                    EnhancedTTSPTelescopeGraphGenerator.this.logger.info("Cannot generate successors of a node in which we are in pos {} and in which have already visited everything!", (Object)node.getCurLocation());
                    return l;
                }
                ShortList remainingTargets = EnhancedTTSPTelescopeGraphGenerator.this.problem.getPossibleRemainingDestinationsInState(node.getState());
                EnhancedTTSPTelescopeGraphGenerator.this.logger.debug("Remaining targets: {}", (Object)remainingTargets);
                short numberOfRemainingTargets = (short)remainingTargets.size();
                short minDepth = (short)Math.floor(FastMath.log((double)2.0, (double)numberOfRemainingTargets));
                int numberOfNodesOnMinDepthPlus1 = (numberOfRemainingTargets - (int)Math.pow(2.0, minDepth)) * 2;
                if (node instanceof AEnhancedTTSPBinaryTelescopeNode.EnhancedTTSPBinaryTelescopeDestinationDecisionNode) {
                    AEnhancedTTSPBinaryTelescopeNode.EnhancedTTSPBinaryTelescopeDestinationDecisionNode cNode = (AEnhancedTTSPBinaryTelescopeNode.EnhancedTTSPBinaryTelescopeDestinationDecisionNode)node;
                    bitSetForLeftChild = new ArrayList<Boolean>(cNode.getField());
                    bitSetForRightChild = new ArrayList(cNode.getField());
                    EnhancedTTSPTelescopeGraphGenerator.this.logger.debug("Cloning current BitVector {} into left and right.", bitSetForLeftChild);
                } else {
                    EnhancedTTSPTelescopeGraphGenerator.this.logger.debug("Creating new BitVector in this state node.");
                    bitSetForLeftChild = new ArrayList();
                    bitSetForRightChild = new ArrayList<Boolean>();
                }
                bitSetForLeftChild.add(false);
                bitSetForRightChild.add(true);
                boolean leftChildIsLeaf = false;
                boolean rightChildIsLeaf = false;
                if (bitSetForLeftChild.size() >= minDepth) {
                    if (numberOfRemainingTargets == 2 || bitSetForLeftChild.size() == minDepth + 1) {
                        leftChildIsLeaf = true;
                        rightChildIsLeaf = true;
                    } else {
                        ArrayList<Boolean> leftChildOfLeftChild = new ArrayList<Boolean>(bitSetForLeftChild);
                        leftChildOfLeftChild.add(false);
                        long indexOfThatChild = EnhancedTTSPTelescopeGraphGenerator.convert(leftChildOfLeftChild);
                        leftChildIsLeaf = indexOfThatChild >= (long)numberOfNodesOnMinDepthPlus1;
                        boolean bl = rightChildIsLeaf = leftChildIsLeaf || indexOfThatChild + 2L >= (long)numberOfNodesOnMinDepthPlus1;
                    }
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException("Successor generation has been interrupted.");
                }
                EnhancedTTSPTelescopeGraphGenerator.this.logger.debug("Children bit-vectors are {}/{}. Leaf predicates are {}/{}", new Object[]{bitSetForLeftChild, bitSetForRightChild, leftChildIsLeaf, rightChildIsLeaf});
                if (leftChildIsLeaf) {
                    short firstNextDestination = EnhancedTTSPTelescopeGraphGenerator.this.getDestinationBasedOnBitVectorAndAvailableDestinations(remainingTargets, bitSetForLeftChild);
                    EnhancedTTSPTelescopeGraphGenerator.this.logger.debug("Determined next location {} (index {}) from bitvector {} for left child.", new Object[]{firstNextDestination, EnhancedTTSPTelescopeGraphGenerator.convert(bitSetForLeftChild), bitSetForLeftChild});
                    EnhancedTTSPState successorStateForLeftChild = EnhancedTTSPTelescopeGraphGenerator.this.problem.computeSuccessorState(node.getState(), firstNextDestination);
                    if (numberOfRemainingTargets == 2) {
                        short other = remainingTargets.stream().filter(s -> s != firstNextDestination).findAny().get();
                        successorStateForLeftChild = EnhancedTTSPTelescopeGraphGenerator.this.problem.computeSuccessorState(successorStateForLeftChild, other);
                        successorStateForLeftChild = EnhancedTTSPTelescopeGraphGenerator.this.problem.computeSuccessorState(successorStateForLeftChild, EnhancedTTSPTelescopeGraphGenerator.this.problem.getStartLocation());
                    }
                    leftChild = new AEnhancedTTSPBinaryTelescopeNode.EnhancedTTSPBinaryTelescopeDeterminedDestinationNode(node, successorStateForLeftChild);
                } else {
                    leftChild = new AEnhancedTTSPBinaryTelescopeNode.EnhancedTTSPBinaryTelescopeDestinationDecisionNode(node, false);
                }
                if (rightChildIsLeaf) {
                    short firstNextDestination = EnhancedTTSPTelescopeGraphGenerator.this.getDestinationBasedOnBitVectorAndAvailableDestinations(remainingTargets, bitSetForRightChild);
                    EnhancedTTSPTelescopeGraphGenerator.this.logger.debug("Determined next location {} (index {}) from bitvector {} for right child.", new Object[]{firstNextDestination, EnhancedTTSPTelescopeGraphGenerator.convert(bitSetForRightChild), bitSetForRightChild});
                    EnhancedTTSPState successorStateForRightChild = EnhancedTTSPTelescopeGraphGenerator.this.problem.computeSuccessorState(node.getState(), firstNextDestination);
                    if (numberOfRemainingTargets == 2) {
                        short other = remainingTargets.stream().filter(s -> s != firstNextDestination).findAny().get();
                        successorStateForRightChild = EnhancedTTSPTelescopeGraphGenerator.this.problem.computeSuccessorState(successorStateForRightChild, other);
                        successorStateForRightChild = EnhancedTTSPTelescopeGraphGenerator.this.problem.computeSuccessorState(successorStateForRightChild, EnhancedTTSPTelescopeGraphGenerator.this.problem.getStartLocation());
                    }
                    rightChild = new AEnhancedTTSPBinaryTelescopeNode.EnhancedTTSPBinaryTelescopeDeterminedDestinationNode(node, successorStateForRightChild);
                } else {
                    rightChild = new AEnhancedTTSPBinaryTelescopeNode.EnhancedTTSPBinaryTelescopeDestinationDecisionNode(node, true);
                }
                l.add(new NodeExpansionDescription<AEnhancedTTSPBinaryTelescopeNode.EnhancedTTSPBinaryTelescopeDestinationDecisionNode, String>(leftChild, "l"));
                l.add(new NodeExpansionDescription<AEnhancedTTSPBinaryTelescopeNode.EnhancedTTSPBinaryTelescopeDestinationDecisionNode, String>(rightChild, "r"));
                long walltime = System.currentTimeMillis() - start;
                if (walltime > 10L) {
                    EnhancedTTSPTelescopeGraphGenerator.this.logger.warn("Successor generation took {}ms", (Object)walltime);
                }
                return l;
            }
        };
    }

    public short getDestinationBasedOnBitVectorAndAvailableDestinations(ShortList destinations, List<Boolean> vector) {
        short pathIndex = (short)EnhancedTTSPTelescopeGraphGenerator.convert(vector);
        short numberOfRemainingTargets = (short)destinations.size();
        short minDepth = (short)Math.floor(FastMath.log((double)2.0, (double)numberOfRemainingTargets));
        int numberOfNodesAddedOnLastLayer = numberOfRemainingTargets - (int)Math.pow(2.0, minDepth);
        short correctedPathIndex = vector.size() == minDepth + 1 ? pathIndex : (short)(pathIndex + numberOfNodesAddedOnLastLayer);
        return destinations.getShort((int)correctedPathIndex);
    }

    public static long convert(List<Boolean> bits) {
        long value = 0L;
        for (int i = 0; i < bits.size(); ++i) {
            value += bits.get(i) != false ? 1L << bits.size() - i - 1 : 0L;
        }
        return value;
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.logMode();
    }
}

