/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.gridworld;

import ai.libs.jaicore.problems.gridworld.GridWorldNode;
import ai.libs.jaicore.problems.gridworld.GridWorldProblem;
import ai.libs.jaicore.search.model.NodeExpansionDescription;
import java.util.ArrayList;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.api4.java.datastructure.graph.implicit.IRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;

public class GridWorldBasicGraphGenerator
implements IGraphGenerator<GridWorldNode, String> {
    private final GridWorldProblem problem;

    public GridWorldBasicGraphGenerator(GridWorldProblem problem) {
        this.problem = problem;
    }

    public IRootGenerator<GridWorldNode> getRootGenerator() {
        return new ISingleRootGenerator<GridWorldNode>(){

            public GridWorldNode getRoot() {
                return new GridWorldNode(GridWorldBasicGraphGenerator.this.problem, GridWorldBasicGraphGenerator.this.problem.getStartX(), GridWorldBasicGraphGenerator.this.problem.getStartY());
            }
        };
    }

    public ISuccessorGenerator<GridWorldNode, String> getSuccessorGenerator() {
        return node -> {
            ArrayList<NodeExpansionDescription<GridWorldNode, String>> succ = new ArrayList<NodeExpansionDescription<GridWorldNode, String>>();
            for (int a = 4; a <= 9; ++a) {
                int dx = 1;
                if (a == 2 || a == 7) {
                    dx = 0;
                }
                if (a == 1 || a == 4 || a == 6) {
                    dx = -1;
                }
                int dy = 1;
                if (a == 4 || a == 5) {
                    dy = 0;
                }
                if (a == 1 || a == 2 || a == 3) {
                    dy = -1;
                }
                int newPosX = node.getX() + dx;
                int newPosY = node.getY() + dy;
                if (newPosX >= this.problem.getGrid().length || newPosY >= this.problem.getGrid()[0].length) continue;
                succ.add(new NodeExpansionDescription<GridWorldNode, String>(new GridWorldNode(this.problem, newPosX, newPosY), Integer.toString(a)));
            }
            return succ;
        };
    }
}

