/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.knapsack;

import ai.libs.jaicore.basic.MappingIterator;
import ai.libs.jaicore.problems.knapsack.KnapsackConfiguration;
import ai.libs.jaicore.problems.knapsack.KnapsackProblem;
import ai.libs.jaicore.search.model.NodeExpansionDescription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.api4.java.datastructure.graph.implicit.ILazySuccessorGenerator;
import org.api4.java.datastructure.graph.implicit.INewNodeDescription;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnapsackProblemGraphGenerator
implements IGraphGenerator<KnapsackConfiguration, String>,
ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(KnapsackProblemGraphGenerator.class);
    private final KnapsackProblem problem;

    public KnapsackProblemGraphGenerator(KnapsackProblem problem) {
        this.problem = problem;
    }

    public ISingleRootGenerator<KnapsackConfiguration> getRootGenerator() {
        return () -> new KnapsackConfiguration(new HashSet(), this.problem.getObjects(), 0.0);
    }

    public ISuccessorGenerator<KnapsackConfiguration, String> getSuccessorGenerator() {
        return new KnapsackSuccessorGenerator();
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Switched logger name to {}", (Object)name);
    }

    class KnapsackSuccessorGenerator
    implements ILazySuccessorGenerator<KnapsackConfiguration, String> {
        private Map<KnapsackConfiguration, Set<Integer>> expandedChildren = new HashMap<KnapsackConfiguration, Set<Integer>>();

        KnapsackSuccessorGenerator() {
        }

        private List<String> getPossiblePackingObjects(KnapsackConfiguration n) {
            ArrayList<String> possibleObjects = new ArrayList<String>();
            Optional objectWithHighestName = n.getPackedObjects().stream().max((o1, o2) -> o1.compareTo((String)o2));
            for (String object : n.getRemainingObjects()) {
                if (objectWithHighestName.isPresent() && ((String)objectWithHighestName.get()).compareTo(object) > 0 || !(n.getUsedCapacity() + (Double)KnapsackProblemGraphGenerator.this.problem.getWeights().get(object) <= KnapsackProblemGraphGenerator.this.problem.getKnapsackCapacity())) continue;
                possibleObjects.add(object);
            }
            return possibleObjects;
        }

        public List<INewNodeDescription<KnapsackConfiguration, String>> generateSuccessors(KnapsackConfiguration node) throws InterruptedException {
            ArrayList<INewNodeDescription<KnapsackConfiguration, String>> l = new ArrayList<INewNodeDescription<KnapsackConfiguration, String>>();
            List<String> possibleDestinations = this.getPossiblePackingObjects(node);
            int n = possibleDestinations.size();
            Thread.sleep(1L);
            long lastSleep = System.currentTimeMillis();
            for (int i = 0; i < n; ++i) {
                if (System.currentTimeMillis() - lastSleep > 10L) {
                    if (Thread.interrupted()) {
                        KnapsackProblemGraphGenerator.this.logger.info("Successor generation has been interrupted.");
                        throw new InterruptedException("Successor generation interrupted");
                    }
                    Thread.sleep(1L);
                    lastSleep = System.currentTimeMillis();
                    KnapsackProblemGraphGenerator.this.logger.info("Sleeping");
                }
                l.add(this.generateSuccessor(node, possibleDestinations, i));
            }
            return l;
        }

        public INewNodeDescription<KnapsackConfiguration, String> generateSuccessor(KnapsackConfiguration node, List<String> objetcs, int i) {
            int n;
            KnapsackProblemGraphGenerator.this.logger.debug("Generating successor #{} of {}", (Object)i, (Object)node);
            if (!this.expandedChildren.containsKey(node)) {
                this.expandedChildren.put(node, new HashSet());
            }
            if ((n = objetcs.size()) == 0) {
                KnapsackProblemGraphGenerator.this.logger.debug("No objects left, quitting.");
                return null;
            }
            int j = i % n;
            this.expandedChildren.get(node).add(j);
            String object = objetcs.get(j);
            KnapsackProblemGraphGenerator.this.logger.trace("Creating set of remaining objects when choosing {}.", (Object)object);
            HashSet<String> packedObjects = new HashSet<String>();
            HashSet<String> remainingObjects = new HashSet<String>();
            boolean foundRemoved = false;
            for (String item : node.getRemainingObjects()) {
                if (!foundRemoved && item.equals(object)) {
                    foundRemoved = true;
                    packedObjects.add(item);
                    continue;
                }
                remainingObjects.add(item);
            }
            packedObjects.addAll(node.getPackedObjects());
            KnapsackProblemGraphGenerator.this.logger.trace("Ready.");
            double usedCapacity = node.getUsedCapacity() + (Double)KnapsackProblemGraphGenerator.this.problem.getWeights().get(object);
            KnapsackConfiguration newNode = new KnapsackConfiguration(packedObjects, remainingObjects, usedCapacity);
            return new NodeExpansionDescription<KnapsackConfiguration, String>(newNode, "(" + node.getPackedObjects() + ", " + object + ")");
        }

        public Iterator<INewNodeDescription<KnapsackConfiguration, String>> getIterativeGenerator(KnapsackConfiguration node) {
            List<String> possibleObjects = this.getPossiblePackingObjects(node);
            return new MappingIterator((Iterator)IntStream.range(0, possibleObjects.size()).iterator(), i -> this.generateSuccessor(node, possibleObjects, (int)i));
        }
    }
}

