/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.knapsack;

import ai.libs.jaicore.basic.algorithm.reduction.AlgorithmicProblemReduction;
import ai.libs.jaicore.problems.knapsack.KnapsackConfiguration;
import ai.libs.jaicore.problems.knapsack.KnapsackProblem;
import ai.libs.jaicore.search.exampleproblems.knapsack.KnapsackProblemGraphGenerator;
import ai.libs.jaicore.search.model.other.SearchGraphPath;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithSubpathEvaluationsInput;
import java.util.Set;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.INodeGoalTester;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.IPathGoalTester;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.PathEvaluationException;
import org.api4.java.common.attributedobjects.ObjectEvaluationFailedException;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;

public class KnapsackToGraphSearchReducer
implements AlgorithmicProblemReduction<KnapsackProblem, Set<String>, GraphSearchWithSubpathEvaluationsInput<KnapsackConfiguration, String, Double>, SearchGraphPath<KnapsackConfiguration, String>> {
    public GraphSearchWithSubpathEvaluationsInput<KnapsackConfiguration, String, Double> encodeProblem(final KnapsackProblem problem) {
        return new GraphSearchWithSubpathEvaluationsInput<KnapsackConfiguration, String, Double>((IGraphGenerator<KnapsackConfiguration, String>)new KnapsackProblemGraphGenerator(problem), (IPathGoalTester<KnapsackConfiguration, String>)new INodeGoalTester<KnapsackConfiguration, String>(){

            public boolean isGoal(KnapsackConfiguration n) {
                for (String object : n.getRemainingObjects()) {
                    if (!(n.getUsedCapacity() + (Double)problem.getWeights().get(object) <= problem.getKnapsackCapacity())) continue;
                    return false;
                }
                return true;
            }
        }, new IPathEvaluator<KnapsackConfiguration, String, Double>(){

            public Double evaluate(ILabeledPath<KnapsackConfiguration, String> path) throws PathEvaluationException, InterruptedException {
                try {
                    return (Double)problem.getSolutionEvaluator().evaluate((Object)((KnapsackConfiguration)path.getHead()));
                }
                catch (ObjectEvaluationFailedException e) {
                    throw new PathEvaluationException("Could not evaluate node due to an algorithm exception: " + e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public Set<String> decodeSolution(SearchGraphPath<KnapsackConfiguration, String> solution) {
        return solution.getNodes().get(solution.getNodes().size() - 1).getPackedObjects();
    }
}

