/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.lake;

import ai.libs.jaicore.search.algorithms.mdp.mcts.ActionPredictionFailedException;
import ai.libs.jaicore.search.algorithms.mdp.mcts.IPolicy;
import ai.libs.jaicore.search.exampleproblems.lake.ELakeActions;
import ai.libs.jaicore.search.exampleproblems.lake.LakeLayout;
import ai.libs.jaicore.search.exampleproblems.lake.LakeState;
import ai.libs.jaicore.search.exampleproblems.lake.TimedLakeState;
import ai.libs.jaicore.search.probleminputs.AMDP;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class LakeMDP
extends AMDP<TimedLakeState, ELakeActions, Double> {
    private static final Collection<ELakeActions> POSSIBLE_ACTIONS = Arrays.asList(ELakeActions.values());
    private final LakeLayout layout;
    private final int goalRow;
    private final int goalCol;
    private final int timeout;
    private final boolean timed;
    private boolean infinite;
    private double rewardGoal = 1.0;
    private double rewardPit = 0.0;
    private double rewardOrdinary = 0.0;

    public LakeMDP(LakeLayout layout, int startRow, int startCol, int goalRow, int goalCol, int timeout) {
        super(new TimedLakeState(layout, startRow, startCol, 0));
        this.layout = layout;
        this.goalRow = goalRow;
        this.goalCol = goalCol;
        this.timeout = timeout;
        this.timed = timeout > 0;
    }

    @Override
    public Collection<ELakeActions> getApplicableActions(TimedLakeState state) {
        if (!this.infinite && this.timed && state.getTime() >= this.timeout || state.isInPit() || this.isGoalState(state)) {
            return Arrays.asList(new ELakeActions[0]);
        }
        return POSSIBLE_ACTIONS;
    }

    @Override
    public Map<TimedLakeState, Double> getProb(TimedLakeState state, ELakeActions action) {
        HashMap<TimedLakeState, Double> dist = new HashMap<TimedLakeState, Double>();
        ArrayList<TimedLakeState> possibleOutcomes = new ArrayList<TimedLakeState>(3);
        switch (action) {
            case UP: {
                possibleOutcomes.add(this.left(state));
                possibleOutcomes.add(this.up(state));
                possibleOutcomes.add(this.right(state));
                break;
            }
            case RIGHT: {
                possibleOutcomes.add(this.up(state));
                possibleOutcomes.add(this.right(state));
                possibleOutcomes.add(this.down(state));
                break;
            }
            case DOWN: {
                possibleOutcomes.add(this.left(state));
                possibleOutcomes.add(this.down(state));
                possibleOutcomes.add(this.right(state));
                break;
            }
            case LEFT: {
                possibleOutcomes.add(this.left(state));
                possibleOutcomes.add(this.up(state));
                possibleOutcomes.add(this.down(state));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown action " + (Object)((Object)action));
            }
        }
        for (TimedLakeState succ : possibleOutcomes) {
            dist.put(succ, dist.computeIfAbsent(succ, s -> 0.0) + 0.3333333333333333);
        }
        return dist;
    }

    public boolean isGoalState(LakeState s) {
        return s.getRow() == this.goalRow && s.getCol() == this.goalCol;
    }

    public TimedLakeState up(TimedLakeState s) {
        return new TimedLakeState(s.getLayout(), Math.max(0, s.getRow() - 1), s.getCol(), this.timed ? s.getTime() + 1 : s.getTime());
    }

    public TimedLakeState down(TimedLakeState s) {
        return new TimedLakeState(s.getLayout(), Math.min(this.layout.getRows() - 1, s.getRow() + 1), s.getCol(), this.timed ? s.getTime() + 1 : s.getTime());
    }

    public TimedLakeState left(TimedLakeState s) {
        return new TimedLakeState(s.getLayout(), s.getRow(), Math.max(0, s.getCol() - 1), this.timed ? s.getTime() + 1 : s.getTime());
    }

    public TimedLakeState right(TimedLakeState s) {
        return new TimedLakeState(s.getLayout(), s.getRow(), Math.min(this.layout.getCols() - 1, s.getCol() + 1), this.timed ? s.getTime() + 1 : s.getTime());
    }

    @Override
    public Double getScore(TimedLakeState state, ELakeActions action, TimedLakeState successor) {
        if (this.timed) {
            return successor.isInPit() ? 1.0 - (double)state.getTime() * 1.0 / (double)this.timeout : 1.0 / (double)this.timeout;
        }
        if (this.isGoalState(successor)) {
            return this.rewardGoal;
        }
        return successor.isInPit() ? this.rewardPit : this.rewardOrdinary;
    }

    public double getRewardGoal() {
        return this.rewardGoal;
    }

    public void setRewardGoal(double rewardGoal) {
        this.rewardGoal = rewardGoal;
    }

    public double getRewardPit() {
        return this.rewardPit;
    }

    public void setRewardPit(double rewardPit) {
        this.rewardPit = rewardPit;
    }

    public double getRewardOrdinary() {
        return this.rewardOrdinary;
    }

    public void setRewardOrdinary(double rewardOrdinary) {
        this.rewardOrdinary = rewardOrdinary;
    }

    @Override
    public boolean isMaximizing() {
        return !this.timed;
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public void setInfinite(boolean infinite) {
        this.infinite = infinite;
    }

    public String getStringVisualizationOfPolicy(IPolicy<TimedLakeState, ELakeActions> policy) {
        StringBuilder sb = new StringBuilder();
        int cols = this.layout.getCols();
        int rows = this.layout.getRows();
        for (int r = 0; r < rows; ++r) {
            int c;
            for (c = 0; c < cols; ++c) {
                sb.append("+-");
            }
            sb.append("+\n");
            for (c = 0; c < cols; ++c) {
                sb.append("|");
                TimedLakeState state = new TimedLakeState(this.layout, r, c, 0);
                try {
                    ELakeActions action = policy.getAction(state, this.getApplicableActions(state));
                    sb.append(action != null ? action.toString().substring(0, 1) : "/");
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (ActionPredictionFailedException e) {
                    sb.append("EXCEPTION");
                }
            }
            sb.append("+\n");
        }
        return sb.toString();
    }
}

