/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.lake;

import ai.libs.jaicore.search.exampleproblems.lake.LakeLayout;

public class LakeState {
    private final LakeLayout layout;
    private final int row;
    private final int col;

    public LakeState(LakeLayout layout, int row, int col) {
        this.layout = layout;
        this.row = row;
        this.col = col;
    }

    public LakeLayout getLayout() {
        return this.layout;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public boolean isInPit() {
        return this.layout.getPits()[this.row][this.col];
    }

    public String getStringVisualization() {
        StringBuilder sb = new StringBuilder();
        int cols = this.layout.getCols();
        int rows = this.layout.getRows();
        for (int r = 0; r < rows; ++r) {
            int c;
            for (c = 0; c < cols; ++c) {
                sb.append("+-");
            }
            sb.append("+\n");
            for (c = 0; c < cols; ++c) {
                sb.append("|");
                if (c == this.col && r == this.row) {
                    sb.append("x");
                    continue;
                }
                if (this.layout.getPits()[r][c]) {
                    sb.append("*");
                    continue;
                }
                sb.append(" ");
            }
            sb.append("+\n");
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.col;
        result = 31 * result + (this.layout == null ? 0 : this.layout.hashCode());
        result = 31 * result + this.row;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LakeState other = (LakeState)obj;
        if (this.col != other.col) {
            return false;
        }
        if (this.layout == null ? other.layout != null : !this.layout.equals(other.layout)) {
            return false;
        }
        return this.row == other.row;
    }

    public String toString() {
        return this.row + "/" + this.col;
    }
}

