/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.npuzzle.parentdiscarding;

import ai.libs.jaicore.search.exampleproblems.npuzzle.parentdiscarding.PDPuzzleNode;
import ai.libs.jaicore.search.model.NodeExpansionDescription;
import java.util.ArrayList;
import java.util.Arrays;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;

public class PDPuzzleGenerator
implements IGraphGenerator<PDPuzzleNode, String> {
    protected int dimension;
    private PDPuzzleNode root;

    public PDPuzzleGenerator(int[][] board, int emptyX, int emptyY) {
        this.dimension = board.length;
        this.root = new PDPuzzleNode(board, emptyX, emptyY);
    }

    public ISingleRootGenerator<PDPuzzleNode> getRootGenerator() {
        return () -> this.root;
    }

    public ISuccessorGenerator<PDPuzzleNode, String> getSuccessorGenerator() {
        return n -> {
            ArrayList<NodeExpansionDescription<PDPuzzleNode, String>> successors = new ArrayList<NodeExpansionDescription<PDPuzzleNode, String>>();
            if (n.getEmptyX() > 0) {
                successors.add(new NodeExpansionDescription<PDPuzzleNode, String>(this.move((PDPuzzleNode)((Object)n), "l"), "l"));
            }
            if (n.getEmptyX() < this.dimension - 1) {
                successors.add(new NodeExpansionDescription<PDPuzzleNode, String>(this.move((PDPuzzleNode)((Object)n), "r"), "r"));
            }
            if (n.getEmptyY() > 0) {
                successors.add(new NodeExpansionDescription<PDPuzzleNode, String>(this.move((PDPuzzleNode)((Object)n), "u"), "u"));
            }
            if (n.getEmptyY() < this.dimension - 1) {
                successors.add(new NodeExpansionDescription<PDPuzzleNode, String>(this.move((PDPuzzleNode)((Object)n), "d"), "d"));
            }
            return successors;
        };
    }

    public PDPuzzleNode move(PDPuzzleNode n, String move) {
        switch (move) {
            case "l": {
                return this.move(n, 0, -1);
            }
            case "r": {
                return this.move(n, 0, 1);
            }
            case "d": {
                return this.move(n, 1, 0);
            }
            case "u": {
                return this.move(n, -1, 0);
            }
        }
        throw new IllegalArgumentException(move + " is not a valid move. Valid moves: {l, r, d, u}");
    }

    public PDPuzzleNode move(PDPuzzleNode n, int y, int x) {
        if (x == y || Math.abs(x) > 1 || Math.abs(y) > 1) {
            return null;
        }
        int[][] b = new int[this.dimension][this.dimension];
        int[][] board = n.getBoard();
        for (int i = 0; i < this.dimension; ++i) {
            b[i] = Arrays.copyOf(board[i], board[i].length);
        }
        int eX = n.getEmptyX();
        int eY = n.getEmptyY();
        b[eY][eX] = b[eY + y][eX + x];
        b[eY + y][eX + x] = 0;
        return new PDPuzzleNode(b, eX + x, eY + y);
    }
}

