/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.npuzzle.standard;

import ai.libs.jaicore.problems.npuzzle.NPuzzleState;
import ai.libs.jaicore.search.model.NodeExpansionDescription;
import java.util.ArrayList;
import java.util.Arrays;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;

public class NPuzzleGraphGenerator
implements IGraphGenerator<NPuzzleState, String> {
    protected int dimension;
    private NPuzzleState root;

    public NPuzzleGraphGenerator(int[][] board) {
        this.dimension = board.length;
        int emptyX = 0;
        int emptyY = 0;
        block0: for (int x = 0; x < board.length; ++x) {
            for (int y = 0; y < board[x].length; ++y) {
                if (board[x][y] != 0) continue;
                emptyX = x;
                emptyY = y;
                continue block0;
            }
        }
        this.root = new NPuzzleState(board, emptyX, emptyY);
    }

    public ISingleRootGenerator<NPuzzleState> getRootGenerator() {
        return () -> this.root;
    }

    public ISuccessorGenerator<NPuzzleState, String> getSuccessorGenerator() {
        return n -> {
            ArrayList<NodeExpansionDescription<NPuzzleState, String>> successors = new ArrayList<NodeExpansionDescription<NPuzzleState, String>>();
            if (n.getEmptyX() > 0) {
                successors.add(new NodeExpansionDescription<NPuzzleState, String>(this.move((NPuzzleState)n, "l"), "l"));
            }
            if (n.getEmptyX() < this.dimension - 1) {
                successors.add(new NodeExpansionDescription<NPuzzleState, String>(this.move((NPuzzleState)n, "r"), "r"));
            }
            if (n.getEmptyY() > 0) {
                successors.add(new NodeExpansionDescription<NPuzzleState, String>(this.move((NPuzzleState)n, "u"), "u"));
            }
            if (n.getEmptyY() < this.dimension - 1) {
                successors.add(new NodeExpansionDescription<NPuzzleState, String>(this.move((NPuzzleState)n, "d"), "d"));
            }
            return successors;
        };
    }

    public NPuzzleState move(NPuzzleState n, String move) {
        switch (move) {
            case "l": {
                return this.move(n, 0, -1);
            }
            case "r": {
                return this.move(n, 0, 1);
            }
            case "d": {
                return this.move(n, 1, 0);
            }
            case "u": {
                return this.move(n, -1, 0);
            }
        }
        throw new IllegalArgumentException(move + " is not a valid move. Valid moves: {l, r, d, u}");
    }

    public NPuzzleState move(NPuzzleState n, int y, int x) {
        if (x == y || Math.abs(x) > 1 || Math.abs(y) > 1) {
            return null;
        }
        int[][] b = new int[this.dimension][this.dimension];
        int[][] board = n.getBoard();
        for (int i = 0; i < this.dimension; ++i) {
            b[i] = Arrays.copyOf(board[i], board[i].length);
        }
        int eX = n.getEmptyX();
        int eY = n.getEmptyY();
        b[eY][eX] = b[eY + y][eX + x];
        b[eY + y][eX + x] = 0;
        return new NPuzzleState(b, eX + x, eY + y);
    }
}

