/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.nqueens;

import ai.libs.jaicore.search.exampleproblems.nqueens.QueenNode;
import ai.libs.jaicore.search.model.NodeExpansionDescription;
import java.util.ArrayList;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;

public class NQueensGraphGenerator
implements IGraphGenerator<QueenNode, String> {
    private final int dimension;
    private int countSinceLastSleep = 0;

    public NQueensGraphGenerator(int dimension) {
        this.dimension = dimension;
    }

    public ISingleRootGenerator<QueenNode> getRootGenerator() {
        return () -> new QueenNode(this.dimension);
    }

    public ISuccessorGenerator<QueenNode, String> getSuccessorGenerator() {
        return n -> {
            ArrayList<NodeExpansionDescription<QueenNode, String>> l = new ArrayList<NodeExpansionDescription<QueenNode, String>>();
            int currentRow = n.getPositions().size();
            int i = 0;
            while (i < this.dimension) {
                if (this.countSinceLastSleep % 100 == 0) {
                    Thread.sleep(5L);
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException("Successor generation has been interrupted.");
                }
                if (!n.attack(currentRow, i)) {
                    l.add(new NodeExpansionDescription<QueenNode, String>(new QueenNode((QueenNode)n, i), "" + i));
                }
                ++i;
                ++this.countSinceLastSleep;
            }
            return l;
        };
    }
}

