/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.nqueens;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class QueenNode
implements Serializable {
    private final int dimension;
    private final List<Integer> positions;

    public QueenNode(int dimension) {
        this.positions = new ArrayList<Integer>();
        this.dimension = dimension;
    }

    public QueenNode(int x, int y, int dimension) {
        this.positions = new ArrayList<Integer>();
        this.positions.add(x, y);
        this.dimension = dimension;
    }

    public QueenNode(List<Integer> pos, int y, int dimension) {
        this.positions = new ArrayList<Integer>(pos);
        this.positions.add(this.positions.size(), y);
        this.dimension = dimension;
    }

    public QueenNode(List<Integer> pos, int x, int y, int dimension) {
        this.positions = new ArrayList<Integer>(pos);
        for (Integer p : pos) {
            this.positions.add(p);
        }
        this.positions.add(x, y);
        this.dimension = dimension;
    }

    public QueenNode(QueenNode n, int y) {
        this.positions = new ArrayList<Integer>(n.getPositions().size());
        for (Integer p : n.getPositions()) {
            this.positions.add(p);
        }
        this.positions.add(y);
        this.dimension = n.getDimension();
    }

    public List<Integer> getPositions() {
        return this.positions;
    }

    public int getDimension() {
        return this.dimension;
    }

    public String toString() {
        return this.positions.toString();
    }

    public String boardVisualizationAsString() {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.dimension; ++i) {
            sb.append("----");
        }
        sb.append("\n|");
        for (i = 0; i < this.dimension; ++i) {
            int j;
            for (j = 0; j < this.dimension; ++j) {
                if (this.positions.size() > i && this.positions.get(i) == j) {
                    sb.append(" Q |");
                    continue;
                }
                sb.append("   |");
            }
            sb.append("\n");
            for (j = 0; j < this.dimension; ++j) {
                sb.append("----");
            }
            if (i >= this.dimension - 1) continue;
            sb.append("\n|");
        }
        return sb.toString();
    }

    public boolean attack(int i, int j) {
        for (Integer p : this.positions) {
            if (j == p) {
                return true;
            }
            int x = Math.abs(i - this.positions.indexOf(p));
            if (j != p + x && p - x != j) continue;
            return true;
        }
        return false;
    }

    public String toStringAttack() {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.dimension; ++i) {
            sb.append("----");
        }
        sb.append("\n|");
        for (i = 0; i < this.dimension; ++i) {
            int j;
            for (j = 0; j < this.dimension; ++j) {
                if (this.positions.get(i) == j) {
                    sb.append(" Q |");
                    continue;
                }
                boolean attack = this.attack(i, j);
                if (attack) {
                    sb.append(" O |");
                    continue;
                }
                sb.append("   |");
            }
            sb.append("\n");
            for (j = 0; j < this.dimension; ++j) {
                sb.append("----");
            }
            if (i >= this.dimension - 1) continue;
            sb.append("\n|");
        }
        return sb.toString();
    }

    public int getNumberOfQueens() {
        return this.positions.size();
    }

    public int getNumberOfAttackedCells() {
        int attackedCells = this.positions.size() * this.dimension;
        for (int i = this.positions.size(); i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                if (!this.attack(i, j)) continue;
                ++attackedCells;
            }
        }
        return attackedCells;
    }

    public int getNumberOfAttackedCellsInNextRow() throws InterruptedException {
        int attackedCells = 0;
        for (int i = 0; i < this.dimension; ++i) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (!this.attack(this.dimension - 1, i)) continue;
            ++attackedCells;
        }
        return attackedCells;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimension;
        result = 31 * result + (this.positions == null ? 0 : this.positions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueenNode other = (QueenNode)obj;
        if (this.dimension != other.dimension) {
            return false;
        }
        return !(this.positions == null ? other.positions != null : !this.positions.equals(other.positions));
    }

    public int getNumberOfNotAttackedCells() {
        return this.dimension * this.dimension - this.getNumberOfAttackedCells();
    }
}

