/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.openshop;

import ai.libs.jaicore.problems.scheduling.JobSchedulingProblemInput;
import ai.libs.jaicore.problems.scheduling.Machine;
import ai.libs.jaicore.problems.scheduling.Operation;
import ai.libs.jaicore.search.exampleproblems.openshop.OpenShopMachineSelectionState;
import ai.libs.jaicore.search.exampleproblems.openshop.OpenShopOperationSelectionState;
import ai.libs.jaicore.search.exampleproblems.openshop.OpenShopState;
import ai.libs.jaicore.search.model.NodeExpansionDescription;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;

public class OpenShopGraphGenerator
implements IGraphGenerator<OpenShopState, String> {
    private final JobSchedulingProblemInput problem;
    private final boolean pruneInactiveNodes;

    public OpenShopGraphGenerator(JobSchedulingProblemInput problem) {
        this(problem, false);
    }

    public OpenShopGraphGenerator(JobSchedulingProblemInput problem, boolean pruneInactiveNodes) {
        this.problem = problem;
        this.pruneInactiveNodes = pruneInactiveNodes;
    }

    public ISingleRootGenerator<OpenShopState> getRootGenerator() {
        return () -> new OpenShopOperationSelectionState(this.problem, null, null, this.problem.getOperations().stream().map(Operation::getName).collect(Collectors.toList()));
    }

    public ISuccessorGenerator<OpenShopState, String> getSuccessorGenerator() {
        return n -> {
            ArrayList<NodeExpansionDescription<OpenShopState, String>> succ = new ArrayList<NodeExpansionDescription<OpenShopState, String>>();
            if (n instanceof OpenShopOperationSelectionState) {
                for (String opName : ((OpenShopOperationSelectionState)n).getUnselectedOperations()) {
                    OpenShopMachineSelectionState successor = new OpenShopMachineSelectionState(this.problem, (OpenShopOperationSelectionState)n, this.problem.getOperation(opName));
                    if (this.pruneInactiveNodes && !successor.getSchedule().isActive()) continue;
                    succ.add(new NodeExpansionDescription<OpenShopMachineSelectionState, String>(successor, opName));
                }
            } else if (n instanceof OpenShopMachineSelectionState) {
                List possibleMachines = ((OpenShopMachineSelectionState)n).getOperationSelectedInParent().getWorkcenter().getMachines();
                for (Machine m : possibleMachines) {
                    String removeOp;
                    ArrayList<String> possibleOps = new ArrayList<String>(((OpenShopMachineSelectionState)n).getParent().getUnselectedOperations());
                    boolean removed = possibleOps.remove(removeOp = ((OpenShopMachineSelectionState)n).getOperationSelectedInParent().getName());
                    if (!removed) {
                        throw new IllegalStateException("Agenda has not been reduced. Operation that was supposed to be removed: " + removeOp);
                    }
                    OpenShopOperationSelectionState successor = new OpenShopOperationSelectionState(this.problem, (OpenShopMachineSelectionState)n, m, possibleOps);
                    if (this.pruneInactiveNodes && !successor.getSchedule().isActive()) continue;
                    succ.add(new NodeExpansionDescription<OpenShopOperationSelectionState, String>(successor, m.getMachineID()));
                }
            } else {
                throw new IllegalArgumentException("Unsupported type " + n);
            }
            return succ;
        };
    }
}

