/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.openshop;

import ai.libs.jaicore.problems.scheduling.ISchedule;
import ai.libs.jaicore.problems.scheduling.JobSchedulingProblemInput;
import ai.libs.jaicore.problems.scheduling.Operation;
import ai.libs.jaicore.problems.scheduling.Schedule;
import ai.libs.jaicore.search.exampleproblems.openshop.OpenShopGoalPredicate;
import ai.libs.jaicore.search.exampleproblems.openshop.OpenShopGraphGenerator;
import ai.libs.jaicore.search.exampleproblems.openshop.OpenShopState;
import org.api4.java.ai.graphsearch.problem.IPathSearchWithPathEvaluationsInput;
import org.api4.java.ai.graphsearch.problem.implicit.graphgenerator.IPathGoalTester;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;

public class OpenShopGraphSearchProblem
implements IPathSearchWithPathEvaluationsInput<OpenShopState, String, Double> {
    private final JobSchedulingProblemInput problem;
    private final OpenShopGraphGenerator gg;
    private final OpenShopGoalPredicate gp = new OpenShopGoalPredicate();

    public OpenShopGraphSearchProblem(JobSchedulingProblemInput problem) {
        this.problem = problem;
        this.gg = new OpenShopGraphGenerator(problem);
    }

    public IGraphGenerator<OpenShopState, String> getGraphGenerator() {
        return this.gg;
    }

    public IPathGoalTester<OpenShopState, String> getGoalTester() {
        return this.gp;
    }

    public IPathEvaluator<OpenShopState, String, Double> getPathEvaluator() {
        return p -> {
            Schedule s = ((OpenShopState)p.getHead()).getSchedule();
            double baseScore = this.problem.getScoreOfSchedule((ISchedule)s);
            int inActive = 0;
            for (Operation o : this.problem.getOperations()) {
                if (!s.canOperationBeScheduledEarlierWithoutAnyOtherEffect(o)) continue;
                ++inActive;
            }
            return baseScore + (double)(1000 * inActive);
        };
    }

    public JobSchedulingProblemInput getProblem() {
        return this.problem;
    }
}

