/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.racetrack;

import ai.libs.jaicore.search.exampleproblems.racetrack.RacetrackAction;
import ai.libs.jaicore.search.exampleproblems.racetrack.RacetrackState;
import ai.libs.jaicore.search.probleminputs.AMDP;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class RacetrackMDP
extends AMDP<RacetrackState, RacetrackAction, Double> {
    private final boolean[][] track;
    private final boolean[][] goal;
    private final double successRate;
    private static final List<RacetrackAction> POSSIBLE_ACTIONS = new ArrayList<RacetrackAction>();
    private final boolean stopOnCrash;
    private final List<RacetrackState> possibleInitStates;

    private static List<RacetrackState> getPossibleInitStates(boolean[][] start) {
        ArrayList<RacetrackState> validStartStates = new ArrayList<RacetrackState>();
        for (int i = 0; i < start.length; ++i) {
            for (int j = 0; j < start[i].length; ++j) {
                if (!start[i][j]) continue;
                validStartStates.add(new RacetrackState(i, j, 0, 0, false, false, false));
            }
        }
        return validStartStates;
    }

    private static RacetrackState drawInitState(boolean[][] start, Random random) {
        List<RacetrackState> validStartStates = RacetrackMDP.getPossibleInitStates(start);
        Collections.shuffle(validStartStates);
        return validStartStates.get(random.nextInt(validStartStates.size()));
    }

    public RacetrackMDP(boolean[][] track, boolean[][] start, boolean[][] goal, double successRate, Random random, boolean stopOnCrash) {
        super(RacetrackMDP.drawInitState(start, random));
        this.track = track;
        this.goal = goal;
        this.successRate = successRate;
        this.possibleInitStates = RacetrackMDP.getPossibleInitStates(start);
        this.stopOnCrash = stopOnCrash;
    }

    @Override
    public boolean isMaximizing() {
        return false;
    }

    @Override
    public Collection<RacetrackAction> getApplicableActions(RacetrackState state) {
        if (this.stopOnCrash && state.isCrashed()) {
            return new ArrayList<RacetrackAction>();
        }
        return POSSIBLE_ACTIONS;
    }

    private boolean hasMatchOnLine(boolean[][] boolmap, int xStart, int yStart, int xEnd, int yEnd) {
        int yFactor;
        if (xEnd == xStart) {
            for (int i = Math.min(yStart, yEnd); i <= Math.max(yStart, yEnd); ++i) {
                if (!boolmap[xStart][i]) continue;
                return true;
            }
            return false;
        }
        if (yEnd == yStart) {
            for (int i = Math.min(xStart, xEnd); i <= Math.max(xStart, xEnd); ++i) {
                if (!boolmap[i][yStart]) continue;
                return true;
            }
            return false;
        }
        double slope = (double)(yEnd - yStart) * 1.0 / (double)(xEnd - xStart);
        int xCur = xStart;
        int yCur = yStart;
        int xMoves = 0;
        int yMoves = 0;
        int xFactor = xEnd > xStart ? 1 : -1;
        int n = yFactor = yEnd > yStart ? 1 : -1;
        while (xCur != xEnd) {
            int expectedYMoves;
            xCur += xFactor;
            if ((expectedYMoves = Math.abs((int)Math.round((double)(++xMoves) * slope))) > yMoves) {
                while (expectedYMoves > yMoves) {
                    ++yMoves;
                    if (!boolmap[xCur][yCur += yFactor]) continue;
                    return true;
                }
                continue;
            }
            if (!boolmap[xCur][yCur]) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<RacetrackState, Double> getProb(RacetrackState state, RacetrackAction action) {
        RacetrackState crashState;
        RacetrackState succ;
        boolean finished;
        HashMap<RacetrackState, Double> out = new HashMap<RacetrackState, Double>();
        int xCur = state.getX();
        int yCur = state.getY();
        int xLazy = xCur + state.gethSpeed();
        int yLazy = yCur + state.getvSpeed();
        int xAcc = xLazy += action.gethAcceleration();
        int yAcc = yLazy += action.getvAcceleration();
        if (xLazy >= 0 && xLazy < this.track.length && yLazy >= 0 && yLazy < this.track[xLazy].length && this.track[xLazy][yLazy]) {
            finished = this.hasMatchOnLine(this.goal, xCur, yCur, xLazy, yLazy);
            succ = new RacetrackState(xLazy, yLazy, state.gethSpeed(), state.getvSpeed(), false, finished, false);
            out.put(succ, 1.0 - this.successRate);
        } else {
            double prob = (1.0 - this.successRate) * 1.0 / (double)this.possibleInitStates.size();
            for (RacetrackState initState : this.possibleInitStates) {
                crashState = new RacetrackState(initState.getX(), initState.getY(), 0, 0, false, false, true);
                out.put(crashState, prob);
            }
        }
        if (xAcc >= 0 && xAcc < this.track.length && yAcc >= 0 && yAcc < this.track[xAcc].length && this.track[xAcc][yAcc]) {
            finished = this.hasMatchOnLine(this.goal, xCur, yCur, xAcc, yAcc);
            succ = new RacetrackState(xAcc, yAcc, state.gethSpeed() + action.gethAcceleration(), state.getvSpeed() + action.getvAcceleration(), true, finished, false);
            if (out.containsKey(succ)) {
                out.put(succ, (Double)out.get(succ) + this.successRate);
            } else {
                out.put(succ, this.successRate);
            }
        } else {
            double prob = this.successRate / (double)this.possibleInitStates.size();
            for (RacetrackState initState : this.possibleInitStates) {
                crashState = new RacetrackState(initState.getX(), initState.getY(), 0, 0, true, false, true);
                out.put(crashState, (Double)out.get(crashState) + prob);
            }
        }
        return out;
    }

    @Override
    public Double getScore(RacetrackState state, RacetrackAction action, RacetrackState successor) {
        double rawScore = successor.isCrashed() ? 100.0 : 1.0;
        return rawScore / 100.0;
    }

    static {
        for (int vAcc = -1; vAcc < 2; ++vAcc) {
            for (int hAcc = -1; hAcc < 2; ++hAcc) {
                POSSIBLE_ACTIONS.add(new RacetrackAction(hAcc, vAcc));
            }
        }
    }
}

