/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.search.exampleproblems.randomtrees;

import ai.libs.jaicore.search.model.NodeExpansionDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.api4.java.datastructure.graph.implicit.IGraphGenerator;
import org.api4.java.datastructure.graph.implicit.ISingleRootGenerator;
import org.api4.java.datastructure.graph.implicit.ISuccessorGenerator;

public class RandomTreeGraphGenerator
implements IGraphGenerator<List<Integer>, Integer> {
    private final int b;
    private final int d;
    private final long seed;
    private final int maxPerDepth;

    public RandomTreeGraphGenerator(int b, int d, long seed, int maxPerDepth) {
        this.b = b;
        this.d = d;
        this.seed = seed;
        this.maxPerDepth = maxPerDepth;
    }

    public ISingleRootGenerator<List<Integer>> getRootGenerator() {
        return () -> Arrays.asList(new Integer[0]);
    }

    public ISuccessorGenerator<List<Integer>, Integer> getSuccessorGenerator() {
        return n -> {
            ArrayList l = new ArrayList();
            if (n.size() == this.d) {
                return l;
            }
            for (int i = 0; i < this.b; ++i) {
                ArrayList<Integer> nP = new ArrayList<Integer>((Collection<Integer>)n);
                nP.add((int)((double)i * 1.0 * (double)this.maxPerDepth + (double)new Random(this.seed + (long)(i * n.hashCode()) + (long)this.b).nextInt(this.maxPerDepth)) / this.b);
                l.add(new NodeExpansionDescription(nP, i));
            }
            return l;
        };
    }
}

